/*
YUI 3.11.0 (build d549e5c)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/promise/promise.js']) {
   __coverage__['build/promise/promise.js'] = {"path":"build/promise/promise.js","s":{"1":0,"2":1,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":1,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0,"50":0,"51":0,"52":0,"53":0,"54":0,"55":0,"56":0,"57":0,"58":0,"59":0,"60":0,"61":0,"62":0,"63":0,"64":0,"65":0,"66":0,"67":0,"68":0,"69":0,"70":0,"71":0,"72":0,"73":1,"74":0,"75":0,"76":0,"77":0,"78":0,"79":0,"80":0,"81":0,"82":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0],"13":[0,0],"14":[0,0],"15":[0,0],"16":[0,0],"17":[0,0],"18":[0,0],"19":[0,0],"20":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":19},"end":{"line":1,"column":38}}},"2":{"name":"Promise","line":55,"loc":{"start":{"line":55,"column":0},"end":{"line":55,"column":21}}},"3":{"name":"(anonymous_3)","line":71,"loc":{"start":{"line":71,"column":18},"end":{"line":71,"column":35}}},"4":{"name":"(anonymous_4)","line":73,"loc":{"start":{"line":73,"column":7},"end":{"line":73,"column":25}}},"5":{"name":"(anonymous_5)","line":96,"loc":{"start":{"line":96,"column":10},"end":{"line":96,"column":39}}},"6":{"name":"(anonymous_6)","line":107,"loc":{"start":{"line":107,"column":15},"end":{"line":107,"column":27}}},"7":{"name":"(anonymous_7)","line":123,"loc":{"start":{"line":123,"column":20},"end":{"line":123,"column":35}}},"8":{"name":"Resolver","line":140,"loc":{"start":{"line":140,"column":0},"end":{"line":140,"column":27}}},"9":{"name":"(anonymous_9)","line":189,"loc":{"start":{"line":189,"column":13},"end":{"line":189,"column":30}}},"10":{"name":"(anonymous_10)","line":222,"loc":{"start":{"line":222,"column":12},"end":{"line":222,"column":30}}},"11":{"name":"(anonymous_11)","line":254,"loc":{"start":{"line":254,"column":10},"end":{"line":254,"column":39}}},"12":{"name":"(anonymous_12)","line":266,"loc":{"start":{"line":266,"column":43},"end":{"line":266,"column":70}}},"13":{"name":"(anonymous_13)","line":307,"loc":{"start":{"line":307,"column":11},"end":{"line":307,"column":50}}},"14":{"name":"(anonymous_14)","line":309,"loc":{"start":{"line":309,"column":15},"end":{"line":309,"column":40}}},"15":{"name":"(anonymous_15)","line":347,"loc":{"start":{"line":347,"column":15},"end":{"line":347,"column":27}}},"16":{"name":"(anonymous_16)","line":360,"loc":{"start":{"line":360,"column":13},"end":{"line":360,"column":37}}},"17":{"name":"(anonymous_17)","line":369,"loc":{"start":{"line":369,"column":19},"end":{"line":369,"column":31}}},"18":{"name":"(anonymous_18)","line":399,"loc":{"start":{"line":399,"column":9},"end":{"line":399,"column":47}}},"19":{"name":"(anonymous_19)","line":405,"loc":{"start":{"line":405,"column":32},"end":{"line":405,"column":51}}},"20":{"name":"(anonymous_20)","line":425,"loc":{"start":{"line":425,"column":10},"end":{"line":425,"column":22}}},"21":{"name":"(anonymous_21)","line":432,"loc":{"start":{"line":432,"column":25},"end":{"line":432,"column":52}}},"22":{"name":"oneDone","line":435,"loc":{"start":{"line":435,"column":8},"end":{"line":435,"column":32}}},"23":{"name":"(anonymous_23)","line":436,"loc":{"start":{"line":436,"column":19},"end":{"line":436,"column":36}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":458,"column":39}},"2":{"start":{"line":55,"column":0},"end":{"line":76,"column":1}},"3":{"start":{"line":56,"column":4},"end":{"line":58,"column":5}},"4":{"start":{"line":57,"column":8},"end":{"line":57,"column":31}},"5":{"start":{"line":60,"column":4},"end":{"line":60,"column":46}},"6":{"start":{"line":69,"column":4},"end":{"line":69,"column":30}},"7":{"start":{"line":71,"column":4},"end":{"line":75,"column":7}},"8":{"start":{"line":72,"column":8},"end":{"line":72,"column":32}},"9":{"start":{"line":74,"column":8},"end":{"line":74,"column":32}},"10":{"start":{"line":78,"column":0},"end":{"line":110,"column":3}},"11":{"start":{"line":97,"column":8},"end":{"line":97,"column":54}},"12":{"start":{"line":108,"column":8},"end":{"line":108,"column":42}},"13":{"start":{"line":123,"column":0},"end":{"line":128,"column":2}},"14":{"start":{"line":127,"column":4},"end":{"line":127,"column":51}},"15":{"start":{"line":130,"column":0},"end":{"line":130,"column":20}},"16":{"start":{"line":140,"column":0},"end":{"line":177,"column":1}},"17":{"start":{"line":148,"column":4},"end":{"line":148,"column":25}},"18":{"start":{"line":157,"column":4},"end":{"line":157,"column":24}},"19":{"start":{"line":165,"column":4},"end":{"line":165,"column":27}},"20":{"start":{"line":176,"column":4},"end":{"line":176,"column":29}},"21":{"start":{"line":179,"column":0},"end":{"line":379,"column":9}},"22":{"start":{"line":190,"column":8},"end":{"line":192,"column":9}},"23":{"start":{"line":191,"column":12},"end":{"line":191,"column":33}},"24":{"start":{"line":194,"column":8},"end":{"line":210,"column":9}},"25":{"start":{"line":195,"column":12},"end":{"line":195,"column":56}},"26":{"start":{"line":202,"column":12},"end":{"line":202,"column":33}},"27":{"start":{"line":207,"column":12},"end":{"line":207,"column":34}},"28":{"start":{"line":209,"column":12},"end":{"line":209,"column":39}},"29":{"start":{"line":223,"column":8},"end":{"line":225,"column":9}},"30":{"start":{"line":224,"column":12},"end":{"line":224,"column":34}},"31":{"start":{"line":227,"column":8},"end":{"line":235,"column":9}},"32":{"start":{"line":228,"column":12},"end":{"line":228,"column":55}},"33":{"start":{"line":231,"column":12},"end":{"line":231,"column":35}},"34":{"start":{"line":232,"column":12},"end":{"line":232,"column":32}},"35":{"start":{"line":234,"column":12},"end":{"line":234,"column":38}},"36":{"start":{"line":261,"column":8},"end":{"line":272,"column":49}},"37":{"start":{"line":267,"column":16},"end":{"line":267,"column":38}},"38":{"start":{"line":268,"column":16},"end":{"line":268,"column":36}},"39":{"start":{"line":277,"column":8},"end":{"line":278,"column":73}},"40":{"start":{"line":279,"column":8},"end":{"line":280,"column":71}},"41":{"start":{"line":284,"column":8},"end":{"line":288,"column":9}},"42":{"start":{"line":285,"column":12},"end":{"line":285,"column":39}},"43":{"start":{"line":286,"column":15},"end":{"line":288,"column":9}},"44":{"start":{"line":287,"column":12},"end":{"line":287,"column":38}},"45":{"start":{"line":290,"column":8},"end":{"line":290,"column":20}},"46":{"start":{"line":309,"column":8},"end":{"line":337,"column":10}},"47":{"start":{"line":310,"column":12},"end":{"line":310,"column":23}},"48":{"start":{"line":315,"column":12},"end":{"line":324,"column":13}},"49":{"start":{"line":320,"column":16},"end":{"line":320,"column":43}},"50":{"start":{"line":323,"column":16},"end":{"line":323,"column":37}},"51":{"start":{"line":326,"column":12},"end":{"line":336,"column":13}},"52":{"start":{"line":329,"column":16},"end":{"line":329,"column":53}},"53":{"start":{"line":335,"column":16},"end":{"line":335,"column":36}},"54":{"start":{"line":348,"column":8},"end":{"line":348,"column":28}},"55":{"start":{"line":364,"column":8},"end":{"line":376,"column":9}},"56":{"start":{"line":369,"column":12},"end":{"line":375,"column":15}},"57":{"start":{"line":370,"column":16},"end":{"line":370,"column":27}},"58":{"start":{"line":372,"column":16},"end":{"line":374,"column":17}},"59":{"start":{"line":373,"column":20},"end":{"line":373,"column":36}},"60":{"start":{"line":381,"column":0},"end":{"line":381,"column":30}},"61":{"start":{"line":399,"column":0},"end":{"line":411,"column":2}},"62":{"start":{"line":400,"column":4},"end":{"line":400,"column":14}},"63":{"start":{"line":402,"column":4},"end":{"line":408,"column":5}},"64":{"start":{"line":403,"column":8},"end":{"line":403,"column":24}},"65":{"start":{"line":405,"column":8},"end":{"line":407,"column":11}},"66":{"start":{"line":406,"column":12},"end":{"line":406,"column":27}},"67":{"start":{"line":410,"column":4},"end":{"line":410,"column":77}},"68":{"start":{"line":412,"column":0},"end":{"line":412,"column":21}},"69":{"start":{"line":425,"column":0},"end":{"line":455,"column":2}},"70":{"start":{"line":426,"column":4},"end":{"line":430,"column":23}},"71":{"start":{"line":432,"column":4},"end":{"line":454,"column":7}},"72":{"start":{"line":433,"column":8},"end":{"line":433,"column":27}},"73":{"start":{"line":435,"column":8},"end":{"line":445,"column":9}},"74":{"start":{"line":436,"column":12},"end":{"line":444,"column":14}},"75":{"start":{"line":437,"column":16},"end":{"line":437,"column":39}},"76":{"start":{"line":439,"column":16},"end":{"line":439,"column":28}},"77":{"start":{"line":441,"column":16},"end":{"line":443,"column":17}},"78":{"start":{"line":442,"column":20},"end":{"line":442,"column":37}},"79":{"start":{"line":447,"column":8},"end":{"line":449,"column":9}},"80":{"start":{"line":448,"column":12},"end":{"line":448,"column":36}},"81":{"start":{"line":451,"column":8},"end":{"line":453,"column":9}},"82":{"start":{"line":452,"column":12},"end":{"line":452,"column":49}}},"branchMap":{"1":{"line":56,"type":"if","locations":[{"start":{"line":56,"column":4},"end":{"line":56,"column":4}},{"start":{"line":56,"column":4},"end":{"line":56,"column":4}}]},"2":{"line":127,"type":"binary-expr","locations":[{"start":{"line":127,"column":11},"end":{"line":127,"column":16}},{"start":{"line":127,"column":20},"end":{"line":127,"column":50}}]},"3":{"line":190,"type":"if","locations":[{"start":{"line":190,"column":8},"end":{"line":190,"column":8}},{"start":{"line":190,"column":8},"end":{"line":190,"column":8}}]},"4":{"line":194,"type":"if","locations":[{"start":{"line":194,"column":8},"end":{"line":194,"column":8}},{"start":{"line":194,"column":8},"end":{"line":194,"column":8}}]},"5":{"line":223,"type":"if","locations":[{"start":{"line":223,"column":8},"end":{"line":223,"column":8}},{"start":{"line":223,"column":8},"end":{"line":223,"column":8}}]},"6":{"line":227,"type":"if","locations":[{"start":{"line":227,"column":8},"end":{"line":227,"column":8}},{"start":{"line":227,"column":8},"end":{"line":227,"column":8}}]},"7":{"line":271,"type":"binary-expr","locations":[{"start":{"line":271,"column":27},"end":{"line":271,"column":42}},{"start":{"line":271,"column":46},"end":{"line":271,"column":48}}]},"8":{"line":272,"type":"binary-expr","locations":[{"start":{"line":272,"column":27},"end":{"line":272,"column":41}},{"start":{"line":272,"column":46},"end":{"line":272,"column":48}}]},"9":{"line":277,"type":"cond-expr","locations":[{"start":{"line":278,"column":12},"end":{"line":278,"column":57}},{"start":{"line":278,"column":60},"end":{"line":278,"column":71}}]},"10":{"line":279,"type":"cond-expr","locations":[{"start":{"line":280,"column":12},"end":{"line":280,"column":56}},{"start":{"line":280,"column":59},"end":{"line":280,"column":69}}]},"11":{"line":284,"type":"if","locations":[{"start":{"line":284,"column":8},"end":{"line":284,"column":8}},{"start":{"line":284,"column":8},"end":{"line":284,"column":8}}]},"12":{"line":286,"type":"if","locations":[{"start":{"line":286,"column":15},"end":{"line":286,"column":15}},{"start":{"line":286,"column":15},"end":{"line":286,"column":15}}]},"13":{"line":326,"type":"if","locations":[{"start":{"line":326,"column":12},"end":{"line":326,"column":12}},{"start":{"line":326,"column":12},"end":{"line":326,"column":12}}]},"14":{"line":364,"type":"if","locations":[{"start":{"line":364,"column":8},"end":{"line":364,"column":8}},{"start":{"line":364,"column":8},"end":{"line":364,"column":8}}]},"15":{"line":402,"type":"if","locations":[{"start":{"line":402,"column":4},"end":{"line":402,"column":4}},{"start":{"line":402,"column":4},"end":{"line":402,"column":4}}]},"16":{"line":410,"type":"cond-expr","locations":[{"start":{"line":410,"column":35},"end":{"line":410,"column":66}},{"start":{"line":410,"column":69},"end":{"line":410,"column":76}}]},"17":{"line":410,"type":"binary-expr","locations":[{"start":{"line":410,"column":12},"end":{"line":410,"column":20}},{"start":{"line":410,"column":24},"end":{"line":410,"column":31}}]},"18":{"line":441,"type":"if","locations":[{"start":{"line":441,"column":16},"end":{"line":441,"column":16}},{"start":{"line":441,"column":16},"end":{"line":441,"column":16}}]},"19":{"line":441,"type":"binary-expr","locations":[{"start":{"line":441,"column":20},"end":{"line":441,"column":30}},{"start":{"line":441,"column":34},"end":{"line":441,"column":68}}]},"20":{"line":447,"type":"if","locations":[{"start":{"line":447,"column":8},"end":{"line":447,"column":8}},{"start":{"line":447,"column":8},"end":{"line":447,"column":8}}]}},"code":["(function () { YUI.add('promise', function (Y, NAME) {","","/**","Wraps the execution of asynchronous operations, providing a promise object that","can be used to subscribe to the various ways the operation may terminate.","","When the operation completes successfully, call the Resolver's `fulfill()`","method, passing any relevant response data for subscribers.  If the operation","encounters an error or is unsuccessful in some way, call `reject()`, again","passing any relevant data for subscribers.","","The Resolver object should be shared only with the code resposible for","resolving or rejecting it. Public access for the Resolver is through its","_promise_, which is returned from the Resolver's `promise` property. While both","Resolver and promise allow subscriptions to the Resolver's state changes, the","promise may be exposed to non-controlling code. It is the preferable interface","for adding subscriptions.","","Subscribe to state changes in the Resolver with the promise's","`then(callback, errback)` method.  `then()` wraps the passed callbacks in a","new Resolver and returns the corresponding promise, allowing chaining of","asynchronous or synchronous operations. E.g.","`promise.then(someAsyncFunc).then(anotherAsyncFunc)`","","@module promise","@since 3.9.0","**/","","/**","A promise represents a value that may not yet be available. Promises allow","you to chain asynchronous operations, write synchronous looking code and","handle errors throughout the process.","","This constructor takes a function as a parameter where you can insert the logic","that fulfills or rejects this promise. The fulfillment value and the rejection","reason can be any JavaScript value. It's encouraged that rejection reasons be","error objects","","<pre><code>","var fulfilled = new Y.Promise(function (fulfill) {","    fulfill('I am a fulfilled promise');","});","","var rejected = new Y.Promise(function (fulfill, reject) {","    reject(new Error('I am a rejected promise'));","});","</code></pre>","","@class Promise","@constructor","@param {Function} fn A function where to insert the logic that resolves this","        promise. Receives `fulfill` and `reject` functions as parameters.","        This function is called synchronously.","**/","function Promise(fn) {","    if (!(this instanceof Promise)) {","        return new Promise(fn);","    }","","    var resolver = new Promise.Resolver(this);","","    /**","    A reference to the resolver object that handles this promise","    ","    @property _resolver","    @type Object","    @private","    */","    this._resolver = resolver;","","    fn.call(this, function (value) {","        resolver.fulfill(value);","    }, function (reason) {","        resolver.reject(reason);","    });","}","","Y.mix(Promise.prototype, {","    /**","    Schedule execution of a callback to either or both of \"fulfill\" and","    \"reject\" resolutions for this promise. The callbacks are wrapped in a new","    promise and that promise is returned.  This allows operation chaining ala","    `functionA().then(functionB).then(functionC)` where `functionA` returns","    a promise, and `functionB` and `functionC` _may_ return promises.","","    Asynchronicity of the callbacks is guaranteed.","","    @method then","    @param {Function} [callback] function to execute if the promise","                resolves successfully","    @param {Function} [errback] function to execute if the promise","                resolves unsuccessfully","    @return {Promise} A promise wrapping the resolution of either \"resolve\" or","                \"reject\" callback","    **/","    then: function (callback, errback) {","        return this._resolver.then(callback, errback);","    },","","    /**","    Returns the current status of the operation. Possible results are","    \"pending\", \"fulfilled\", and \"rejected\".","","    @method getStatus","    @return {String}","    **/","    getStatus: function () {","        return this._resolver.getStatus();","    }","});","","/**","Checks if an object or value is a promise. This is cross-implementation","compatible, so promises returned from other libraries or native components","that are compatible with the Promises A+ spec should be recognized by this","method.","","@method isPromise","@param {Any} obj The object to test","@return {Boolean} Whether the object is a promise or not","@static","**/","Promise.isPromise = function (obj) {","    // We test promises by form to be able to identify other implementations","    // as promises. This is important for cross compatibility and in particular","    // Y.when which should take any kind of promise","    return !!obj && typeof obj.then === 'function';","};","","Y.Promise = Promise;","/**","Represents an asynchronous operation. Provides a","standard API for subscribing to the moment that the operation completes either","successfully (`fulfill()`) or unsuccessfully (`reject()`).","","@class Promise.Resolver","@constructor","@param {Promise} promise The promise instance this resolver will be handling","**/","function Resolver(promise) {","    /**","    List of success callbacks","","    @property _callbacks","    @type Array","    @private","    **/","    this._callbacks = [];","","    /**","    List of failure callbacks","","    @property _errbacks","    @type Array","    @private","    **/","    this._errbacks = [];","","    /**","    The promise for this Resolver.","","    @property promise","    @type Promise","    **/","    this.promise = promise;","","    /**","    The status of the operation. This property may take only one of the following","    values: 'pending', 'fulfilled' or 'rejected'.","","    @property _status","    @type String","    @default 'pending'","    @private","    **/","    this._status = 'pending';","}","","Y.mix(Resolver.prototype, {","    /**","    Resolves the promise, signaling successful completion of the","    represented operation. All \"onFulfilled\" subscriptions are executed and passed","    the value provided to this method. After calling `fulfill()`, `reject()` and","    `notify()` are disabled.","","    @method fulfill","    @param {Any} value Value to pass along to the \"onFulfilled\" subscribers","    **/","    fulfill: function (value) {","        if (this._status === 'pending') {","            this._result = value;","        }","","        if (this._status !== 'rejected') {","            this._notify(this._callbacks, this._result);","","            // Reset the callback list so that future calls to fulfill()","            // won't call the same callbacks again. Promises keep a list","            // of callbacks, they're not the same as events. In practice,","            // calls to fulfill() after the first one should not be made by","            // the user but by then()","            this._callbacks = [];","","            // Once a promise gets fulfilled it can't be rejected, so","            // there is no point in keeping the list. Remove it to help","            // garbage collection","            this._errbacks = null;","","            this._status = 'fulfilled';","        }","    },","","    /**","    Resolves the promise, signaling *un*successful completion of the","    represented operation. All \"onRejected\" subscriptions are executed with","    the value provided to this method. After calling `reject()`, `resolve()`","    and `notify()` are disabled.","","    @method reject","    @param {Any} value Value to pass along to the \"reject\" subscribers","    **/","    reject: function (reason) {","        if (this._status === 'pending') {","            this._result = reason;","        }","","        if (this._status !== 'fulfilled') {","            this._notify(this._errbacks, this._result);","","            // See fulfill()","            this._callbacks = null;","            this._errbacks = [];","","            this._status = 'rejected';","        }","    },","","    /**","    Schedule execution of a callback to either or both of \"resolve\" and","    \"reject\" resolutions for the Resolver.  The callbacks","    are wrapped in a new Resolver and that Resolver's corresponding promise","    is returned.  This allows operation chaining ala","    `functionA().then(functionB).then(functionC)` where `functionA` returns","    a promise, and `functionB` and `functionC` _may_ return promises.","","    @method then","    @param {Function} [callback] function to execute if the Resolver","                resolves successfully","    @param {Function} [errback] function to execute if the Resolver","                resolves unsuccessfully","    @return {Promise} The promise of a new Resolver wrapping the resolution","                of either \"resolve\" or \"reject\" callback","    **/","    then: function (callback, errback) {","        // When the current promise is fulfilled or rejected, either the","        // callback or errback will be executed via the function pushed onto","        // this._callbacks or this._errbacks.  However, to allow then()","        // chaining, the execution of either function needs to be represented","        // by a Resolver (the same Resolver can represent both flow paths), and","        // its promise returned.","        var promise = this.promise,","            thenFulfill, thenReject,","","            // using promise constructor allows for customized promises to be","            // returned instead of plain ones","            then = new promise.constructor(function (fulfill, reject) {","                thenFulfill = fulfill;","                thenReject = reject;","            }),","","            callbackList = this._callbacks || [],","            errbackList  = this._errbacks  || [];","","        // Because the callback and errback are represented by a Resolver, it","        // must be fulfilled or rejected to propagate through the then() chain.","        // The same logic applies to resolve() and reject() for fulfillment.","        callbackList.push(typeof callback === 'function' ?","            this._wrap(thenFulfill, thenReject, callback) : thenFulfill);","        errbackList.push(typeof errback === 'function' ?","            this._wrap(thenFulfill, thenReject, errback) : thenReject);","","        // If a promise is already fulfilled or rejected, notify the newly added","        // callbacks by calling fulfill() or reject()","        if (this._status === 'fulfilled') {","            this.fulfill(this._result);","        } else if (this._status === 'rejected') {","            this.reject(this._result);","        }","","        return then;","    },","","    /**","    Wraps the callback in Y.soon to guarantee its asynchronous execution. It","    also catches exceptions to turn them into rejections and links promises","    returned from the `then` callback.","","    @method _wrap","    @param {Function} thenFulfill Fulfillment function of the resolver that","                        handles this promise","    @param {Function} thenReject Rejection function of the resolver that","                        handles this promise","    @param {Function} fn Callback to wrap","    @return {Function}","    @private","    **/","    _wrap: function (thenFulfill, thenReject, fn) {","        // callbacks and errbacks only get one argument","        return function (valueOrReason) {","            var result;","","            // Promises model exception handling through callbacks","            // making both synchronous and asynchronous errors behave","            // the same way","            try {","                // Use the argument coming in to the callback/errback from the","                // resolution of the parent promise.","                // The function must be called as a normal function, with no","                // special value for |this|, as per Promises A+","                result = fn(valueOrReason);","            } catch (e) {","                // calling return only to stop here","                return thenReject(e);","            }","","            if (Promise.isPromise(result)) {","                // Returning a promise from a callback makes the current","                // promise sync up with the returned promise","                result.then(thenFulfill, thenReject);","            } else {","                // Non-promise return values always trigger resolve()","                // because callback is affirmative, and errback is","                // recovery.  To continue on the rejection path, errbacks","                // must return rejected promises or throw.","                thenFulfill(result);","            }","        };","    },","","    /**","    Returns the current status of the Resolver as a string \"pending\",","    \"fulfilled\", or \"rejected\".","","    @method getStatus","    @return {String}","    **/","    getStatus: function () {","        return this._status;","    },","","    /**","    Executes an array of callbacks from a specified context, passing a set of","    arguments.","","    @method _notify","    @param {Function[]} subs The array of subscriber callbacks","    @param {Any} result Value to pass the callbacks","    @protected","    **/","    _notify: function (subs, result) {","        // Since callback lists are reset synchronously, the subs list never","        // changes after _notify() receives it. Avoid calling Y.soon() for","        // an empty list","        if (subs.length) {","            // Calling all callbacks after Y.soon to guarantee","            // asynchronicity. Because setTimeout can cause unnecessary","            // delays that *can* become noticeable in some situations","            // (especially in Node.js)","            Y.soon(function () {","                var i, len;","","                for (i = 0, len = subs.length; i < len; ++i) {","                    subs[i](result);","                }","            });","        }","    }","","}, true);","","Y.Promise.Resolver = Resolver;","/**","Abstraction API allowing you to interact with promises or raw values as if they","were promises. If a non-promise object is passed in, a new Resolver is created","and scheduled to resolve asynchronously with the provided value.","","In either case, a promise is returned.  If either _callback_ or _errback_ are","provided, the promise returned is the one returned from calling","`promise.then(callback, errback)` on the provided or created promise.  If neither","are provided, the original promise is returned.","","@for YUI","@method when","@param {Any} promise Promise object or value to wrap in a resolved promise","@param {Function} [callback] callback to execute if the promise is resolved","@param {Function} [errback] callback to execute if the promise is rejected","@return {Promise}","**/","Y.when = function (promise, callback, errback) {","    var value;","","    if (!Y.Promise.isPromise(promise)) {","        value = promise;","","        promise = new Y.Promise(function (fulfill) {","            fulfill(value);","        });","    }","","    return (callback || errback) ? promise.then(callback, errback) : promise;","};","var slice = [].slice;","","/**","Returns a new promise that will be resolved when all operations have completed.","Takes both any numer of values as arguments. If an argument is a not a promise,","it will be wrapped in a new promise, same as in `Y.when()`.","","@for YUI","@method batch","@param {Any} operation* Any number of Y.Promise objects or regular JS values","@return {Promise} Promise to be fulfilled when all provided promises are","                    resolved","**/","Y.batch = function () {","    var funcs     = slice.call(arguments),","        remaining = funcs.length,","        i         = 0,","        length    = funcs.length,","        results   = [];","","    return new Y.Promise(function (fulfill, reject) {","        var allDone = this;","","        function oneDone(index) {","            return function (value) {","                results[index] = value;","","                remaining--;","","                if (!remaining && allDone.getStatus() !== 'rejected') {","                    fulfill(results);","                }","            };","        }","","        if (length < 1) {","            return fulfill(results);","        }","","        for (; i < length; i++) {","            Y.when(funcs[i], oneDone(i), reject);","        }","    });","};","","","}, '3.11.0', {\"requires\": [\"timers\"]});","","}());"]};
}
var __cov_bUr1a4oWeLtiaZGIeajdgQ = __coverage__['build/promise/promise.js'];
__cov_bUr1a4oWeLtiaZGIeajdgQ.s['1']++;YUI.add('promise',function(Y,NAME){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['1']++;function Promise(fn){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['2']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['3']++;if(!(this instanceof Promise)){__cov_bUr1a4oWeLtiaZGIeajdgQ.b['1'][0]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['4']++;return new Promise(fn);}else{__cov_bUr1a4oWeLtiaZGIeajdgQ.b['1'][1]++;}__cov_bUr1a4oWeLtiaZGIeajdgQ.s['5']++;var resolver=new Promise.Resolver(this);__cov_bUr1a4oWeLtiaZGIeajdgQ.s['6']++;this._resolver=resolver;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['7']++;fn.call(this,function(value){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['3']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['8']++;resolver.fulfill(value);},function(reason){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['4']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['9']++;resolver.reject(reason);});}__cov_bUr1a4oWeLtiaZGIeajdgQ.s['10']++;Y.mix(Promise.prototype,{then:function(callback,errback){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['5']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['11']++;return this._resolver.then(callback,errback);},getStatus:function(){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['6']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['12']++;return this._resolver.getStatus();}});__cov_bUr1a4oWeLtiaZGIeajdgQ.s['13']++;Promise.isPromise=function(obj){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['7']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['14']++;return(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['2'][0]++,!!obj)&&(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['2'][1]++,typeof obj.then==='function');};__cov_bUr1a4oWeLtiaZGIeajdgQ.s['15']++;Y.Promise=Promise;function Resolver(promise){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['8']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['17']++;this._callbacks=[];__cov_bUr1a4oWeLtiaZGIeajdgQ.s['18']++;this._errbacks=[];__cov_bUr1a4oWeLtiaZGIeajdgQ.s['19']++;this.promise=promise;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['20']++;this._status='pending';}__cov_bUr1a4oWeLtiaZGIeajdgQ.s['21']++;Y.mix(Resolver.prototype,{fulfill:function(value){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['9']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['22']++;if(this._status==='pending'){__cov_bUr1a4oWeLtiaZGIeajdgQ.b['3'][0]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['23']++;this._result=value;}else{__cov_bUr1a4oWeLtiaZGIeajdgQ.b['3'][1]++;}__cov_bUr1a4oWeLtiaZGIeajdgQ.s['24']++;if(this._status!=='rejected'){__cov_bUr1a4oWeLtiaZGIeajdgQ.b['4'][0]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['25']++;this._notify(this._callbacks,this._result);__cov_bUr1a4oWeLtiaZGIeajdgQ.s['26']++;this._callbacks=[];__cov_bUr1a4oWeLtiaZGIeajdgQ.s['27']++;this._errbacks=null;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['28']++;this._status='fulfilled';}else{__cov_bUr1a4oWeLtiaZGIeajdgQ.b['4'][1]++;}},reject:function(reason){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['10']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['29']++;if(this._status==='pending'){__cov_bUr1a4oWeLtiaZGIeajdgQ.b['5'][0]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['30']++;this._result=reason;}else{__cov_bUr1a4oWeLtiaZGIeajdgQ.b['5'][1]++;}__cov_bUr1a4oWeLtiaZGIeajdgQ.s['31']++;if(this._status!=='fulfilled'){__cov_bUr1a4oWeLtiaZGIeajdgQ.b['6'][0]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['32']++;this._notify(this._errbacks,this._result);__cov_bUr1a4oWeLtiaZGIeajdgQ.s['33']++;this._callbacks=null;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['34']++;this._errbacks=[];__cov_bUr1a4oWeLtiaZGIeajdgQ.s['35']++;this._status='rejected';}else{__cov_bUr1a4oWeLtiaZGIeajdgQ.b['6'][1]++;}},then:function(callback,errback){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['11']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['36']++;var promise=this.promise,thenFulfill,thenReject,then=new promise.constructor(function(fulfill,reject){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['12']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['37']++;thenFulfill=fulfill;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['38']++;thenReject=reject;}),callbackList=(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['7'][0]++,this._callbacks)||(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['7'][1]++,[]),errbackList=(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['8'][0]++,this._errbacks)||(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['8'][1]++,[]);__cov_bUr1a4oWeLtiaZGIeajdgQ.s['39']++;callbackList.push(typeof callback==='function'?(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['9'][0]++,this._wrap(thenFulfill,thenReject,callback)):(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['9'][1]++,thenFulfill));__cov_bUr1a4oWeLtiaZGIeajdgQ.s['40']++;errbackList.push(typeof errback==='function'?(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['10'][0]++,this._wrap(thenFulfill,thenReject,errback)):(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['10'][1]++,thenReject));__cov_bUr1a4oWeLtiaZGIeajdgQ.s['41']++;if(this._status==='fulfilled'){__cov_bUr1a4oWeLtiaZGIeajdgQ.b['11'][0]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['42']++;this.fulfill(this._result);}else{__cov_bUr1a4oWeLtiaZGIeajdgQ.b['11'][1]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['43']++;if(this._status==='rejected'){__cov_bUr1a4oWeLtiaZGIeajdgQ.b['12'][0]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['44']++;this.reject(this._result);}else{__cov_bUr1a4oWeLtiaZGIeajdgQ.b['12'][1]++;}}__cov_bUr1a4oWeLtiaZGIeajdgQ.s['45']++;return then;},_wrap:function(thenFulfill,thenReject,fn){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['13']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['46']++;return function(valueOrReason){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['14']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['47']++;var result;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['48']++;try{__cov_bUr1a4oWeLtiaZGIeajdgQ.s['49']++;result=fn(valueOrReason);}catch(e){__cov_bUr1a4oWeLtiaZGIeajdgQ.s['50']++;return thenReject(e);}__cov_bUr1a4oWeLtiaZGIeajdgQ.s['51']++;if(Promise.isPromise(result)){__cov_bUr1a4oWeLtiaZGIeajdgQ.b['13'][0]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['52']++;result.then(thenFulfill,thenReject);}else{__cov_bUr1a4oWeLtiaZGIeajdgQ.b['13'][1]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['53']++;thenFulfill(result);}};},getStatus:function(){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['15']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['54']++;return this._status;},_notify:function(subs,result){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['16']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['55']++;if(subs.length){__cov_bUr1a4oWeLtiaZGIeajdgQ.b['14'][0]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['56']++;Y.soon(function(){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['17']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['57']++;var i,len;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['58']++;for(i=0,len=subs.length;i<len;++i){__cov_bUr1a4oWeLtiaZGIeajdgQ.s['59']++;subs[i](result);}});}else{__cov_bUr1a4oWeLtiaZGIeajdgQ.b['14'][1]++;}}},true);__cov_bUr1a4oWeLtiaZGIeajdgQ.s['60']++;Y.Promise.Resolver=Resolver;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['61']++;Y.when=function(promise,callback,errback){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['18']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['62']++;var value;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['63']++;if(!Y.Promise.isPromise(promise)){__cov_bUr1a4oWeLtiaZGIeajdgQ.b['15'][0]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['64']++;value=promise;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['65']++;promise=new Y.Promise(function(fulfill){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['19']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['66']++;fulfill(value);});}else{__cov_bUr1a4oWeLtiaZGIeajdgQ.b['15'][1]++;}__cov_bUr1a4oWeLtiaZGIeajdgQ.s['67']++;return(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['17'][0]++,callback)||(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['17'][1]++,errback)?(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['16'][0]++,promise.then(callback,errback)):(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['16'][1]++,promise);};__cov_bUr1a4oWeLtiaZGIeajdgQ.s['68']++;var slice=[].slice;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['69']++;Y.batch=function(){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['20']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['70']++;var funcs=slice.call(arguments),remaining=funcs.length,i=0,length=funcs.length,results=[];__cov_bUr1a4oWeLtiaZGIeajdgQ.s['71']++;return new Y.Promise(function(fulfill,reject){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['21']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['72']++;var allDone=this;function oneDone(index){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['22']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['74']++;return function(value){__cov_bUr1a4oWeLtiaZGIeajdgQ.f['23']++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['75']++;results[index]=value;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['76']++;remaining--;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['77']++;if((__cov_bUr1a4oWeLtiaZGIeajdgQ.b['19'][0]++,!remaining)&&(__cov_bUr1a4oWeLtiaZGIeajdgQ.b['19'][1]++,allDone.getStatus()!=='rejected')){__cov_bUr1a4oWeLtiaZGIeajdgQ.b['18'][0]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['78']++;fulfill(results);}else{__cov_bUr1a4oWeLtiaZGIeajdgQ.b['18'][1]++;}};}__cov_bUr1a4oWeLtiaZGIeajdgQ.s['79']++;if(length<1){__cov_bUr1a4oWeLtiaZGIeajdgQ.b['20'][0]++;__cov_bUr1a4oWeLtiaZGIeajdgQ.s['80']++;return fulfill(results);}else{__cov_bUr1a4oWeLtiaZGIeajdgQ.b['20'][1]++;}__cov_bUr1a4oWeLtiaZGIeajdgQ.s['81']++;for(;i<length;i++){__cov_bUr1a4oWeLtiaZGIeajdgQ.s['82']++;Y.when(funcs[i],oneDone(i),reject);}});};},'3.11.0',{'requires':['timers']});
