/*
YUI 3.11.0 (build d549e5c)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/axis-category-base/axis-category-base.js']) {
   __coverage__['build/axis-category-base/axis-category-base.js'] = {"path":"build/axis-category-base/axis-category-base.js","s":{"1":0,"2":1,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":30},"end":{"line":1,"column":49}}},"2":{"name":"CategoryImpl","line":21,"loc":{"start":{"line":21,"column":0},"end":{"line":22,"column":0}}},"3":{"name":"(anonymous_3)","line":59,"loc":{"start":{"line":59,"column":17},"end":{"line":60,"column":4}}},"4":{"name":"(anonymous_4)","line":96,"loc":{"start":{"line":96,"column":22},"end":{"line":97,"column":4}}},"5":{"name":"(anonymous_5)","line":111,"loc":{"start":{"line":111,"column":18},"end":{"line":112,"column":4}}},"6":{"name":"(anonymous_6)","line":139,"loc":{"start":{"line":139,"column":18},"end":{"line":140,"column":4}}},"7":{"name":"(anonymous_7)","line":161,"loc":{"start":{"line":161,"column":24},"end":{"line":162,"column":4}}},"8":{"name":"(anonymous_8)","line":174,"loc":{"start":{"line":174,"column":19},"end":{"line":175,"column":4}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":201,"column":42}},"2":{"start":{"line":21,"column":0},"end":{"line":23,"column":1}},"3":{"start":{"line":25,"column":0},"end":{"line":25,"column":35}},"4":{"start":{"line":27,"column":0},"end":{"line":49,"column":2}},"5":{"start":{"line":51,"column":0},"end":{"line":184,"column":2}},"6":{"start":{"line":61,"column":8},"end":{"line":61,"column":19}},"7":{"start":{"line":98,"column":8},"end":{"line":98,"column":69}},"8":{"start":{"line":99,"column":8},"end":{"line":99,"column":30}},"9":{"start":{"line":113,"column":8},"end":{"line":117,"column":30}},"10":{"start":{"line":118,"column":8},"end":{"line":121,"column":9}},"11":{"start":{"line":120,"column":12},"end":{"line":120,"column":31}},"12":{"start":{"line":122,"column":8},"end":{"line":127,"column":9}},"13":{"start":{"line":124,"column":12},"end":{"line":124,"column":26}},"14":{"start":{"line":125,"column":12},"end":{"line":125,"column":26}},"15":{"start":{"line":126,"column":12},"end":{"line":126,"column":33}},"16":{"start":{"line":128,"column":8},"end":{"line":128,"column":36}},"17":{"start":{"line":129,"column":8},"end":{"line":129,"column":22}},"18":{"start":{"line":141,"column":8},"end":{"line":144,"column":9}},"19":{"start":{"line":143,"column":12},"end":{"line":143,"column":29}},"20":{"start":{"line":145,"column":8},"end":{"line":145,"column":33}},"21":{"start":{"line":146,"column":8},"end":{"line":149,"column":9}},"22":{"start":{"line":148,"column":12},"end":{"line":148,"column":31}},"23":{"start":{"line":150,"column":8},"end":{"line":150,"column":20}},"24":{"start":{"line":163,"column":8},"end":{"line":163,"column":39}},"25":{"start":{"line":176,"column":8},"end":{"line":177,"column":36}},"26":{"start":{"line":178,"column":8},"end":{"line":181,"column":9}},"27":{"start":{"line":180,"column":12},"end":{"line":180,"column":37}},"28":{"start":{"line":182,"column":8},"end":{"line":182,"column":21}},"29":{"start":{"line":186,"column":0},"end":{"line":186,"column":30}},"30":{"start":{"line":198,"column":0},"end":{"line":198,"column":85}}},"branchMap":{"1":{"line":118,"type":"if","locations":[{"start":{"line":118,"column":8},"end":{"line":118,"column":8}},{"start":{"line":118,"column":8},"end":{"line":118,"column":8}}]},"2":{"line":141,"type":"if","locations":[{"start":{"line":141,"column":8},"end":{"line":141,"column":8}},{"start":{"line":141,"column":8},"end":{"line":141,"column":8}}]},"3":{"line":146,"type":"if","locations":[{"start":{"line":146,"column":8},"end":{"line":146,"column":8}},{"start":{"line":146,"column":8},"end":{"line":146,"column":8}}]},"4":{"line":146,"type":"binary-expr","locations":[{"start":{"line":146,"column":11},"end":{"line":146,"column":15}},{"start":{"line":146,"column":19},"end":{"line":146,"column":30}}]},"5":{"line":178,"type":"if","locations":[{"start":{"line":178,"column":8},"end":{"line":178,"column":8}},{"start":{"line":178,"column":8},"end":{"line":178,"column":8}}]},"6":{"line":178,"type":"binary-expr","locations":[{"start":{"line":178,"column":11},"end":{"line":178,"column":20}},{"start":{"line":178,"column":24},"end":{"line":178,"column":40}}]}},"code":["(function () { YUI.add('axis-category-base', function (Y, NAME) {","","/**"," * Provides functionality for the handling of category axis data for a chart."," *"," * @module charts"," * @submodule axis-category-base"," */","","/**"," * CategoryImpl contains logic for managing category data. CategoryImpl is used by the following classes:"," * <ul>"," *      <li>{{#crossLink \"CategoryAxisBase\"}}{{/crossLink}}</li>"," *      <li>{{#crossLink \"CategoryAxis\"}}{{/crossLink}}</li>"," *  </ul>"," *"," * @class CategoryImpl"," * @constructor"," * @submodule axis-category-base"," */","function CategoryImpl()","{","}","","CategoryImpl.NAME = \"categoryImpl\";","","CategoryImpl.ATTRS = {","    /**","     * Determines whether and offset is automatically calculated for the edges of the axis.","     *","     * @attribute calculateEdgeOffset","     * @type Boolean","     */","    calculateEdgeOffset: {","        value: true","    }","","    /**","     * Method used for formatting a label. This attribute allows for the default label formatting method to overridden.","     * The method use would need to implement the arguments below and return a `String` or `HTMLElement`.","     * <dl>","     *      <dt>val</dt><dd>Label to be formatted. (`String`)</dd>","     *      <dt>format</dt><dd>Template for formatting label. (optional)</dd>","     * </dl>","     *","     * @attribute labelFunction","     * @type Function","     */","};","","CategoryImpl.prototype = {","    /**","     * Formats a label based on the axis type and optionally specified format.","     *","     * @method formatLabel","     * @param {Object} value","     * @return String","     */","    formatLabel: function(val)","    {","        return val;","    },","","    /**","     * Object storing key data.","     *","     * @property _indices","     * @private","     */","    _indices: null,","","    /**","     * Constant used to generate unique id.","     *","     * @property GUID","     * @type String","     * @private","     */","    GUID: \"yuicategoryaxis\",","","    /**","     * Type of data used in `Data`.","     *","     * @property _dataType","     * @readOnly","     * @private","     */","    _type: \"category\",","","    /**","     * Calculates the maximum and minimum values for the `Data`.","     *","     * @method _updateMinAndMax","     * @private","     */","    _updateMinAndMax: function()","    {","        this._dataMaximum = Math.max(this.get(\"data\").length - 1, 0);","        this._dataMinimum = 0;","    },","","    /**","     * Gets an array of values based on a key.","     *","     * @method _getKeyArray","     * @param {String} key Value key associated with the data array.","     * @param {Array} data Array in which the data resides.","     * @return Array","     * @private","     */","    _getKeyArray: function(key, data)","    {","        var i = 0,","            obj,","            keyArr = [],","            labels = [],","            len = data.length;","        if(!this._indices)","        {","            this._indices = {};","        }","        for(; i < len; ++i)","        {","            obj = data[i];","            keyArr[i] = i;","            labels[i] = obj[key];","        }","        this._indices[key] = keyArr;","        return labels;","    },","","    /**","     * Returns an array of values based on an identifier key.","     *","     * @method getDataByKey","     * @param {String} value value used to identify the array","     * @return Array","     */","    getDataByKey: function (value)","    {","        if(!this._indices)","        {","            this.get(\"keys\");","        }","        var keys = this._indices;","        if(keys && keys[value])","        {","            return keys[value];","        }","        return null;","    },","","    /**","     * Returns the total number of majorUnits that will appear on an axis.","     *","     * @method getTotalMajorUnits","     * @param {Object} majorUnit Object containing properties related to the majorUnit.","     * @param {Number} len Length of the axis.","     * @return Number","     */","    getTotalMajorUnits: function()","    {","        return this.get(\"data\").length;","    },","","    /**","     * Returns a value based of a key value and an index.","     *","     * @method getKeyValueAt","     * @param {String} key value used to look up the correct array","     * @param {Number} index within the array","     * @return String","     */","    getKeyValueAt: function(key, index)","    {","        var value = NaN,","            keys = this.get(\"keys\");","        if(keys[key] && keys[key][index])","        {","            value = keys[key][index];","        }","        return value;","    }","};","","Y.CategoryImpl = CategoryImpl;","","/**"," * CategoryAxisBase manages category data for an axis."," *"," * @class CategoryAxisBase"," * @constructor"," * @extends AxisBase"," * @uses CategoryImpl"," * @param {Object} config (optional) Configuration parameters."," * @submodule axis-category-base"," */","Y.CategoryAxisBase = Y.Base.create(\"categoryAxisBase\", Y.AxisBase, [Y.CategoryImpl]);","","","}, '3.11.0', {\"requires\": [\"axis-base\"]});","","}());"]};
}
var __cov_TfK6OFh2BYyMHxhA$Njz7g = __coverage__['build/axis-category-base/axis-category-base.js'];
__cov_TfK6OFh2BYyMHxhA$Njz7g.s['1']++;YUI.add('axis-category-base',function(Y,NAME){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['1']++;function CategoryImpl(){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['2']++;}__cov_TfK6OFh2BYyMHxhA$Njz7g.s['3']++;CategoryImpl.NAME='categoryImpl';__cov_TfK6OFh2BYyMHxhA$Njz7g.s['4']++;CategoryImpl.ATTRS={calculateEdgeOffset:{value:true}};__cov_TfK6OFh2BYyMHxhA$Njz7g.s['5']++;CategoryImpl.prototype={formatLabel:function(val){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['3']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['6']++;return val;},_indices:null,GUID:'yuicategoryaxis',_type:'category',_updateMinAndMax:function(){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['4']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['7']++;this._dataMaximum=Math.max(this.get('data').length-1,0);__cov_TfK6OFh2BYyMHxhA$Njz7g.s['8']++;this._dataMinimum=0;},_getKeyArray:function(key,data){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['5']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['9']++;var i=0,obj,keyArr=[],labels=[],len=data.length;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['10']++;if(!this._indices){__cov_TfK6OFh2BYyMHxhA$Njz7g.b['1'][0]++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['11']++;this._indices={};}else{__cov_TfK6OFh2BYyMHxhA$Njz7g.b['1'][1]++;}__cov_TfK6OFh2BYyMHxhA$Njz7g.s['12']++;for(;i<len;++i){__cov_TfK6OFh2BYyMHxhA$Njz7g.s['13']++;obj=data[i];__cov_TfK6OFh2BYyMHxhA$Njz7g.s['14']++;keyArr[i]=i;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['15']++;labels[i]=obj[key];}__cov_TfK6OFh2BYyMHxhA$Njz7g.s['16']++;this._indices[key]=keyArr;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['17']++;return labels;},getDataByKey:function(value){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['6']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['18']++;if(!this._indices){__cov_TfK6OFh2BYyMHxhA$Njz7g.b['2'][0]++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['19']++;this.get('keys');}else{__cov_TfK6OFh2BYyMHxhA$Njz7g.b['2'][1]++;}__cov_TfK6OFh2BYyMHxhA$Njz7g.s['20']++;var keys=this._indices;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['21']++;if((__cov_TfK6OFh2BYyMHxhA$Njz7g.b['4'][0]++,keys)&&(__cov_TfK6OFh2BYyMHxhA$Njz7g.b['4'][1]++,keys[value])){__cov_TfK6OFh2BYyMHxhA$Njz7g.b['3'][0]++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['22']++;return keys[value];}else{__cov_TfK6OFh2BYyMHxhA$Njz7g.b['3'][1]++;}__cov_TfK6OFh2BYyMHxhA$Njz7g.s['23']++;return null;},getTotalMajorUnits:function(){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['7']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['24']++;return this.get('data').length;},getKeyValueAt:function(key,index){__cov_TfK6OFh2BYyMHxhA$Njz7g.f['8']++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['25']++;var value=NaN,keys=this.get('keys');__cov_TfK6OFh2BYyMHxhA$Njz7g.s['26']++;if((__cov_TfK6OFh2BYyMHxhA$Njz7g.b['6'][0]++,keys[key])&&(__cov_TfK6OFh2BYyMHxhA$Njz7g.b['6'][1]++,keys[key][index])){__cov_TfK6OFh2BYyMHxhA$Njz7g.b['5'][0]++;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['27']++;value=keys[key][index];}else{__cov_TfK6OFh2BYyMHxhA$Njz7g.b['5'][1]++;}__cov_TfK6OFh2BYyMHxhA$Njz7g.s['28']++;return value;}};__cov_TfK6OFh2BYyMHxhA$Njz7g.s['29']++;Y.CategoryImpl=CategoryImpl;__cov_TfK6OFh2BYyMHxhA$Njz7g.s['30']++;Y.CategoryAxisBase=Y.Base.create('categoryAxisBase',Y.AxisBase,[Y.CategoryImpl]);},'3.11.0',{'requires':['axis-base']});
