/*
YUI 3.11.0 (build d549e5c)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/button/button.js']) {
   __coverage__['build/button/button.js'] = {"path":"build/button/button.js","s":{"1":0,"2":0,"3":1,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":1,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":18},"end":{"line":1,"column":37}}},"2":{"name":"Button","line":23,"loc":{"start":{"line":23,"column":0},"end":{"line":23,"column":18}}},"3":{"name":"(anonymous_3)","line":54,"loc":{"start":{"line":54,"column":17},"end":{"line":54,"column":34}}},"4":{"name":"(anonymous_4)","line":71,"loc":{"start":{"line":71,"column":12},"end":{"line":71,"column":23}}},"5":{"name":"(anonymous_5)","line":81,"loc":{"start":{"line":81,"column":12},"end":{"line":81,"column":23}}},"6":{"name":"(anonymous_6)","line":91,"loc":{"start":{"line":91,"column":23},"end":{"line":91,"column":35}}},"7":{"name":"(anonymous_7)","line":99,"loc":{"start":{"line":99,"column":26},"end":{"line":99,"column":38}}},"8":{"name":"(anonymous_8)","line":151,"loc":{"start":{"line":151,"column":15},"end":{"line":151,"column":30}}},"9":{"name":"(anonymous_9)","line":156,"loc":{"start":{"line":156,"column":18},"end":{"line":156,"column":33}}},"10":{"name":"ToggleButton","line":181,"loc":{"start":{"line":181,"column":0},"end":{"line":181,"column":24}}},"11":{"name":"(anonymous_11)","line":211,"loc":{"start":{"line":211,"column":17},"end":{"line":211,"column":35}}},"12":{"name":"(anonymous_12)","line":229,"loc":{"start":{"line":229,"column":16},"end":{"line":229,"column":28}}},"13":{"name":"(anonymous_13)","line":237,"loc":{"start":{"line":237,"column":12},"end":{"line":237,"column":23}}},"14":{"name":"(anonymous_14)","line":251,"loc":{"start":{"line":251,"column":12},"end":{"line":251,"column":23}}},"15":{"name":"(anonymous_15)","line":269,"loc":{"start":{"line":269,"column":26},"end":{"line":269,"column":37}}},"16":{"name":"(anonymous_16)","line":277,"loc":{"start":{"line":277,"column":20},"end":{"line":277,"column":36}}},"17":{"name":"(anonymous_17)","line":293,"loc":{"start":{"line":293,"column":12},"end":{"line":293,"column":23}}},"18":{"name":"(anonymous_18)","line":342,"loc":{"start":{"line":342,"column":17},"end":{"line":342,"column":32}}},"19":{"name":"(anonymous_19)","line":345,"loc":{"start":{"line":345,"column":17},"end":{"line":345,"column":32}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":382,"column":67}},"2":{"start":{"line":10,"column":0},"end":{"line":12,"column":42}},"3":{"start":{"line":23,"column":0},"end":{"line":25,"column":1}},"4":{"start":{"line":24,"column":4},"end":{"line":24,"column":57}},"5":{"start":{"line":28,"column":0},"end":{"line":169,"column":3}},"6":{"start":{"line":56,"column":8},"end":{"line":56,"column":45}},"7":{"start":{"line":60,"column":8},"end":{"line":62,"column":9}},"8":{"start":{"line":61,"column":12},"end":{"line":61,"column":50}},"9":{"start":{"line":72,"column":8},"end":{"line":72,"column":26}},"10":{"start":{"line":73,"column":8},"end":{"line":73,"column":62}},"11":{"start":{"line":74,"column":8},"end":{"line":74,"column":68}},"12":{"start":{"line":82,"column":8},"end":{"line":82,"column":26}},"13":{"start":{"line":83,"column":8},"end":{"line":83,"column":77}},"14":{"start":{"line":84,"column":8},"end":{"line":84,"column":83}},"15":{"start":{"line":92,"column":8},"end":{"line":92,"column":64}},"16":{"start":{"line":104,"column":8},"end":{"line":104,"column":67}},"17":{"start":{"line":152,"column":12},"end":{"line":152,"column":30}},"18":{"start":{"line":153,"column":12},"end":{"line":153,"column":36}},"19":{"start":{"line":157,"column":12},"end":{"line":157,"column":46}},"20":{"start":{"line":171,"column":0},"end":{"line":171,"column":48}},"21":{"start":{"line":181,"column":0},"end":{"line":183,"column":1}},"22":{"start":{"line":182,"column":4},"end":{"line":182,"column":57}},"23":{"start":{"line":187,"column":0},"end":{"line":375,"column":3}},"24":{"start":{"line":212,"column":8},"end":{"line":215,"column":62}},"25":{"start":{"line":218,"column":8},"end":{"line":220,"column":11}},"26":{"start":{"line":222,"column":8},"end":{"line":222,"column":51}},"27":{"start":{"line":230,"column":8},"end":{"line":230,"column":37}},"28":{"start":{"line":238,"column":9},"end":{"line":239,"column":43}},"29":{"start":{"line":241,"column":8},"end":{"line":241,"column":52}},"30":{"start":{"line":243,"column":8},"end":{"line":243,"column":53}},"31":{"start":{"line":244,"column":8},"end":{"line":244,"column":86}},"32":{"start":{"line":252,"column":8},"end":{"line":257,"column":55}},"33":{"start":{"line":259,"column":8},"end":{"line":259,"column":52}},"34":{"start":{"line":261,"column":8},"end":{"line":261,"column":29}},"35":{"start":{"line":262,"column":8},"end":{"line":262,"column":60}},"36":{"start":{"line":270,"column":8},"end":{"line":270,"column":38}},"37":{"start":{"line":278,"column":8},"end":{"line":282,"column":80}},"38":{"start":{"line":284,"column":8},"end":{"line":284,"column":59}},"39":{"start":{"line":285,"column":8},"end":{"line":285,"column":33}},"40":{"start":{"line":294,"column":8},"end":{"line":294,"column":26}},"41":{"start":{"line":295,"column":8},"end":{"line":295,"column":83}},"42":{"start":{"line":343,"column":12},"end":{"line":343,"column":55}},"43":{"start":{"line":346,"column":12},"end":{"line":346,"column":55}},"44":{"start":{"line":378,"column":0},"end":{"line":378,"column":18}},"45":{"start":{"line":379,"column":0},"end":{"line":379,"column":30}}},"branchMap":{"1":{"line":60,"type":"if","locations":[{"start":{"line":60,"column":8},"end":{"line":60,"column":8}},{"start":{"line":60,"column":8},"end":{"line":60,"column":8}}]},"2":{"line":214,"type":"cond-expr","locations":[{"start":{"line":214,"column":54},"end":{"line":214,"column":63}},{"start":{"line":214,"column":66},"end":{"line":214,"column":75}}]},"3":{"line":215,"type":"binary-expr","locations":[{"start":{"line":215,"column":28},"end":{"line":215,"column":52}},{"start":{"line":215,"column":56},"end":{"line":215,"column":61}}]},"4":{"line":256,"type":"cond-expr","locations":[{"start":{"line":256,"column":42},"end":{"line":256,"column":56}},{"start":{"line":256,"column":59},"end":{"line":256,"column":71}}]},"5":{"line":282,"type":"cond-expr","locations":[{"start":{"line":282,"column":47},"end":{"line":282,"column":61}},{"start":{"line":282,"column":64},"end":{"line":282,"column":78}}]}},"code":["(function () { YUI.add('button', function (Y, NAME) {","","/**"," * A Button Widget"," *"," * @module button"," * @since 3.5.0"," */","","var CLASS_NAMES = Y.ButtonCore.CLASS_NAMES,","    ARIA_STATES = Y.ButtonCore.ARIA_STATES,","    ARIA_ROLES  = Y.ButtonCore.ARIA_ROLES;","","/**"," * Creates a Button"," *"," * @class Button"," * @extends Widget"," * @uses ButtonCore"," * @param config {Object} Configuration object"," * @constructor"," */","function Button() {","    Button.superclass.constructor.apply(this, arguments);","}","","/* Button extends Widget */","Y.extend(Button, Y.Widget,  {","","    /**","     * Bounding box template that will contain the Button's DOM subtree.","     *","     * @property BOUNDING_TEMPLATE","     * @type {String}","     * @default <button/>","     */","    BOUNDING_TEMPLATE : Y.ButtonCore.prototype.TEMPLATE,","","    /**","     * Content box template","     *","     * @property CONTENT_TEMPLATE","     * @type {String}","     * @default null","     */","    CONTENT_TEMPLATE  : null,","","    /**","     * @method initializer","     * @description Internal init() handler.","     * @param config {Object} Config object.","     * @private","     */","    initializer: function(config) {","        // ButtonCore requires this","        this._host = this.get('boundingBox');","","        // A workaround until there's a better way to handle setting Node attributes","        // via HTML parsing in classes that extend Widget","        if (config.disabled) {","            this.set('disabled', config.disabled);","        }","    },","","    /**","     * bindUI implementation","     *","     * @description Hooks up events for the widget","     * @method bindUI","     */","    bindUI: function() {","        var button = this;","        button.after('labelChange', button._afterLabelChange);","        button.after('disabledChange', button._afterDisabledChange);","    },","","    /**","     * @method syncUI","     * @description Updates button attributes","     */","    syncUI: function() {","        var button = this;","        Y.ButtonCore.prototype._uiSetLabel.call(button, button.get('label'));","        Y.ButtonCore.prototype._uiSetDisabled.call(button, button.get('disabled'));","    },","","    /**","     * @method _afterLabelChange","     * @private","     */","    _afterLabelChange: function(e) {","        Y.ButtonCore.prototype._uiSetLabel.call(this, e.newVal);","    },","","    /**","     * @method _afterDisabledChange","     * @private","     */","    _afterDisabledChange: function(e) {","        // Unable to use `this._uiSetDisabled` because that points","        // to `Y.Widget.prototype._uiSetDisabled`.","        // This works for now.","        // @TODO Investigate most appropriate solution.","        Y.ButtonCore.prototype._uiSetDisabled.call(this, e.newVal);","    }","","}, {","    // Y.Button static properties","","    /**","     * The identity of the widget.","     *","     * @property NAME","     * @type String","     * @default 'button'","     * @readOnly","     * @protected","     * @static","     */","    NAME: 'button',","","    /**","     * Static property used to define the default attribute configuration of","     * the Widget.","     *","     * @property ATTRS","     * @type {Object}","     * @protected","     * @static","     */","    ATTRS: {","","        /**","         * The text of the button (the `value` or `text` property)","         *","         * @attribute label","         * @type String","         */","        label: {","            value: Y.ButtonCore.ATTRS.label.value","        }","    },","","    /**","     * @property HTML_PARSER","     * @type {Object}","     * @protected","     * @static","     */","    HTML_PARSER: {","        label: function(node) {","            this._host = node; // TODO: remove","            return this._getLabel();","        },","","        disabled: function(node) {","            return node.getDOMNode().disabled;","        }","    },","","    /**","     * List of class names used in the Button's DOM","     *","     * @property CLASS_NAMES","     * @type Object","     * @static","     */","    CLASS_NAMES: CLASS_NAMES","});","","Y.mix(Button.prototype, Y.ButtonCore.prototype);","","/**"," * Creates a ToggleButton"," *"," * @class ToggleButton"," * @extends Button"," * @param config {Object} Configuration object"," * @constructor"," */","function ToggleButton() {","    Button.superclass.constructor.apply(this, arguments);","}","","// TODO: move to ButtonCore subclass to enable toggle plugin, widget, etc.","/* ToggleButton extends Button */","Y.extend(ToggleButton, Button,  {","","    /**","     *","     *","     * @property trigger","     * @type {String}","     * @default","     */","    trigger: 'click',","","    /**","     *","     *","     * @property selectedAttrName","     * @type {String}","     * @default","     */","    selectedAttrName: '',","    ","    /**","     *","     * @method initializer","     */","    initializer: function (config) {","        var button = this,","            type = button.get('type'),","            selectedAttrName = (type === \"checkbox\" ? 'checked' : 'pressed'),","            selectedState = config[selectedAttrName] || false;","        ","        // Create the checked/pressed attribute","        button.addAttr(selectedAttrName, {","            value: selectedState","        });","        ","        button.selectedAttrName = selectedAttrName;","    },","    ","    /**","     *","     * @method destructor","     */","    destructor: function () {","        delete this.selectedAttrName;","    },","    ","    /**","     * @method bindUI","     * @description Hooks up events for the widget","     */","    bindUI: function() {","         var button = this,","             cb = button.get('contentBox');","        ","        ToggleButton.superclass.bindUI.call(button);","        ","        cb.on(button.trigger, button.toggle, button);","        button.after(button.selectedAttrName + 'Change', button._afterSelectedChange);","    },","","    /**","     * @method syncUI","     * @description Syncs the UI for the widget","     */","    syncUI: function() {","        var button = this,","            cb = button.get('contentBox'),","            type = button.get('type'),","            ROLES = ToggleButton.ARIA_ROLES,","            role = (type === 'checkbox' ? ROLES.CHECKBOX : ROLES.TOGGLE),","            selectedAttrName = button.selectedAttrName;","","        ToggleButton.superclass.syncUI.call(button);","        ","        cb.set('role', role);","        button._uiSetSelected(button.get(selectedAttrName));","    },","    ","    /**","     * @method _afterSelectedChange","     * @private","     */","    _afterSelectedChange: function(e){","        this._uiSetSelected(e.newVal);","    },","    ","    /**","     * @method _uiSetSelected","     * @private","     */","    _uiSetSelected: function(value) {","        var button = this,","            cb = button.get('contentBox'),","            STATES = ToggleButton.ARIA_STATES,","            type = button.get('type'),","            ariaState = (type === 'checkbox' ? STATES.CHECKED : STATES.PRESSED);","        ","        cb.toggleClass(Button.CLASS_NAMES.SELECTED, value);","        cb.set(ariaState, value);","    },","    ","    /**","     * @method toggle","     * @description Toggles the selected/pressed/checked state of a ToggleButton","     * @public","     */","    toggle: function() {","        var button = this;","        button._set(button.selectedAttrName, !button.get(button.selectedAttrName));","    }","","}, {","    ","    /**","     * The identity of the widget.","     *","     * @property NAME","     * @type {String}","     * @default 'buttongroup'","     * @readOnly","     * @protected","     * @static","     */","    NAME: 'toggleButton',","    ","    /**","     * Static property used to define the default attribute configuration of","     * the Widget.","     *","     * @property ATTRS","     * @type {Object}","     * @protected","     * @static","     */","    ATTRS: {","","       /**","        *","        *","        * @attribute type","        * @type String","        */","        type: {","            value: 'toggle',","            writeOnce: 'initOnly'","        }","    },","    ","    /**","     * @property HTML_PARSER","     * @type {Object}","     * @protected","     * @static","     */","    HTML_PARSER: {","        checked: function(node) {","            return node.hasClass(CLASS_NAMES.SELECTED);","        },","        pressed: function(node) {","            return node.hasClass(CLASS_NAMES.SELECTED);","        }","    },","    ","    /**","     * @property ARIA_STATES","     * @type {Object}","     * @protected","     * @static","     */","    ARIA_STATES: ARIA_STATES,","","    /**","     * @property ARIA_ROLES","     * @type {Object}","     * @protected","     * @static","     */","    ARIA_ROLES: ARIA_ROLES,","","    /**","     * Array of static constants used to identify the classnames applied to DOM nodes","     *","     * @property CLASS_NAMES","     * @type Object","     * @static","     */","    CLASS_NAMES: CLASS_NAMES","    ","});","","// Export","Y.Button = Button;","Y.ToggleButton = ToggleButton;","","","}, '3.11.0', {\"requires\": [\"button-core\", \"cssbutton\", \"widget\"]});","","}());"]};
}
var __cov_BK1o_AjQ9P3TgSmDw5_iQg = __coverage__['build/button/button.js'];
__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['1']++;YUI.add('button',function(Y,NAME){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['1']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['2']++;var CLASS_NAMES=Y.ButtonCore.CLASS_NAMES,ARIA_STATES=Y.ButtonCore.ARIA_STATES,ARIA_ROLES=Y.ButtonCore.ARIA_ROLES;function Button(){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['2']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['4']++;Button.superclass.constructor.apply(this,arguments);}__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['5']++;Y.extend(Button,Y.Widget,{BOUNDING_TEMPLATE:Y.ButtonCore.prototype.TEMPLATE,CONTENT_TEMPLATE:null,initializer:function(config){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['3']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['6']++;this._host=this.get('boundingBox');__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['7']++;if(config.disabled){__cov_BK1o_AjQ9P3TgSmDw5_iQg.b['1'][0]++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['8']++;this.set('disabled',config.disabled);}else{__cov_BK1o_AjQ9P3TgSmDw5_iQg.b['1'][1]++;}},bindUI:function(){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['4']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['9']++;var button=this;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['10']++;button.after('labelChange',button._afterLabelChange);__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['11']++;button.after('disabledChange',button._afterDisabledChange);},syncUI:function(){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['5']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['12']++;var button=this;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['13']++;Y.ButtonCore.prototype._uiSetLabel.call(button,button.get('label'));__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['14']++;Y.ButtonCore.prototype._uiSetDisabled.call(button,button.get('disabled'));},_afterLabelChange:function(e){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['6']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['15']++;Y.ButtonCore.prototype._uiSetLabel.call(this,e.newVal);},_afterDisabledChange:function(e){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['7']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['16']++;Y.ButtonCore.prototype._uiSetDisabled.call(this,e.newVal);}},{NAME:'button',ATTRS:{label:{value:Y.ButtonCore.ATTRS.label.value}},HTML_PARSER:{label:function(node){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['8']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['17']++;this._host=node;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['18']++;return this._getLabel();},disabled:function(node){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['9']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['19']++;return node.getDOMNode().disabled;}},CLASS_NAMES:CLASS_NAMES});__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['20']++;Y.mix(Button.prototype,Y.ButtonCore.prototype);function ToggleButton(){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['10']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['22']++;Button.superclass.constructor.apply(this,arguments);}__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['23']++;Y.extend(ToggleButton,Button,{trigger:'click',selectedAttrName:'',initializer:function(config){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['11']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['24']++;var button=this,type=button.get('type'),selectedAttrName=type==='checkbox'?(__cov_BK1o_AjQ9P3TgSmDw5_iQg.b['2'][0]++,'checked'):(__cov_BK1o_AjQ9P3TgSmDw5_iQg.b['2'][1]++,'pressed'),selectedState=(__cov_BK1o_AjQ9P3TgSmDw5_iQg.b['3'][0]++,config[selectedAttrName])||(__cov_BK1o_AjQ9P3TgSmDw5_iQg.b['3'][1]++,false);__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['25']++;button.addAttr(selectedAttrName,{value:selectedState});__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['26']++;button.selectedAttrName=selectedAttrName;},destructor:function(){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['12']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['27']++;delete this.selectedAttrName;},bindUI:function(){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['13']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['28']++;var button=this,cb=button.get('contentBox');__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['29']++;ToggleButton.superclass.bindUI.call(button);__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['30']++;cb.on(button.trigger,button.toggle,button);__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['31']++;button.after(button.selectedAttrName+'Change',button._afterSelectedChange);},syncUI:function(){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['14']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['32']++;var button=this,cb=button.get('contentBox'),type=button.get('type'),ROLES=ToggleButton.ARIA_ROLES,role=type==='checkbox'?(__cov_BK1o_AjQ9P3TgSmDw5_iQg.b['4'][0]++,ROLES.CHECKBOX):(__cov_BK1o_AjQ9P3TgSmDw5_iQg.b['4'][1]++,ROLES.TOGGLE),selectedAttrName=button.selectedAttrName;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['33']++;ToggleButton.superclass.syncUI.call(button);__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['34']++;cb.set('role',role);__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['35']++;button._uiSetSelected(button.get(selectedAttrName));},_afterSelectedChange:function(e){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['15']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['36']++;this._uiSetSelected(e.newVal);},_uiSetSelected:function(value){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['16']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['37']++;var button=this,cb=button.get('contentBox'),STATES=ToggleButton.ARIA_STATES,type=button.get('type'),ariaState=type==='checkbox'?(__cov_BK1o_AjQ9P3TgSmDw5_iQg.b['5'][0]++,STATES.CHECKED):(__cov_BK1o_AjQ9P3TgSmDw5_iQg.b['5'][1]++,STATES.PRESSED);__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['38']++;cb.toggleClass(Button.CLASS_NAMES.SELECTED,value);__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['39']++;cb.set(ariaState,value);},toggle:function(){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['17']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['40']++;var button=this;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['41']++;button._set(button.selectedAttrName,!button.get(button.selectedAttrName));}},{NAME:'toggleButton',ATTRS:{type:{value:'toggle',writeOnce:'initOnly'}},HTML_PARSER:{checked:function(node){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['18']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['42']++;return node.hasClass(CLASS_NAMES.SELECTED);},pressed:function(node){__cov_BK1o_AjQ9P3TgSmDw5_iQg.f['19']++;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['43']++;return node.hasClass(CLASS_NAMES.SELECTED);}},ARIA_STATES:ARIA_STATES,ARIA_ROLES:ARIA_ROLES,CLASS_NAMES:CLASS_NAMES});__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['44']++;Y.Button=Button;__cov_BK1o_AjQ9P3TgSmDw5_iQg.s['45']++;Y.ToggleButton=ToggleButton;},'3.11.0',{'requires':['button-core','cssbutton','widget']});
