/*
YUI 3.11.0 (build d549e5c)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/file-html5/file-html5.js']) {
   __coverage__['build/file-html5/file-html5.js'] = {"path":"build/file-html5/file-html5.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0,"50":0,"51":0,"52":0,"53":0,"54":0,"55":0,"56":0,"57":0,"58":0,"59":0,"60":0,"61":0,"62":0,"63":0,"64":0,"65":0,"66":0,"67":0,"68":0,"69":0,"70":0,"71":0,"72":0,"73":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0],"13":[0,0],"14":[0,0],"15":[0,0,0,0,0],"16":[0,0],"17":[0,0],"18":[0,0],"19":[0,0,0],"20":[0,0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":22},"end":{"line":1,"column":41}}},"2":{"name":"(anonymous_2)","line":20,"loc":{"start":{"line":20,"column":20},"end":{"line":20,"column":32}}},"3":{"name":"(anonymous_3)","line":68,"loc":{"start":{"line":68,"column":22},"end":{"line":68,"column":37}}},"4":{"name":"(anonymous_4)","line":81,"loc":{"start":{"line":81,"column":29},"end":{"line":81,"column":46}}},"5":{"name":"(anonymous_5)","line":221,"loc":{"start":{"line":221,"column":21},"end":{"line":221,"column":62}}},"6":{"name":"(anonymous_6)","line":234,"loc":{"start":{"line":234,"column":31},"end":{"line":234,"column":53}}},"7":{"name":"(anonymous_7)","line":254,"loc":{"start":{"line":254,"column":43},"end":{"line":254,"column":65}}},"8":{"name":"(anonymous_8)","line":280,"loc":{"start":{"line":280,"column":22},"end":{"line":280,"column":34}}},"9":{"name":"(anonymous_9)","line":477,"loc":{"start":{"line":477,"column":21},"end":{"line":477,"column":37}}},"10":{"name":"(anonymous_10)","line":488,"loc":{"start":{"line":488,"column":19},"end":{"line":488,"column":31}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":495,"column":37}},"2":{"start":{"line":16,"column":4},"end":{"line":18,"column":27}},"3":{"start":{"line":20,"column":4},"end":{"line":57,"column":6}},"4":{"start":{"line":22,"column":8},"end":{"line":22,"column":24}},"5":{"start":{"line":24,"column":8},"end":{"line":32,"column":9}},"6":{"start":{"line":25,"column":12},"end":{"line":25,"column":21}},"7":{"start":{"line":27,"column":13},"end":{"line":32,"column":9}},"8":{"start":{"line":28,"column":12},"end":{"line":28,"column":26}},"9":{"start":{"line":31,"column":12},"end":{"line":31,"column":25}},"10":{"start":{"line":34,"column":8},"end":{"line":34,"column":64}},"11":{"start":{"line":36,"column":8},"end":{"line":56,"column":9}},"12":{"start":{"line":37,"column":11},"end":{"line":39,"column":12}},"13":{"start":{"line":38,"column":15},"end":{"line":38,"column":39}},"14":{"start":{"line":41,"column":11},"end":{"line":43,"column":12}},"15":{"start":{"line":42,"column":11},"end":{"line":42,"column":57}},"16":{"start":{"line":45,"column":11},"end":{"line":47,"column":12}},"17":{"start":{"line":46,"column":11},"end":{"line":46,"column":57}},"18":{"start":{"line":49,"column":11},"end":{"line":51,"column":12}},"19":{"start":{"line":50,"column":11},"end":{"line":50,"column":40}},"20":{"start":{"line":53,"column":11},"end":{"line":55,"column":12}},"21":{"start":{"line":54,"column":15},"end":{"line":54,"column":64}},"22":{"start":{"line":60,"column":4},"end":{"line":491,"column":7}},"23":{"start":{"line":69,"column":12},"end":{"line":71,"column":13}},"24":{"start":{"line":70,"column":16},"end":{"line":70,"column":48}},"25":{"start":{"line":82,"column":12},"end":{"line":82,"column":38}},"26":{"start":{"line":84,"column":12},"end":{"line":210,"column":13}},"27":{"start":{"line":103,"column":19},"end":{"line":107,"column":50}},"28":{"start":{"line":108,"column":19},"end":{"line":108,"column":60}},"29":{"start":{"line":109,"column":19},"end":{"line":109,"column":25}},"30":{"start":{"line":126,"column":19},"end":{"line":146,"column":20}},"31":{"start":{"line":127,"column":24},"end":{"line":128,"column":87}},"32":{"start":{"line":129,"column":24},"end":{"line":130,"column":78}},"33":{"start":{"line":132,"column":24},"end":{"line":132,"column":86}},"34":{"start":{"line":133,"column":24},"end":{"line":133,"column":83}},"35":{"start":{"line":134,"column":24},"end":{"line":134,"column":83}},"36":{"start":{"line":135,"column":24},"end":{"line":135,"column":76}},"37":{"start":{"line":136,"column":24},"end":{"line":136,"column":77}},"38":{"start":{"line":137,"column":24},"end":{"line":137,"column":88}},"39":{"start":{"line":139,"column":24},"end":{"line":139,"column":47}},"40":{"start":{"line":142,"column":24},"end":{"line":145,"column":67}},"41":{"start":{"line":147,"column":19},"end":{"line":147,"column":25}},"42":{"start":{"line":170,"column":19},"end":{"line":173,"column":65}},"43":{"start":{"line":174,"column":19},"end":{"line":174,"column":25}},"44":{"start":{"line":189,"column":19},"end":{"line":189,"column":67}},"45":{"start":{"line":190,"column":19},"end":{"line":190,"column":25}},"46":{"start":{"line":207,"column":19},"end":{"line":208,"column":71}},"47":{"start":{"line":209,"column":19},"end":{"line":209,"column":25}},"48":{"start":{"line":223,"column":12},"end":{"line":223,"column":42}},"49":{"start":{"line":225,"column":12},"end":{"line":225,"column":51}},"50":{"start":{"line":226,"column":12},"end":{"line":226,"column":81}},"51":{"start":{"line":228,"column":12},"end":{"line":232,"column":66}},"52":{"start":{"line":234,"column":12},"end":{"line":234,"column":87}},"53":{"start":{"line":234,"column":54},"end":{"line":234,"column":84}},"54":{"start":{"line":235,"column":12},"end":{"line":235,"column":59}},"55":{"start":{"line":240,"column":12},"end":{"line":240,"column":73}},"56":{"start":{"line":241,"column":12},"end":{"line":241,"column":78}},"57":{"start":{"line":242,"column":12},"end":{"line":242,"column":68}},"58":{"start":{"line":243,"column":12},"end":{"line":243,"column":69}},"59":{"start":{"line":244,"column":12},"end":{"line":244,"column":75}},"60":{"start":{"line":245,"column":12},"end":{"line":245,"column":75}},"61":{"start":{"line":246,"column":12},"end":{"line":246,"column":69}},"62":{"start":{"line":247,"column":12},"end":{"line":247,"column":71}},"63":{"start":{"line":248,"column":12},"end":{"line":248,"column":80}},"64":{"start":{"line":250,"column":12},"end":{"line":250,"column":40}},"65":{"start":{"line":252,"column":12},"end":{"line":252,"column":65}},"66":{"start":{"line":254,"column":12},"end":{"line":256,"column":15}},"67":{"start":{"line":255,"column":17},"end":{"line":255,"column":50}},"68":{"start":{"line":258,"column":12},"end":{"line":258,"column":33}},"69":{"start":{"line":271,"column":13},"end":{"line":271,"column":50}},"70":{"start":{"line":281,"column":12},"end":{"line":281,"column":36}},"71":{"start":{"line":478,"column":12},"end":{"line":478,"column":61}},"72":{"start":{"line":489,"column":12},"end":{"line":489,"column":63}},"73":{"start":{"line":493,"column":4},"end":{"line":493,"column":28}}},"branchMap":{"1":{"line":24,"type":"if","locations":[{"start":{"line":24,"column":8},"end":{"line":24,"column":8}},{"start":{"line":24,"column":8},"end":{"line":24,"column":8}}]},"2":{"line":27,"type":"if","locations":[{"start":{"line":27,"column":13},"end":{"line":27,"column":13}},{"start":{"line":27,"column":13},"end":{"line":27,"column":13}}]},"3":{"line":36,"type":"if","locations":[{"start":{"line":36,"column":8},"end":{"line":36,"column":8}},{"start":{"line":36,"column":8},"end":{"line":36,"column":8}}]},"4":{"line":36,"type":"binary-expr","locations":[{"start":{"line":36,"column":12},"end":{"line":36,"column":16}},{"start":{"line":36,"column":20},"end":{"line":36,"column":41}}]},"5":{"line":37,"type":"if","locations":[{"start":{"line":37,"column":11},"end":{"line":37,"column":11}},{"start":{"line":37,"column":11},"end":{"line":37,"column":11}}]},"6":{"line":41,"type":"if","locations":[{"start":{"line":41,"column":11},"end":{"line":41,"column":11}},{"start":{"line":41,"column":11},"end":{"line":41,"column":11}}]},"7":{"line":42,"type":"binary-expr","locations":[{"start":{"line":42,"column":29},"end":{"line":42,"column":38}},{"start":{"line":42,"column":42},"end":{"line":42,"column":55}}]},"8":{"line":45,"type":"if","locations":[{"start":{"line":45,"column":11},"end":{"line":45,"column":11}},{"start":{"line":45,"column":11},"end":{"line":45,"column":11}}]},"9":{"line":45,"type":"binary-expr","locations":[{"start":{"line":45,"column":36},"end":{"line":45,"column":45}},{"start":{"line":45,"column":49},"end":{"line":45,"column":62}}]},"10":{"line":46,"type":"binary-expr","locations":[{"start":{"line":46,"column":29},"end":{"line":46,"column":38}},{"start":{"line":46,"column":42},"end":{"line":46,"column":55}}]},"11":{"line":49,"type":"if","locations":[{"start":{"line":49,"column":11},"end":{"line":49,"column":11}},{"start":{"line":49,"column":11},"end":{"line":49,"column":11}}]},"12":{"line":53,"type":"if","locations":[{"start":{"line":53,"column":11},"end":{"line":53,"column":11}},{"start":{"line":53,"column":11},"end":{"line":53,"column":11}}]},"13":{"line":53,"type":"binary-expr","locations":[{"start":{"line":53,"column":15},"end":{"line":53,"column":54}},{"start":{"line":53,"column":58},"end":{"line":53,"column":83}}]},"14":{"line":69,"type":"if","locations":[{"start":{"line":69,"column":12},"end":{"line":69,"column":12}},{"start":{"line":69,"column":12},"end":{"line":69,"column":12}}]},"15":{"line":84,"type":"switch","locations":[{"start":{"line":85,"column":16},"end":{"line":109,"column":25}},{"start":{"line":111,"column":16},"end":{"line":147,"column":25}},{"start":{"line":149,"column":16},"end":{"line":174,"column":25}},{"start":{"line":176,"column":16},"end":{"line":190,"column":25}},{"start":{"line":192,"column":16},"end":{"line":209,"column":25}}]},"16":{"line":126,"type":"if","locations":[{"start":{"line":126,"column":19},"end":{"line":126,"column":19}},{"start":{"line":126,"column":19},"end":{"line":126,"column":19}}]},"17":{"line":126,"type":"binary-expr","locations":[{"start":{"line":126,"column":23},"end":{"line":126,"column":40}},{"start":{"line":126,"column":44},"end":{"line":126,"column":61}}]},"18":{"line":229,"type":"binary-expr","locations":[{"start":{"line":229,"column":28},"end":{"line":229,"column":41}},{"start":{"line":229,"column":45},"end":{"line":229,"column":55}}]},"19":{"line":478,"type":"binary-expr","locations":[{"start":{"line":478,"column":20},"end":{"line":478,"column":23}},{"start":{"line":478,"column":27},"end":{"line":478,"column":35}},{"start":{"line":478,"column":39},"end":{"line":478,"column":59}}]},"20":{"line":489,"type":"binary-expr","locations":[{"start":{"line":489,"column":20},"end":{"line":489,"column":23}},{"start":{"line":489,"column":27},"end":{"line":489,"column":39}},{"start":{"line":489,"column":43},"end":{"line":489,"column":61}}]}},"code":["(function () { YUI.add('file-html5', function (Y, NAME) {","","    /**","     * The FileHTML5 class provides a wrapper for a file pointer in an HTML5 The File wrapper ","     * also implements the mechanics for uploading a file and tracking its progress.","     * @module file-html5","     */     ","     ","    /**","     * The class provides a wrapper for a file pointer.","     * @class FileHTML5","     * @extends Base","     * @constructor","     * @param {Object} config Configuration object.","     */","    var Lang = Y.Lang,","        Bind = Y.bind,","        Win = Y.config.win;","","    var FileHTML5 = function(o) {","        ","        var file = null;","","        if (FileHTML5.isValidFile(o)) {","            file = o;","        }","        else if (FileHTML5.isValidFile(o.file)) {","            file = o.file;","        }","        else {","            file = false;","        }","","        FileHTML5.superclass.constructor.apply(this, arguments);      ","        ","        if (file && FileHTML5.canUpload()) {","           if (!this.get(\"file\")) {","               this._set(\"file\", file);","           }","","           if (!this.get(\"name\")) {","           this._set(\"name\", file.name || file.fileName);","           }","","           if (this.get(\"size\") != (file.size || file.fileSize)) {","           this._set(\"size\", file.size || file.fileSize);","           }","","           if (!this.get(\"type\")) {","           this._set(\"type\", file.type);","           }","","           if (file.hasOwnProperty(\"lastModifiedDate\") && !this.get(\"dateModified\")) {","               this._set(\"dateModified\", file.lastModifiedDate);","           }","        }","    };","","","    Y.extend(FileHTML5, Y.Base, {","","       /**","        * Construction logic executed during FileHTML5 instantiation.","        *","        * @method initializer","        * @protected","        */","        initializer : function (cfg) {","            if (!this.get(\"id\")) {","                this._set(\"id\", Y.guid(\"file\"));","            }","        },","","       /**","        * Handler of events dispatched by the XMLHTTPRequest.","        *","        * @method _uploadEventHandler","        * @param {Event} event The event object received from the XMLHTTPRequest.","        * @protected","        */      ","        _uploadEventHandler: function (event) {","            var xhr = this.get(\"xhr\");","","            switch (event.type) {","                case \"progress\":","                  /**","                   * Signals that progress has been made on the upload of this file. ","                   *","                   * @event uploadprogress","                   * @param event {Event} The event object for the `uploadprogress` with the","                   *                      following payload:","                   *  <dl>","                   *      <dt>originEvent</dt>","                   *          <dd>The original event fired by the XMLHttpRequest instance.</dd>","                   *      <dt>bytesLoaded</dt>","                   *          <dd>The number of bytes of the file that has been uploaded.</dd>","                   *      <dt>bytesTotal</dt>","                   *          <dd>The total number of bytes in the file (the file size)</dd>","                   *      <dt>percentLoaded</dt>","                   *          <dd>The fraction of the file that has been uploaded, out of 100.</dd>","                   *  </dl>","                   */","                   this.fire(\"uploadprogress\", {originEvent: event,","                                               bytesLoaded: event.loaded, ","                                               bytesTotal: this.get(\"size\"), ","                                               percentLoaded: Math.min(100, Math.round(10000*event.loaded/this.get(\"size\"))/100)","                                               });","                   this._set(\"bytesUploaded\", event.loaded);","                   break;","","                case \"load\":","                  /**","                   * Signals that this file's upload has completed and data has been received from the server.","                   *","                   * @event uploadcomplete","                   * @param event {Event} The event object for the `uploadcomplete` with the","                   *                      following payload:","                   *  <dl>","                   *      <dt>originEvent</dt>","                   *          <dd>The original event fired by the XMLHttpRequest instance.</dd>","                   *      <dt>data</dt>","                   *          <dd>The data returned by the server.</dd>","                   *  </dl>","                   */","","                   if (xhr.status >= 200 && xhr.status <= 299) {","                        this.fire(\"uploadcomplete\", {originEvent: event,","                                                     data: event.target.responseText});","                        var xhrupload = xhr.upload,","                            boundEventHandler = this.get(\"boundEventHandler\");","    ","                        xhrupload.removeEventListener (\"progress\", boundEventHandler);","                        xhrupload.removeEventListener (\"error\", boundEventHandler);","                        xhrupload.removeEventListener (\"abort\", boundEventHandler);","                        xhr.removeEventListener (\"load\", boundEventHandler); ","                        xhr.removeEventListener (\"error\", boundEventHandler);","                        xhr.removeEventListener (\"readystatechange\", boundEventHandler);","                        ","                        this._set(\"xhr\", null);","                   }","                   else {","                        this.fire(\"uploaderror\", {originEvent: event,","                                                  status: xhr.status,","                                                  statusText: xhr.statusText,","                                                  source: \"http\"});","                   }                   ","                   break;","","                case \"error\":","                  /**","                   * Signals that this file's upload has encountered an error. ","                   *","                   * @event uploaderror","                   * @param event {Event} The event object for the `uploaderror` with the","                   *                      following payload:","                   *  <dl>","                   *      <dt>originEvent</dt>","                   *          <dd>The original event fired by the XMLHttpRequest instance.</dd>","                   *      <dt>status</dt>","                   *          <dd>The status code reported by the XMLHttpRequest. If it's an HTTP error,","                                  then this corresponds to the HTTP status code received by the uploader.</dd>","                   *      <dt>statusText</dt>","                   *          <dd>The text of the error event reported by the XMLHttpRequest instance</dd>","                   *      <dt>source</dt>","                   *          <dd>Either \"http\" (if it's an HTTP error), or \"io\" (if it's a network transmission ","                   *              error.)</dd>","                   *","                   *  </dl>","                   */","                   this.fire(\"uploaderror\", {originEvent: event,","                                                  status: xhr.status,","                                                  statusText: xhr.statusText,","                                                  source: \"io\"});","                   break;","","                case \"abort\":","","                  /**","                   * Signals that this file's upload has been cancelled. ","                   *","                   * @event uploadcancel","                   * @param event {Event} The event object for the `uploadcancel` with the","                   *                      following payload:","                   *  <dl>","                   *      <dt>originEvent</dt>","                   *          <dd>The original event fired by the XMLHttpRequest instance.</dd>","                   *  </dl>","                   */","                   this.fire(\"uploadcancel\", {originEvent: event});","                   break;","","                case \"readystatechange\":","","                  /**","                   * Signals that XMLHttpRequest has fired a readystatechange event. ","                   *","                   * @event readystatechange","                   * @param event {Event} The event object for the `readystatechange` with the","                   *                      following payload:","                   *  <dl>","                   *      <dt>readyState</dt>","                   *          <dd>The readyState code reported by the XMLHttpRequest instance.</dd>","                   *      <dt>originEvent</dt>","                   *          <dd>The original event fired by the XMLHttpRequest instance.</dd>","                   *  </dl>","                   */","                   this.fire(\"readystatechange\", {readyState: event.target.readyState,","                                                  originEvent: event});","                   break;","            }","        },","","       /**","        * Starts the upload of a specific file.","        *","        * @method startUpload","        * @param url {String} The URL to upload the file to.","        * @param parameters {Object} (optional) A set of key-value pairs to send as variables along with the file upload HTTP request.","        * @param fileFieldName {String} (optional) The name of the POST variable that should contain the uploaded file ('Filedata' by default)","        */","        startUpload: function(url, parameters, fileFieldName) {","         ","            this._set(\"bytesUploaded\", 0);","            ","            this._set(\"xhr\", new XMLHttpRequest());","            this._set(\"boundEventHandler\", Bind(this._uploadEventHandler, this));","                         ","            var uploadData = new FormData(),","                fileField = fileFieldName || \"Filedata\",","                xhr = this.get(\"xhr\"),","                xhrupload = this.get(\"xhr\").upload,","                boundEventHandler = this.get(\"boundEventHandler\");","","            Y.each(parameters, function (value, key) {uploadData.append(key, value);});","            uploadData.append(fileField, this.get(\"file\"));","","","","","            xhr.addEventListener (\"loadstart\", boundEventHandler, false);","            xhrupload.addEventListener (\"progress\", boundEventHandler, false);","            xhr.addEventListener (\"load\", boundEventHandler, false);","            xhr.addEventListener (\"error\", boundEventHandler, false);","            xhrupload.addEventListener (\"error\", boundEventHandler, false);","            xhrupload.addEventListener (\"abort\", boundEventHandler, false);","            xhr.addEventListener (\"abort\", boundEventHandler, false);","            xhr.addEventListener (\"loadend\", boundEventHandler, false); ","            xhr.addEventListener (\"readystatechange\", boundEventHandler, false);","","            xhr.open(\"POST\", url, true);","","            xhr.withCredentials = this.get(\"xhrWithCredentials\");","","            Y.each(this.get(\"xhrHeaders\"), function (value, key) {","                 xhr.setRequestHeader(key, value);","            });","","            xhr.send(uploadData);","      ","            /**","             * Signals that this file's upload has started. ","             *","             * @event uploadstart","             * @param event {Event} The event object for the `uploadstart` with the","             *                      following payload:","             *  <dl>","             *      <dt>xhr</dt>","             *          <dd>The XMLHttpRequest instance handling the file upload.</dd>","             *  </dl>","             */","             this.fire(\"uploadstart\", {xhr: xhr});","","        },","","       /**","        * Cancels the upload of a specific file, if currently in progress.","        *","        * @method cancelUpload","        */    ","        cancelUpload: function () {","            this.get('xhr').abort();","        }","","","    }, {","","       /**","        * The identity of the class.","        *","        * @property NAME","        * @type String","        * @default 'file'","        * @readOnly","        * @protected","        * @static","        */","        NAME: 'file',","","       /**","        * The type of transport.","        *","        * @property TYPE","        * @type String","        * @default 'html5'","        * @readOnly","        * @protected","        * @static","        */","        TYPE: 'html5',","","       /**","        * Static property used to define the default attribute configuration of","        * the File.","        *","        * @property ATTRS","        * @type {Object}","        * @protected","        * @static","        */","        ATTRS: {","","       /**","        * A String containing the unique id of the file wrapped by the FileFlash instance.","        * The id is supplied by the Flash player uploader.","        *","        * @attribute id","        * @type {String}","        * @initOnly","        */","        id: {","            writeOnce: \"initOnly\",","            value: null","        },","","       /**","        * The size of the file wrapped by FileHTML5. This value is supplied by the instance of File().","        *","        * @attribute size","        * @type {Number}","        * @initOnly","        */","        size: {","            writeOnce: \"initOnly\",","            value: 0","        },","","       /**","        * The name of the file wrapped by FileHTML5. This value is supplied by the instance of File().","        *","        * @attribute name","        * @type {String}","        * @initOnly","        */","        name: {","            writeOnce: \"initOnly\",","            value: null","        },","","       /**","        * The date that the file wrapped by FileHTML5 was created on. This value is supplied by the instance of File().","        *","        * @attribute dateCreated","        * @type {Date}","        * @initOnly","        * @default null","        */","        dateCreated: {","            writeOnce: \"initOnly\",","            value: null","        },","","       /**","        * The date that the file wrapped by FileHTML5 was last modified on. This value is supplied by the instance of File().","        *","        * @attribute dateModified","        * @type {Date}","        * @initOnly","        */","        dateModified: {","            writeOnce: \"initOnly\",","            value: null","        },","","       /**","        * The number of bytes of the file that has been uploaded to the server. This value is","        * non-zero only while a file is being uploaded.","        *","        * @attribute bytesUploaded","        * @type {Date}","        * @readOnly","        */","        bytesUploaded: {","            readOnly: true,","            value: 0","        },","","       /**","        * The type of the file wrapped by FileHTML. This value is provided by the instance of File()","        *","        * @attribute type","        * @type {String}","        * @initOnly","        */","        type: {","            writeOnce: \"initOnly\",","            value: null","        },","","       /**","        * The pointer to the instance of File() wrapped by FileHTML5.","        *","        * @attribute file","        * @type {File}","        * @initOnly","        */","        file: {","            writeOnce: \"initOnly\",","            value: null","        },","","       /**","        * The pointer to the instance of XMLHttpRequest used by FileHTML5 to upload the file.","        *","        * @attribute xhr","        * @type {XMLHttpRequest}","        * @initOnly","        */","        xhr: {","            readOnly: true,","            value: null","        },","","       /**","        * The dictionary of headers that should be set on the XMLHttpRequest object before","        * sending it.","        *","        * @attribute xhrHeaders","        * @type {Object}","        * @initOnly","        */","        xhrHeaders: {","            value: {}","        },","","       /**","        * A Boolean indicating whether the XMLHttpRequest should be sent with user credentials.","        * This does not affect same-site requests. ","        *","        * @attribute xhrWithCredentials","        * @type {Boolean}","        * @initOnly","        */","        xhrWithCredentials: {","            value: true","        },","","       /**","        * The bound event handler used to handle events from XMLHttpRequest.","        *","        * @attribute boundEventHandler","        * @type {Function}","        * @initOnly","        */","        boundEventHandler: {","            readOnly: true,","            value: null","        }","        },","","       /**","        * Checks whether a specific native file instance is valid","        *","        * @method isValidFile","        * @param file {File} A native File() instance.","        * @static","        */","        isValidFile: function (file) {","            return (Win && Win.File && file instanceof File);","        },","","       /**","        * Checks whether the browser has a native upload capability","        * via XMLHttpRequest Level 2.","        *","        * @method canUpload","        * @static","        */","        canUpload: function () {","            return (Win && Win.FormData && Win.XMLHttpRequest);","        }","    });","","    Y.FileHTML5 = FileHTML5;","","}, '3.11.0', {\"requires\": [\"base\"]});","","}());"]};
}
var __cov_kDIQB9qQhNhA_eavooEj1w = __coverage__['build/file-html5/file-html5.js'];
__cov_kDIQB9qQhNhA_eavooEj1w.s['1']++;YUI.add('file-html5',function(Y,NAME){__cov_kDIQB9qQhNhA_eavooEj1w.f['1']++;__cov_kDIQB9qQhNhA_eavooEj1w.s['2']++;var Lang=Y.Lang,Bind=Y.bind,Win=Y.config.win;__cov_kDIQB9qQhNhA_eavooEj1w.s['3']++;var FileHTML5=function(o){__cov_kDIQB9qQhNhA_eavooEj1w.f['2']++;__cov_kDIQB9qQhNhA_eavooEj1w.s['4']++;var file=null;__cov_kDIQB9qQhNhA_eavooEj1w.s['5']++;if(FileHTML5.isValidFile(o)){__cov_kDIQB9qQhNhA_eavooEj1w.b['1'][0]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['6']++;file=o;}else{__cov_kDIQB9qQhNhA_eavooEj1w.b['1'][1]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['7']++;if(FileHTML5.isValidFile(o.file)){__cov_kDIQB9qQhNhA_eavooEj1w.b['2'][0]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['8']++;file=o.file;}else{__cov_kDIQB9qQhNhA_eavooEj1w.b['2'][1]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['9']++;file=false;}}__cov_kDIQB9qQhNhA_eavooEj1w.s['10']++;FileHTML5.superclass.constructor.apply(this,arguments);__cov_kDIQB9qQhNhA_eavooEj1w.s['11']++;if((__cov_kDIQB9qQhNhA_eavooEj1w.b['4'][0]++,file)&&(__cov_kDIQB9qQhNhA_eavooEj1w.b['4'][1]++,FileHTML5.canUpload())){__cov_kDIQB9qQhNhA_eavooEj1w.b['3'][0]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['12']++;if(!this.get('file')){__cov_kDIQB9qQhNhA_eavooEj1w.b['5'][0]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['13']++;this._set('file',file);}else{__cov_kDIQB9qQhNhA_eavooEj1w.b['5'][1]++;}__cov_kDIQB9qQhNhA_eavooEj1w.s['14']++;if(!this.get('name')){__cov_kDIQB9qQhNhA_eavooEj1w.b['6'][0]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['15']++;this._set('name',(__cov_kDIQB9qQhNhA_eavooEj1w.b['7'][0]++,file.name)||(__cov_kDIQB9qQhNhA_eavooEj1w.b['7'][1]++,file.fileName));}else{__cov_kDIQB9qQhNhA_eavooEj1w.b['6'][1]++;}__cov_kDIQB9qQhNhA_eavooEj1w.s['16']++;if(this.get('size')!=((__cov_kDIQB9qQhNhA_eavooEj1w.b['9'][0]++,file.size)||(__cov_kDIQB9qQhNhA_eavooEj1w.b['9'][1]++,file.fileSize))){__cov_kDIQB9qQhNhA_eavooEj1w.b['8'][0]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['17']++;this._set('size',(__cov_kDIQB9qQhNhA_eavooEj1w.b['10'][0]++,file.size)||(__cov_kDIQB9qQhNhA_eavooEj1w.b['10'][1]++,file.fileSize));}else{__cov_kDIQB9qQhNhA_eavooEj1w.b['8'][1]++;}__cov_kDIQB9qQhNhA_eavooEj1w.s['18']++;if(!this.get('type')){__cov_kDIQB9qQhNhA_eavooEj1w.b['11'][0]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['19']++;this._set('type',file.type);}else{__cov_kDIQB9qQhNhA_eavooEj1w.b['11'][1]++;}__cov_kDIQB9qQhNhA_eavooEj1w.s['20']++;if((__cov_kDIQB9qQhNhA_eavooEj1w.b['13'][0]++,file.hasOwnProperty('lastModifiedDate'))&&(__cov_kDIQB9qQhNhA_eavooEj1w.b['13'][1]++,!this.get('dateModified'))){__cov_kDIQB9qQhNhA_eavooEj1w.b['12'][0]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['21']++;this._set('dateModified',file.lastModifiedDate);}else{__cov_kDIQB9qQhNhA_eavooEj1w.b['12'][1]++;}}else{__cov_kDIQB9qQhNhA_eavooEj1w.b['3'][1]++;}};__cov_kDIQB9qQhNhA_eavooEj1w.s['22']++;Y.extend(FileHTML5,Y.Base,{initializer:function(cfg){__cov_kDIQB9qQhNhA_eavooEj1w.f['3']++;__cov_kDIQB9qQhNhA_eavooEj1w.s['23']++;if(!this.get('id')){__cov_kDIQB9qQhNhA_eavooEj1w.b['14'][0]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['24']++;this._set('id',Y.guid('file'));}else{__cov_kDIQB9qQhNhA_eavooEj1w.b['14'][1]++;}},_uploadEventHandler:function(event){__cov_kDIQB9qQhNhA_eavooEj1w.f['4']++;__cov_kDIQB9qQhNhA_eavooEj1w.s['25']++;var xhr=this.get('xhr');__cov_kDIQB9qQhNhA_eavooEj1w.s['26']++;switch(event.type){case'progress':__cov_kDIQB9qQhNhA_eavooEj1w.b['15'][0]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['27']++;this.fire('uploadprogress',{originEvent:event,bytesLoaded:event.loaded,bytesTotal:this.get('size'),percentLoaded:Math.min(100,Math.round(10000*event.loaded/this.get('size'))/100)});__cov_kDIQB9qQhNhA_eavooEj1w.s['28']++;this._set('bytesUploaded',event.loaded);__cov_kDIQB9qQhNhA_eavooEj1w.s['29']++;break;case'load':__cov_kDIQB9qQhNhA_eavooEj1w.b['15'][1]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['30']++;if((__cov_kDIQB9qQhNhA_eavooEj1w.b['17'][0]++,xhr.status>=200)&&(__cov_kDIQB9qQhNhA_eavooEj1w.b['17'][1]++,xhr.status<=299)){__cov_kDIQB9qQhNhA_eavooEj1w.b['16'][0]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['31']++;this.fire('uploadcomplete',{originEvent:event,data:event.target.responseText});__cov_kDIQB9qQhNhA_eavooEj1w.s['32']++;var xhrupload=xhr.upload,boundEventHandler=this.get('boundEventHandler');__cov_kDIQB9qQhNhA_eavooEj1w.s['33']++;xhrupload.removeEventListener('progress',boundEventHandler);__cov_kDIQB9qQhNhA_eavooEj1w.s['34']++;xhrupload.removeEventListener('error',boundEventHandler);__cov_kDIQB9qQhNhA_eavooEj1w.s['35']++;xhrupload.removeEventListener('abort',boundEventHandler);__cov_kDIQB9qQhNhA_eavooEj1w.s['36']++;xhr.removeEventListener('load',boundEventHandler);__cov_kDIQB9qQhNhA_eavooEj1w.s['37']++;xhr.removeEventListener('error',boundEventHandler);__cov_kDIQB9qQhNhA_eavooEj1w.s['38']++;xhr.removeEventListener('readystatechange',boundEventHandler);__cov_kDIQB9qQhNhA_eavooEj1w.s['39']++;this._set('xhr',null);}else{__cov_kDIQB9qQhNhA_eavooEj1w.b['16'][1]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['40']++;this.fire('uploaderror',{originEvent:event,status:xhr.status,statusText:xhr.statusText,source:'http'});}__cov_kDIQB9qQhNhA_eavooEj1w.s['41']++;break;case'error':__cov_kDIQB9qQhNhA_eavooEj1w.b['15'][2]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['42']++;this.fire('uploaderror',{originEvent:event,status:xhr.status,statusText:xhr.statusText,source:'io'});__cov_kDIQB9qQhNhA_eavooEj1w.s['43']++;break;case'abort':__cov_kDIQB9qQhNhA_eavooEj1w.b['15'][3]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['44']++;this.fire('uploadcancel',{originEvent:event});__cov_kDIQB9qQhNhA_eavooEj1w.s['45']++;break;case'readystatechange':__cov_kDIQB9qQhNhA_eavooEj1w.b['15'][4]++;__cov_kDIQB9qQhNhA_eavooEj1w.s['46']++;this.fire('readystatechange',{readyState:event.target.readyState,originEvent:event});__cov_kDIQB9qQhNhA_eavooEj1w.s['47']++;break;}},startUpload:function(url,parameters,fileFieldName){__cov_kDIQB9qQhNhA_eavooEj1w.f['5']++;__cov_kDIQB9qQhNhA_eavooEj1w.s['48']++;this._set('bytesUploaded',0);__cov_kDIQB9qQhNhA_eavooEj1w.s['49']++;this._set('xhr',new XMLHttpRequest());__cov_kDIQB9qQhNhA_eavooEj1w.s['50']++;this._set('boundEventHandler',Bind(this._uploadEventHandler,this));__cov_kDIQB9qQhNhA_eavooEj1w.s['51']++;var uploadData=new FormData(),fileField=(__cov_kDIQB9qQhNhA_eavooEj1w.b['18'][0]++,fileFieldName)||(__cov_kDIQB9qQhNhA_eavooEj1w.b['18'][1]++,'Filedata'),xhr=this.get('xhr'),xhrupload=this.get('xhr').upload,boundEventHandler=this.get('boundEventHandler');__cov_kDIQB9qQhNhA_eavooEj1w.s['52']++;Y.each(parameters,function(value,key){__cov_kDIQB9qQhNhA_eavooEj1w.f['6']++;__cov_kDIQB9qQhNhA_eavooEj1w.s['53']++;uploadData.append(key,value);});__cov_kDIQB9qQhNhA_eavooEj1w.s['54']++;uploadData.append(fileField,this.get('file'));__cov_kDIQB9qQhNhA_eavooEj1w.s['55']++;xhr.addEventListener('loadstart',boundEventHandler,false);__cov_kDIQB9qQhNhA_eavooEj1w.s['56']++;xhrupload.addEventListener('progress',boundEventHandler,false);__cov_kDIQB9qQhNhA_eavooEj1w.s['57']++;xhr.addEventListener('load',boundEventHandler,false);__cov_kDIQB9qQhNhA_eavooEj1w.s['58']++;xhr.addEventListener('error',boundEventHandler,false);__cov_kDIQB9qQhNhA_eavooEj1w.s['59']++;xhrupload.addEventListener('error',boundEventHandler,false);__cov_kDIQB9qQhNhA_eavooEj1w.s['60']++;xhrupload.addEventListener('abort',boundEventHandler,false);__cov_kDIQB9qQhNhA_eavooEj1w.s['61']++;xhr.addEventListener('abort',boundEventHandler,false);__cov_kDIQB9qQhNhA_eavooEj1w.s['62']++;xhr.addEventListener('loadend',boundEventHandler,false);__cov_kDIQB9qQhNhA_eavooEj1w.s['63']++;xhr.addEventListener('readystatechange',boundEventHandler,false);__cov_kDIQB9qQhNhA_eavooEj1w.s['64']++;xhr.open('POST',url,true);__cov_kDIQB9qQhNhA_eavooEj1w.s['65']++;xhr.withCredentials=this.get('xhrWithCredentials');__cov_kDIQB9qQhNhA_eavooEj1w.s['66']++;Y.each(this.get('xhrHeaders'),function(value,key){__cov_kDIQB9qQhNhA_eavooEj1w.f['7']++;__cov_kDIQB9qQhNhA_eavooEj1w.s['67']++;xhr.setRequestHeader(key,value);});__cov_kDIQB9qQhNhA_eavooEj1w.s['68']++;xhr.send(uploadData);__cov_kDIQB9qQhNhA_eavooEj1w.s['69']++;this.fire('uploadstart',{xhr:xhr});},cancelUpload:function(){__cov_kDIQB9qQhNhA_eavooEj1w.f['8']++;__cov_kDIQB9qQhNhA_eavooEj1w.s['70']++;this.get('xhr').abort();}},{NAME:'file',TYPE:'html5',ATTRS:{id:{writeOnce:'initOnly',value:null},size:{writeOnce:'initOnly',value:0},name:{writeOnce:'initOnly',value:null},dateCreated:{writeOnce:'initOnly',value:null},dateModified:{writeOnce:'initOnly',value:null},bytesUploaded:{readOnly:true,value:0},type:{writeOnce:'initOnly',value:null},file:{writeOnce:'initOnly',value:null},xhr:{readOnly:true,value:null},xhrHeaders:{value:{}},xhrWithCredentials:{value:true},boundEventHandler:{readOnly:true,value:null}},isValidFile:function(file){__cov_kDIQB9qQhNhA_eavooEj1w.f['9']++;__cov_kDIQB9qQhNhA_eavooEj1w.s['71']++;return(__cov_kDIQB9qQhNhA_eavooEj1w.b['19'][0]++,Win)&&(__cov_kDIQB9qQhNhA_eavooEj1w.b['19'][1]++,Win.File)&&(__cov_kDIQB9qQhNhA_eavooEj1w.b['19'][2]++,file instanceof File);},canUpload:function(){__cov_kDIQB9qQhNhA_eavooEj1w.f['10']++;__cov_kDIQB9qQhNhA_eavooEj1w.s['72']++;return(__cov_kDIQB9qQhNhA_eavooEj1w.b['20'][0]++,Win)&&(__cov_kDIQB9qQhNhA_eavooEj1w.b['20'][1]++,Win.FormData)&&(__cov_kDIQB9qQhNhA_eavooEj1w.b['20'][2]++,Win.XMLHttpRequest);}});__cov_kDIQB9qQhNhA_eavooEj1w.s['73']++;Y.FileHTML5=FileHTML5;},'3.11.0',{'requires':['base']});
