/*
YUI 3.18.1 (build f7e7bcb)
Copyright 2014 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/datatype-date-math/datatype-date-math.js']) {
   __coverage__['build/datatype-date-math/datatype-date-math.js'] = {"path":"build/datatype-date-math/datatype-date-math.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0},"b":{"1":[0,0],"2":[0,0,0,0,0],"3":[0,0,0],"4":[0,0,0],"5":[0,0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":30},"end":{"line":1,"column":49}}},"2":{"name":"(anonymous_2)","line":21,"loc":{"start":{"line":21,"column":19},"end":{"line":21,"column":36}}},"3":{"name":"(anonymous_3)","line":39,"loc":{"start":{"line":39,"column":15},"end":{"line":39,"column":39}}},"4":{"name":"(anonymous_4)","line":51,"loc":{"start":{"line":51,"column":16},"end":{"line":51,"column":40}}},"5":{"name":"(anonymous_5)","line":65,"loc":{"start":{"line":65,"column":23},"end":{"line":65,"column":47}}},"6":{"name":"(anonymous_6)","line":79,"loc":{"start":{"line":79,"column":16},"end":{"line":79,"column":47}}},"7":{"name":"(anonymous_7)","line":92,"loc":{"start":{"line":92,"column":14},"end":{"line":92,"column":40}}},"8":{"name":"(anonymous_8)","line":106,"loc":{"start":{"line":106,"column":16},"end":{"line":106,"column":44}}},"9":{"name":"(anonymous_9)","line":129,"loc":{"start":{"line":129,"column":15},"end":{"line":129,"column":42}}},"10":{"name":"(anonymous_10)","line":145,"loc":{"start":{"line":145,"column":25},"end":{"line":145,"column":42}}},"11":{"name":"(anonymous_11)","line":172,"loc":{"start":{"line":172,"column":19},"end":{"line":172,"column":36}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":207,"column":41}},"2":{"start":{"line":10,"column":0},"end":{"line":10,"column":18}},"3":{"start":{"line":12,"column":0},"end":{"line":201,"column":3}},"4":{"start":{"line":22,"column":8},"end":{"line":27,"column":9}},"5":{"start":{"line":23,"column":12},"end":{"line":23,"column":24}},"6":{"start":{"line":26,"column":12},"end":{"line":26,"column":25}},"7":{"start":{"line":40,"column":8},"end":{"line":40,"column":108}},"8":{"start":{"line":52,"column":8},"end":{"line":52,"column":107}},"9":{"start":{"line":66,"column":8},"end":{"line":66,"column":108}},"10":{"start":{"line":80,"column":8},"end":{"line":80,"column":92}},"11":{"start":{"line":93,"column":8},"end":{"line":93,"column":60}},"12":{"start":{"line":107,"column":8},"end":{"line":107,"column":42}},"13":{"start":{"line":108,"column":8},"end":{"line":108,"column":52}},"14":{"start":{"line":110,"column":8},"end":{"line":110,"column":55}},"15":{"start":{"line":111,"column":8},"end":{"line":111,"column":45}},"16":{"start":{"line":113,"column":8},"end":{"line":113,"column":49}},"17":{"start":{"line":114,"column":8},"end":{"line":114,"column":37}},"18":{"start":{"line":115,"column":8},"end":{"line":115,"column":35}},"19":{"start":{"line":117,"column":8},"end":{"line":117,"column":23}},"20":{"start":{"line":130,"column":8},"end":{"line":130,"column":53}},"21":{"start":{"line":131,"column":8},"end":{"line":131,"column":48}},"22":{"start":{"line":133,"column":8},"end":{"line":133,"column":37}},"23":{"start":{"line":134,"column":8},"end":{"line":134,"column":23}},"24":{"start":{"line":146,"column":7},"end":{"line":148,"column":8}},"25":{"start":{"line":147,"column":9},"end":{"line":147,"column":19}},"26":{"start":{"line":150,"column":7},"end":{"line":153,"column":28}},"27":{"start":{"line":155,"column":7},"end":{"line":157,"column":8}},"28":{"start":{"line":156,"column":11},"end":{"line":156,"column":61}},"29":{"start":{"line":159,"column":7},"end":{"line":159,"column":21}},"30":{"start":{"line":173,"column":8},"end":{"line":175,"column":9}},"31":{"start":{"line":174,"column":12},"end":{"line":174,"column":21}},"32":{"start":{"line":177,"column":8},"end":{"line":177,"column":35}},"33":{"start":{"line":178,"column":8},"end":{"line":178,"column":71}},"34":{"start":{"line":180,"column":8},"end":{"line":198,"column":8}},"35":{"start":{"line":181,"column":12},"end":{"line":181,"column":32}},"36":{"start":{"line":185,"column":12},"end":{"line":185,"column":43}},"37":{"start":{"line":186,"column":12},"end":{"line":197,"column":13}},"38":{"start":{"line":187,"column":19},"end":{"line":187,"column":29}},"39":{"start":{"line":189,"column":17},"end":{"line":197,"column":13}},"40":{"start":{"line":190,"column":19},"end":{"line":190,"column":29}},"41":{"start":{"line":192,"column":17},"end":{"line":197,"column":13}},"42":{"start":{"line":193,"column":19},"end":{"line":193,"column":29}},"43":{"start":{"line":196,"column":19},"end":{"line":196,"column":29}},"44":{"start":{"line":203,"column":0},"end":{"line":203,"column":24}},"45":{"start":{"line":204,"column":0},"end":{"line":204,"column":25}}},"branchMap":{"1":{"line":22,"type":"if","locations":[{"start":{"line":22,"column":8},"end":{"line":22,"column":8}},{"start":{"line":22,"column":8},"end":{"line":22,"column":8}}]},"2":{"line":22,"type":"binary-expr","locations":[{"start":{"line":22,"column":11},"end":{"line":22,"column":29}},{"start":{"line":22,"column":34},"end":{"line":22,"column":49}},{"start":{"line":22,"column":55},"end":{"line":22,"column":78}},{"start":{"line":22,"column":83},"end":{"line":22,"column":96}},{"start":{"line":22,"column":101},"end":{"line":22,"column":114}}]},"3":{"line":40,"type":"binary-expr","locations":[{"start":{"line":40,"column":16},"end":{"line":40,"column":39}},{"start":{"line":40,"column":43},"end":{"line":40,"column":66}},{"start":{"line":40,"column":71},"end":{"line":40,"column":105}}]},"4":{"line":52,"type":"binary-expr","locations":[{"start":{"line":52,"column":16},"end":{"line":52,"column":39}},{"start":{"line":52,"column":43},"end":{"line":52,"column":66}},{"start":{"line":52,"column":71},"end":{"line":52,"column":104}}]},"5":{"line":66,"type":"binary-expr","locations":[{"start":{"line":66,"column":16},"end":{"line":66,"column":39}},{"start":{"line":66,"column":43},"end":{"line":66,"column":66}},{"start":{"line":66,"column":71},"end":{"line":66,"column":105}}]},"6":{"line":80,"type":"binary-expr","locations":[{"start":{"line":80,"column":16},"end":{"line":80,"column":51}},{"start":{"line":80,"column":55},"end":{"line":80,"column":90}}]},"7":{"line":146,"type":"if","locations":[{"start":{"line":146,"column":7},"end":{"line":146,"column":7}},{"start":{"line":146,"column":7},"end":{"line":146,"column":7}}]},"8":{"line":173,"type":"if","locations":[{"start":{"line":173,"column":8},"end":{"line":173,"column":8}},{"start":{"line":173,"column":8},"end":{"line":173,"column":8}}]},"9":{"line":180,"type":"if","locations":[{"start":{"line":180,"column":8},"end":{"line":180,"column":8}},{"start":{"line":180,"column":8},"end":{"line":180,"column":8}}]},"10":{"line":186,"type":"if","locations":[{"start":{"line":186,"column":12},"end":{"line":186,"column":12}},{"start":{"line":186,"column":12},"end":{"line":186,"column":12}}]},"11":{"line":189,"type":"if","locations":[{"start":{"line":189,"column":17},"end":{"line":189,"column":17}},{"start":{"line":189,"column":17},"end":{"line":189,"column":17}}]},"12":{"line":192,"type":"if","locations":[{"start":{"line":192,"column":17},"end":{"line":192,"column":17}},{"start":{"line":192,"column":17},"end":{"line":192,"column":17}}]}},"code":["(function () { YUI.add('datatype-date-math', function (Y, NAME) {","","/**"," * Date Math submodule."," *"," * @module datatype-date"," * @submodule datatype-date-math"," * @for Date"," */","var LANG = Y.Lang;","","Y.mix(Y.namespace(\"Date\"), {","","    /**","     * Checks whether a native JavaScript Date contains a valid value.","     * @for Date","     * @method isValidDate","     * @param oDate {Date} Date in the month for which the number of days is desired.","     * @return {Boolean} True if the date argument contains a valid value.","     */","     isValidDate : function (oDate) {","        if(LANG.isDate(oDate) && (isFinite(oDate)) && (oDate != \"Invalid Date\") && !isNaN(oDate) && (oDate != null)) {","            return true;","        }","        else {","            return false;","        }","    },","","    /**","     * Checks whether two dates correspond to the same date and time.","     * @for Date","     * @method areEqual","     * @param aDate {Date} The first date to compare.","     * @param bDate {Date} The second date to compare.","     * @return {Boolean} True if the two dates correspond to the same","     * date and time.","     */","    areEqual : function (aDate, bDate) {","        return (this.isValidDate(aDate) && this.isValidDate(bDate) && (aDate.getTime() == bDate.getTime()));","    },","","    /**","     * Checks whether the first date comes later than the second.","     * @for Date","     * @method isGreater","     * @param aDate {Date} The first date to compare.","     * @param bDate {Date} The second date to compare.","     * @return {Boolean} True if the first date is later than the second.","     */","    isGreater : function (aDate, bDate) {","        return (this.isValidDate(aDate) && this.isValidDate(bDate) && (aDate.getTime() > bDate.getTime()));","    },","","    /**","     * Checks whether the first date comes later than or is the same as","     * the second.","     * @for Date","     * @method isGreaterOrEqual","     * @param aDate {Date} The first date to compare.","     * @param bDate {Date} The second date to compare.","     * @return {Boolean} True if the first date is later than or","     * the same as the second.","     */","    isGreaterOrEqual : function (aDate, bDate) {","        return (this.isValidDate(aDate) && this.isValidDate(bDate) && (aDate.getTime() >= bDate.getTime()));","    },","","","    /**","     * Checks whether the date is between two other given dates.","     * @for Date","     * @method isInRange","     * @param aDate {Date} The date to check","     * @param bDate {Date} Lower bound of the range.","     * @param cDate {Date} Higher bound of the range.","     * @return {Boolean} True if the date is between the two other given dates.","     */","    isInRange : function (aDate, bDate, cDate) {","        return (this.isGreaterOrEqual(aDate, bDate) && this.isGreaterOrEqual(cDate, aDate));","    },","","    /**","     * Adds a specified number of days to the given date.","     * @for Date","     * @method addDays","     * @param oDate {Date} The date to add days to.","     * @param numDays {Number} The number of days to add (can be negative)","     * @return {Date} A new Date with the specified number of days","     * added to the original date.","     */","    addDays : function (oDate, numDays) {","        return new Date(oDate.getTime() + 86400000*numDays);","    },","","","    /**","     * Adds a specified number of months to the given date.","     * @for Date","     * @method addMonths","     * @param oDate {Date} The date to add months to.","     * @param numMonths {Number} The number of months to add (can be negative)","     * @return {Date} A new Date with the specified number of months","     * added to the original date.","     */","    addMonths : function (oDate, numMonths) {","        var newYear = oDate.getFullYear();","        var newMonth = oDate.getMonth() + numMonths;","","        newYear  = Math.floor(newYear + newMonth / 12);","        newMonth = (newMonth % 12 + 12) % 12;","","        var newDate = new Date (oDate.getTime());","        newDate.setFullYear(newYear);","        newDate.setMonth(newMonth);","","        return newDate;","    },","","    /**","     * Adds a specified number of years to the given date.","     * @for Date","     * @method addYears","     * @param oDate {Date} The date to add years to.","     * @param numYears {Number} The number of years to add (can be negative)","     * @return {Date} A new Date with the specified number of years","     * added to the original date.","     */","    addYears : function (oDate, numYears) {","        var newYear = oDate.getFullYear() + numYears;","        var newDate = new Date(oDate.getTime());","","        newDate.setFullYear(newYear);","        return newDate;","    },","","    /**","     * Lists all dates in a given month.","     * @for Date","     * @method listOfDatesInMonth","     * @param oDate {Date} The date corresponding to the month for","     * which a list of dates is required.","     * @return {Array} An `Array` of `Date`s from a given month.","     */","    listOfDatesInMonth : function (oDate) {","       if (!this.isValidDate(oDate)) {","         return [];","       }","","       var daysInMonth = this.daysInMonth(oDate),","           year        = oDate.getFullYear(),","           month       = oDate.getMonth(),","           output      = [];","","       for (var day = 1; day <= daysInMonth; day++) {","           output.push(new Date(year, month, day, 12, 0, 0));","       }","","       return output;","    },","","    /**","     * Takes a native JavaScript Date and returns the number of days","     * in the month that the given date belongs to.","     * @for Date","     * @method daysInMonth","     * @param oDate {Date} Date in the month for which the number","     * of days is desired.","     * @return {Number} A number (either 28, 29, 30 or 31) of days","     * in the given month.","     */","     daysInMonth : function (oDate) {","        if (!this.isValidDate(oDate)) {","            return 0;","        }","","        var mon = oDate.getMonth();","        var lengths = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];","","        if (mon != 1) {","            return lengths[mon];","        }","        else {","","            var year = oDate.getFullYear();","            if (year%400 === 0) {","                   return 29;","            }","            else if (year%100 === 0) {","                   return 28;","            }","            else if (year%4 === 0) {","                   return 29;","            }","            else {","                   return 28;","            }","       }","    }","","});","","Y.namespace(\"DataType\");","Y.DataType.Date = Y.Date;","","","}, '3.18.1', {\"requires\": [\"yui-base\"]});","","}());"]};
}
var __cov_msloGZ_EyNhKYRQbqr47nQ = __coverage__['build/datatype-date-math/datatype-date-math.js'];
__cov_msloGZ_EyNhKYRQbqr47nQ.s['1']++;YUI.add('datatype-date-math',function(Y,NAME){__cov_msloGZ_EyNhKYRQbqr47nQ.f['1']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['2']++;var LANG=Y.Lang;__cov_msloGZ_EyNhKYRQbqr47nQ.s['3']++;Y.mix(Y.namespace('Date'),{isValidDate:function(oDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['2']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['4']++;if((__cov_msloGZ_EyNhKYRQbqr47nQ.b['2'][0]++,LANG.isDate(oDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['2'][1]++,isFinite(oDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['2'][2]++,oDate!='Invalid Date')&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['2'][3]++,!isNaN(oDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['2'][4]++,oDate!=null)){__cov_msloGZ_EyNhKYRQbqr47nQ.b['1'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['5']++;return true;}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['1'][1]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['6']++;return false;}},areEqual:function(aDate,bDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['3']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['7']++;return(__cov_msloGZ_EyNhKYRQbqr47nQ.b['3'][0]++,this.isValidDate(aDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['3'][1]++,this.isValidDate(bDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['3'][2]++,aDate.getTime()==bDate.getTime());},isGreater:function(aDate,bDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['4']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['8']++;return(__cov_msloGZ_EyNhKYRQbqr47nQ.b['4'][0]++,this.isValidDate(aDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['4'][1]++,this.isValidDate(bDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['4'][2]++,aDate.getTime()>bDate.getTime());},isGreaterOrEqual:function(aDate,bDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['5']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['9']++;return(__cov_msloGZ_EyNhKYRQbqr47nQ.b['5'][0]++,this.isValidDate(aDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['5'][1]++,this.isValidDate(bDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['5'][2]++,aDate.getTime()>=bDate.getTime());},isInRange:function(aDate,bDate,cDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['6']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['10']++;return(__cov_msloGZ_EyNhKYRQbqr47nQ.b['6'][0]++,this.isGreaterOrEqual(aDate,bDate))&&(__cov_msloGZ_EyNhKYRQbqr47nQ.b['6'][1]++,this.isGreaterOrEqual(cDate,aDate));},addDays:function(oDate,numDays){__cov_msloGZ_EyNhKYRQbqr47nQ.f['7']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['11']++;return new Date(oDate.getTime()+86400000*numDays);},addMonths:function(oDate,numMonths){__cov_msloGZ_EyNhKYRQbqr47nQ.f['8']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['12']++;var newYear=oDate.getFullYear();__cov_msloGZ_EyNhKYRQbqr47nQ.s['13']++;var newMonth=oDate.getMonth()+numMonths;__cov_msloGZ_EyNhKYRQbqr47nQ.s['14']++;newYear=Math.floor(newYear+newMonth/12);__cov_msloGZ_EyNhKYRQbqr47nQ.s['15']++;newMonth=(newMonth%12+12)%12;__cov_msloGZ_EyNhKYRQbqr47nQ.s['16']++;var newDate=new Date(oDate.getTime());__cov_msloGZ_EyNhKYRQbqr47nQ.s['17']++;newDate.setFullYear(newYear);__cov_msloGZ_EyNhKYRQbqr47nQ.s['18']++;newDate.setMonth(newMonth);__cov_msloGZ_EyNhKYRQbqr47nQ.s['19']++;return newDate;},addYears:function(oDate,numYears){__cov_msloGZ_EyNhKYRQbqr47nQ.f['9']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['20']++;var newYear=oDate.getFullYear()+numYears;__cov_msloGZ_EyNhKYRQbqr47nQ.s['21']++;var newDate=new Date(oDate.getTime());__cov_msloGZ_EyNhKYRQbqr47nQ.s['22']++;newDate.setFullYear(newYear);__cov_msloGZ_EyNhKYRQbqr47nQ.s['23']++;return newDate;},listOfDatesInMonth:function(oDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['10']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['24']++;if(!this.isValidDate(oDate)){__cov_msloGZ_EyNhKYRQbqr47nQ.b['7'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['25']++;return[];}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['7'][1]++;}__cov_msloGZ_EyNhKYRQbqr47nQ.s['26']++;var daysInMonth=this.daysInMonth(oDate),year=oDate.getFullYear(),month=oDate.getMonth(),output=[];__cov_msloGZ_EyNhKYRQbqr47nQ.s['27']++;for(var day=1;day<=daysInMonth;day++){__cov_msloGZ_EyNhKYRQbqr47nQ.s['28']++;output.push(new Date(year,month,day,12,0,0));}__cov_msloGZ_EyNhKYRQbqr47nQ.s['29']++;return output;},daysInMonth:function(oDate){__cov_msloGZ_EyNhKYRQbqr47nQ.f['11']++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['30']++;if(!this.isValidDate(oDate)){__cov_msloGZ_EyNhKYRQbqr47nQ.b['8'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['31']++;return 0;}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['8'][1]++;}__cov_msloGZ_EyNhKYRQbqr47nQ.s['32']++;var mon=oDate.getMonth();__cov_msloGZ_EyNhKYRQbqr47nQ.s['33']++;var lengths=[31,28,31,30,31,30,31,31,30,31,30,31];__cov_msloGZ_EyNhKYRQbqr47nQ.s['34']++;if(mon!=1){__cov_msloGZ_EyNhKYRQbqr47nQ.b['9'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['35']++;return lengths[mon];}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['9'][1]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['36']++;var year=oDate.getFullYear();__cov_msloGZ_EyNhKYRQbqr47nQ.s['37']++;if(year%400===0){__cov_msloGZ_EyNhKYRQbqr47nQ.b['10'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['38']++;return 29;}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['10'][1]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['39']++;if(year%100===0){__cov_msloGZ_EyNhKYRQbqr47nQ.b['11'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['40']++;return 28;}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['11'][1]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['41']++;if(year%4===0){__cov_msloGZ_EyNhKYRQbqr47nQ.b['12'][0]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['42']++;return 29;}else{__cov_msloGZ_EyNhKYRQbqr47nQ.b['12'][1]++;__cov_msloGZ_EyNhKYRQbqr47nQ.s['43']++;return 28;}}}}}});__cov_msloGZ_EyNhKYRQbqr47nQ.s['44']++;Y.namespace('DataType');__cov_msloGZ_EyNhKYRQbqr47nQ.s['45']++;Y.DataType.Date=Y.Date;},'3.18.1',{'requires':['yui-base']});
