/*
YUI 3.18.1 (build f7e7bcb)
Copyright 2014 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/tree-openable/tree-openable.js']) {
   __coverage__['build/tree-openable/tree-openable.js'] = {"path":"build/tree-openable/tree-openable.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":25},"end":{"line":1,"column":44}}},"2":{"name":"Openable","line":41,"loc":{"start":{"line":41,"column":0},"end":{"line":41,"column":20}}},"3":{"name":"(anonymous_3)","line":45,"loc":{"start":{"line":45,"column":17},"end":{"line":45,"column":29}}},"4":{"name":"(anonymous_4)","line":65,"loc":{"start":{"line":65,"column":15},"end":{"line":65,"column":40}}},"5":{"name":"(anonymous_5)","line":93,"loc":{"start":{"line":93,"column":14},"end":{"line":93,"column":39}}},"6":{"name":"(anonymous_6)","line":122,"loc":{"start":{"line":122,"column":20},"end":{"line":122,"column":45}}},"7":{"name":"(anonymous_7)","line":136,"loc":{"start":{"line":136,"column":17},"end":{"line":136,"column":30}}},"8":{"name":"(anonymous_8)","line":147,"loc":{"start":{"line":147,"column":16},"end":{"line":147,"column":29}}},"9":{"name":"NodeOpenable","line":167,"loc":{"start":{"line":167,"column":0},"end":{"line":167,"column":24}}},"10":{"name":"(anonymous_10)","line":183,"loc":{"start":{"line":183,"column":11},"end":{"line":183,"column":30}}},"11":{"name":"(anonymous_11)","line":196,"loc":{"start":{"line":196,"column":12},"end":{"line":196,"column":24}}},"12":{"name":"(anonymous_12)","line":213,"loc":{"start":{"line":213,"column":10},"end":{"line":213,"column":29}}},"13":{"name":"(anonymous_13)","line":232,"loc":{"start":{"line":232,"column":16},"end":{"line":232,"column":35}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":241,"column":37}},"2":{"start":{"line":29,"column":0},"end":{"line":29,"column":24}},"3":{"start":{"line":39,"column":0},"end":{"line":39,"column":22}},"4":{"start":{"line":41,"column":0},"end":{"line":41,"column":22}},"5":{"start":{"line":43,"column":0},"end":{"line":150,"column":2}},"6":{"start":{"line":46,"column":8},"end":{"line":46,"column":79}},"7":{"start":{"line":66,"column":8},"end":{"line":74,"column":9}},"8":{"start":{"line":67,"column":12},"end":{"line":73,"column":15}},"9":{"start":{"line":76,"column":8},"end":{"line":76,"column":20}},"10":{"start":{"line":94,"column":8},"end":{"line":102,"column":9}},"11":{"start":{"line":95,"column":12},"end":{"line":101,"column":15}},"12":{"start":{"line":104,"column":8},"end":{"line":104,"column":20}},"13":{"start":{"line":123,"column":8},"end":{"line":124,"column":41}},"14":{"start":{"line":137,"column":8},"end":{"line":137,"column":33}},"15":{"start":{"line":148,"column":8},"end":{"line":148,"column":33}},"16":{"start":{"line":152,"column":0},"end":{"line":152,"column":27}},"17":{"start":{"line":167,"column":0},"end":{"line":167,"column":26}},"18":{"start":{"line":169,"column":0},"end":{"line":236,"column":2}},"19":{"start":{"line":184,"column":8},"end":{"line":184,"column":43}},"20":{"start":{"line":185,"column":8},"end":{"line":185,"column":20}},"21":{"start":{"line":197,"column":8},"end":{"line":197,"column":50}},"22":{"start":{"line":214,"column":8},"end":{"line":214,"column":42}},"23":{"start":{"line":215,"column":8},"end":{"line":215,"column":20}},"24":{"start":{"line":233,"column":8},"end":{"line":233,"column":48}},"25":{"start":{"line":234,"column":8},"end":{"line":234,"column":20}},"26":{"start":{"line":238,"column":0},"end":{"line":238,"column":36}}},"branchMap":{"1":{"line":66,"type":"if","locations":[{"start":{"line":66,"column":8},"end":{"line":66,"column":8}},{"start":{"line":66,"column":8},"end":{"line":66,"column":8}}]},"2":{"line":66,"type":"binary-expr","locations":[{"start":{"line":66,"column":12},"end":{"line":66,"column":32}},{"start":{"line":66,"column":36},"end":{"line":66,"column":49}}]},"3":{"line":69,"type":"binary-expr","locations":[{"start":{"line":69,"column":22},"end":{"line":69,"column":29}},{"start":{"line":69,"column":33},"end":{"line":69,"column":44}}]},"4":{"line":72,"type":"binary-expr","locations":[{"start":{"line":72,"column":27},"end":{"line":72,"column":34}},{"start":{"line":72,"column":38},"end":{"line":72,"column":52}}]},"5":{"line":94,"type":"if","locations":[{"start":{"line":94,"column":8},"end":{"line":94,"column":8}},{"start":{"line":94,"column":8},"end":{"line":94,"column":8}}]},"6":{"line":94,"type":"binary-expr","locations":[{"start":{"line":94,"column":12},"end":{"line":94,"column":32}},{"start":{"line":94,"column":36},"end":{"line":94,"column":50}}]},"7":{"line":97,"type":"binary-expr","locations":[{"start":{"line":97,"column":22},"end":{"line":97,"column":29}},{"start":{"line":97,"column":33},"end":{"line":97,"column":44}}]},"8":{"line":100,"type":"binary-expr","locations":[{"start":{"line":100,"column":27},"end":{"line":100,"column":34}},{"start":{"line":100,"column":38},"end":{"line":100,"column":52}}]},"9":{"line":123,"type":"cond-expr","locations":[{"start":{"line":123,"column":31},"end":{"line":123,"column":60}},{"start":{"line":124,"column":12},"end":{"line":124,"column":40}}]},"10":{"line":197,"type":"binary-expr","locations":[{"start":{"line":197,"column":15},"end":{"line":197,"column":32}},{"start":{"line":197,"column":36},"end":{"line":197,"column":49}}]}},"code":["(function () { YUI.add('tree-openable', function (Y, NAME) {","","/*jshint expr:true, onevar:false */","","/**","Extension for `Tree` that adds the concept of open/closed state for nodes.","","@module tree","@submodule tree-openable","@main tree-openable","**/","","/**","Extension for `Tree` that adds the concept of open/closed state for nodes.","","@class Tree.Openable","@constructor","@extensionfor Tree","**/","","/**","Fired when a node is closed.","","@event close","@param {Tree.Node} node Node being closed.","@param {String} src Source of the event.","@preventable _defCloseFn","**/","var EVT_CLOSE = 'close';","","/**","Fired when a node is opened.","","@event open","@param {Tree.Node} node Node being opened.","@param {String} src Source of the event.","@preventable _defOpenFn","**/","var EVT_OPEN = 'open';","","function Openable() {}","","Openable.prototype = {","    // -- Lifecycle ------------------------------------------------------------","    initializer: function () {","        this.nodeExtensions = this.nodeExtensions.concat(Y.Tree.Node.Openable);","    },","","    // -- Public Methods -------------------------------------------------------","","    /**","    Closes the specified node if it isn't already closed.","","    @method closeNode","    @param {Tree.Node} node Node to close.","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `close` event","            will be suppressed.","        @param {String} [options.src] Source of the change, to be passed along","            to the event facade of the resulting event. This can be used to","            distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","    @chainable","    **/","    closeNode: function (node, options) {","        if (node.canHaveChildren && node.isOpen()) {","            this._fireTreeEvent(EVT_CLOSE, {","                node: node,","                src : options && options.src","            }, {","                defaultFn: this._defCloseFn,","                silent   : options && options.silent","            });","        }","","        return this;","    },","","    /**","    Opens the specified node if it isn't already open.","","    @method openNode","    @param {Tree.Node} node Node to open.","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `open` event","            will be suppressed.","        @param {String} [options.src] Source of the change, to be passed along","            to the event facade of the resulting event. This can be used to","            distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","    @chainable","    **/","    openNode: function (node, options) {","        if (node.canHaveChildren && !node.isOpen()) {","            this._fireTreeEvent(EVT_OPEN, {","                node: node,","                src : options && options.src","            }, {","                defaultFn: this._defOpenFn,","                silent   : options && options.silent","            });","        }","","        return this;","    },","","    /**","    Toggles the open/closed state of the specified node, closing it if it's","    currently open or opening it if it's currently closed.","","    @method toggleOpenNode","    @param {Tree.Node} node Node to toggle.","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, events will be","            suppressed.","        @param {String} [options.src] Source of the change, to be passed along","            to the event facade of the resulting event. This can be used to","            distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","    @chainable","    **/","    toggleOpenNode: function (node, options) {","        return node.isOpen() ? this.closeNode(node, options) :","            this.openNode(node, options);","    },","","    // -- Default Event Handlers -----------------------------------------------","","    /**","    Default handler for the `close` event.","","    @method _defCloseFn","    @param {EventFacade} e","    @protected","    **/","    _defCloseFn: function (e) {","        delete e.node.state.open;","    },","","    /**","    Default handler for the `open` event.","","    @method _defOpenFn","    @param {EventFacade} e","    @protected","    **/","    _defOpenFn: function (e) {","        e.node.state.open = true;","    }","};","","Y.Tree.Openable = Openable;","/**","@module tree","@submodule tree-openable","**/","","/**","`Tree.Node` extension that adds methods useful for nodes in trees that use the","`Tree.Openable` extension.","","@class Tree.Node.Openable","@constructor","@extensionfor Tree.Node","**/","","function NodeOpenable() {}","","NodeOpenable.prototype = {","    /**","    Closes this node if it's currently open.","","    @method close","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `close` event","            will be suppressed.","        @param {String} [options.src] Source of the change, to be passed along","            to the event facade of the resulting event. This can be used to","            distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","    @chainable","    **/","    close: function (options) {","        this.tree.closeNode(this, options);","        return this;","    },","","    /**","    Returns `true` if this node is currently open.","","    Note: the root node of a tree is always considered to be open.","","    @method isOpen","    @return {Boolean} `true` if this node is currently open, `false` otherwise.","    **/","    isOpen: function () {","        return !!this.state.open || this.isRoot();","    },","","    /**","    Opens this node if it's currently closed.","","    @method open","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `open` event","            will be suppressed.","        @param {String} [options.src] Source of the change, to be passed along","            to the event facade of the resulting event. This can be used to","            distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","    @chainable","    **/","    open: function (options) {","        this.tree.openNode(this, options);","        return this;","    },","","    /**","    Toggles the open/closed state of this node, closing it if it's currently","    open or opening it if it's currently closed.","","    @method toggleOpen","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, events will be","            suppressed.","        @param {String} [options.src] Source of the change, to be passed along","            to the event facade of the resulting event. This can be used to","            distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","    @chainable","    **/","    toggleOpen: function (options) {","        this.tree.toggleOpenNode(this, options);","        return this;","    }","};","","Y.Tree.Node.Openable = NodeOpenable;","","","}, '3.18.1', {\"requires\": [\"tree\"]});","","}());"]};
}
var __cov_TqaujPOKnZXSPa1iI_f4sA = __coverage__['build/tree-openable/tree-openable.js'];
__cov_TqaujPOKnZXSPa1iI_f4sA.s['1']++;YUI.add('tree-openable',function(Y,NAME){__cov_TqaujPOKnZXSPa1iI_f4sA.f['1']++;__cov_TqaujPOKnZXSPa1iI_f4sA.s['2']++;var EVT_CLOSE='close';__cov_TqaujPOKnZXSPa1iI_f4sA.s['3']++;var EVT_OPEN='open';__cov_TqaujPOKnZXSPa1iI_f4sA.s['4']++;function Openable(){__cov_TqaujPOKnZXSPa1iI_f4sA.f['2']++;}__cov_TqaujPOKnZXSPa1iI_f4sA.s['5']++;Openable.prototype={initializer:function(){__cov_TqaujPOKnZXSPa1iI_f4sA.f['3']++;__cov_TqaujPOKnZXSPa1iI_f4sA.s['6']++;this.nodeExtensions=this.nodeExtensions.concat(Y.Tree.Node.Openable);},closeNode:function(node,options){__cov_TqaujPOKnZXSPa1iI_f4sA.f['4']++;__cov_TqaujPOKnZXSPa1iI_f4sA.s['7']++;if((__cov_TqaujPOKnZXSPa1iI_f4sA.b['2'][0]++,node.canHaveChildren)&&(__cov_TqaujPOKnZXSPa1iI_f4sA.b['2'][1]++,node.isOpen())){__cov_TqaujPOKnZXSPa1iI_f4sA.b['1'][0]++;__cov_TqaujPOKnZXSPa1iI_f4sA.s['8']++;this._fireTreeEvent(EVT_CLOSE,{node:node,src:(__cov_TqaujPOKnZXSPa1iI_f4sA.b['3'][0]++,options)&&(__cov_TqaujPOKnZXSPa1iI_f4sA.b['3'][1]++,options.src)},{defaultFn:this._defCloseFn,silent:(__cov_TqaujPOKnZXSPa1iI_f4sA.b['4'][0]++,options)&&(__cov_TqaujPOKnZXSPa1iI_f4sA.b['4'][1]++,options.silent)});}else{__cov_TqaujPOKnZXSPa1iI_f4sA.b['1'][1]++;}__cov_TqaujPOKnZXSPa1iI_f4sA.s['9']++;return this;},openNode:function(node,options){__cov_TqaujPOKnZXSPa1iI_f4sA.f['5']++;__cov_TqaujPOKnZXSPa1iI_f4sA.s['10']++;if((__cov_TqaujPOKnZXSPa1iI_f4sA.b['6'][0]++,node.canHaveChildren)&&(__cov_TqaujPOKnZXSPa1iI_f4sA.b['6'][1]++,!node.isOpen())){__cov_TqaujPOKnZXSPa1iI_f4sA.b['5'][0]++;__cov_TqaujPOKnZXSPa1iI_f4sA.s['11']++;this._fireTreeEvent(EVT_OPEN,{node:node,src:(__cov_TqaujPOKnZXSPa1iI_f4sA.b['7'][0]++,options)&&(__cov_TqaujPOKnZXSPa1iI_f4sA.b['7'][1]++,options.src)},{defaultFn:this._defOpenFn,silent:(__cov_TqaujPOKnZXSPa1iI_f4sA.b['8'][0]++,options)&&(__cov_TqaujPOKnZXSPa1iI_f4sA.b['8'][1]++,options.silent)});}else{__cov_TqaujPOKnZXSPa1iI_f4sA.b['5'][1]++;}__cov_TqaujPOKnZXSPa1iI_f4sA.s['12']++;return this;},toggleOpenNode:function(node,options){__cov_TqaujPOKnZXSPa1iI_f4sA.f['6']++;__cov_TqaujPOKnZXSPa1iI_f4sA.s['13']++;return node.isOpen()?(__cov_TqaujPOKnZXSPa1iI_f4sA.b['9'][0]++,this.closeNode(node,options)):(__cov_TqaujPOKnZXSPa1iI_f4sA.b['9'][1]++,this.openNode(node,options));},_defCloseFn:function(e){__cov_TqaujPOKnZXSPa1iI_f4sA.f['7']++;__cov_TqaujPOKnZXSPa1iI_f4sA.s['14']++;delete e.node.state.open;},_defOpenFn:function(e){__cov_TqaujPOKnZXSPa1iI_f4sA.f['8']++;__cov_TqaujPOKnZXSPa1iI_f4sA.s['15']++;e.node.state.open=true;}};__cov_TqaujPOKnZXSPa1iI_f4sA.s['16']++;Y.Tree.Openable=Openable;__cov_TqaujPOKnZXSPa1iI_f4sA.s['17']++;function NodeOpenable(){__cov_TqaujPOKnZXSPa1iI_f4sA.f['9']++;}__cov_TqaujPOKnZXSPa1iI_f4sA.s['18']++;NodeOpenable.prototype={close:function(options){__cov_TqaujPOKnZXSPa1iI_f4sA.f['10']++;__cov_TqaujPOKnZXSPa1iI_f4sA.s['19']++;this.tree.closeNode(this,options);__cov_TqaujPOKnZXSPa1iI_f4sA.s['20']++;return this;},isOpen:function(){__cov_TqaujPOKnZXSPa1iI_f4sA.f['11']++;__cov_TqaujPOKnZXSPa1iI_f4sA.s['21']++;return(__cov_TqaujPOKnZXSPa1iI_f4sA.b['10'][0]++,!!this.state.open)||(__cov_TqaujPOKnZXSPa1iI_f4sA.b['10'][1]++,this.isRoot());},open:function(options){__cov_TqaujPOKnZXSPa1iI_f4sA.f['12']++;__cov_TqaujPOKnZXSPa1iI_f4sA.s['22']++;this.tree.openNode(this,options);__cov_TqaujPOKnZXSPa1iI_f4sA.s['23']++;return this;},toggleOpen:function(options){__cov_TqaujPOKnZXSPa1iI_f4sA.f['13']++;__cov_TqaujPOKnZXSPa1iI_f4sA.s['24']++;this.tree.toggleOpenNode(this,options);__cov_TqaujPOKnZXSPa1iI_f4sA.s['25']++;return this;}};__cov_TqaujPOKnZXSPa1iI_f4sA.s['26']++;Y.Tree.Node.Openable=NodeOpenable;},'3.18.1',{'requires':['tree']});
