/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.data.impl;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.impl.SliceableDataWrapper;

public class ByteBufferDataWrapper
extends SliceableDataWrapper {
    private ByteBuffer buffer;

    public ByteBufferDataWrapper(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int getReadableSize() {
        return this.buffer.remaining();
    }

    @Override
    public byte readByteAt(int i) {
        return this.buffer.get(i);
    }

    @Override
    public String createStringFrom(int offset, int length, Charset charSet) {
        byte[] data = new byte[length];
        this.buffer.mark();
        this.buffer.position(offset);
        this.buffer.get(data);
        this.buffer.reset();
        return new String(data, charSet);
    }

    @Override
    public byte[] createByteArray() {
        byte[] data = new byte[this.buffer.remaining()];
        this.buffer.mark();
        this.buffer.get(data);
        this.buffer.reset();
        return data;
    }

    @Override
    public void addUnderlyingBuffersToList(List<ByteBuffer> buffers) {
        buffers.add(this.buffer);
    }

    @Override
    public ByteBuffer getSlicedBuffer(int offset, int length) {
        int position = this.buffer.position();
        int limit = this.buffer.limit();
        this.buffer.position(offset);
        this.buffer.limit(offset + length);
        ByteBuffer theView = this.buffer.slice();
        this.buffer.position(position);
        this.buffer.limit(limit);
        return theView;
    }

    @Override
    protected void releaseImpl(BufferPool pool) {
        this.buffer.position(this.buffer.limit());
        pool.releaseBuffer(this.buffer);
    }
}

