/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.data.api;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;

public class BufferCreationPool
implements BufferPool {
    private static final Logger log = LoggerFactory.getLogger(BufferCreationPool.class);
    public static final int DEFAULT_MAX_BUFFER_SIZE = 16921;
    private AtomicInteger counter = new AtomicInteger();
    private ConcurrentLinkedQueue<ByteBuffer> freePackets = new ConcurrentLinkedQueue();
    private boolean isDirect;
    private int bufferSize;
    private int poolSize;

    public BufferCreationPool() {
        this(false, 16921, 1000);
    }

    public BufferCreationPool(boolean isDirect, int bufferSize, int poolSize) {
        this.isDirect = isDirect;
        this.bufferSize = bufferSize;
        this.poolSize = poolSize;
    }

    @Override
    public ByteBuffer nextBuffer(int minSize) {
        if (this.bufferSize < minSize) {
            log.error("minSize=" + minSize + " requests is larger than the buffer size provided by this pool=" + this.bufferSize + ".  You should reconfigure this ");
            return this.createBuffer(minSize);
        }
        ByteBuffer buffer = this.freePackets.poll();
        if (buffer == null) {
            buffer = this.createBuffer(this.bufferSize);
        } else {
            this.counter.decrementAndGet();
        }
        return buffer;
    }

    @Override
    public ByteBuffer createWithDataWrapper(DataWrapper data) {
        ByteBuffer byteBuffer = this.nextBuffer(data.getReadableSize());
        byteBuffer.put(data.createByteArray());
        byteBuffer.flip();
        return byteBuffer;
    }

    private ByteBuffer createBuffer(int size2) {
        ByteBuffer buffer = this.isDirect ? ByteBuffer.allocateDirect(size2) : ByteBuffer.allocate(size2);
        return buffer;
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
        if (buffer.remaining() != 0) {
            throw new IllegalArgumentException("You need to consume all data from your buffer (or call buffer.position(buffer.limit)) to simulate consuming it though this is ill advised as youshould be reading all your data from your buffer before releasing it");
        }
        if (this.counter.incrementAndGet() > this.poolSize) {
            return;
        }
        if (buffer.capacity() < this.bufferSize) {
            return;
        }
        buffer.clear();
        this.freePackets.add(buffer);
    }
}

