/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.data.impl;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.impl.AbstractDataWrapper;
import org.webpieces.data.impl.SliceableDataWrapper;

public class ChainedDataWrapper
extends AbstractDataWrapper {
    private List<SliceableDataWrapper> wrappers = new ArrayList<SliceableDataWrapper>();

    ChainedDataWrapper(SliceableDataWrapper wrapper1, SliceableDataWrapper wrapper2) {
        this.wrappers.add(wrapper1);
        this.wrappers.add(wrapper2);
    }

    ChainedDataWrapper(List<SliceableDataWrapper> wrappers) {
        this.wrappers = wrappers;
    }

    public ChainedDataWrapper(SliceableDataWrapper wrapper) {
        this.wrappers = new ArrayList<SliceableDataWrapper>();
        this.wrappers.add(wrapper);
    }

    @Override
    public int getReadableSize() {
        int size = 0;
        for (DataWrapper dataWrapper : this.wrappers) {
            size += dataWrapper.getReadableSize();
        }
        return size;
    }

    @Override
    public byte readByteAt(int i) {
        int j = i;
        for (DataWrapper dataWrapper : this.wrappers) {
            int size = dataWrapper.getReadableSize();
            if (j < size) {
                return dataWrapper.readByteAt(j);
            }
            j -= size;
        }
        throw new IndexOutOfBoundsException("i=" + i + " is out of bounds of size=" + this.getReadableSize());
    }

    @Override
    public String createStringFrom(int initialOffset, int length, Charset charSet) {
        if (length == 0) {
            return "";
        }
        String result = "";
        int lengthLeftToRead = length;
        int offset = initialOffset;
        for (DataWrapper dataWrapper : this.wrappers) {
            int size = dataWrapper.getReadableSize();
            if (offset < size) {
                if (offset + lengthLeftToRead <= size) {
                    result = result + dataWrapper.createStringFrom(offset, lengthLeftToRead, charSet);
                    return result;
                }
                int leftInBuffer = size - offset;
                result = result + dataWrapper.createStringFrom(offset, leftInBuffer, charSet);
                offset = 0;
                lengthLeftToRead -= leftInBuffer;
                continue;
            }
            offset -= size;
        }
        throw new IndexOutOfBoundsException("offset=" + offset + " length=" + length + " is larger than size=" + this.getReadableSize());
    }

    @Override
    public byte[] createByteArray() {
        byte[] copy = new byte[this.getReadableSize()];
        int offset = 0;
        for (DataWrapper dataWrapper : this.wrappers) {
            byte[] data = dataWrapper.createByteArray();
            int size = dataWrapper.getReadableSize();
            System.arraycopy(data, 0, copy, offset, size);
            offset += size;
        }
        return copy;
    }

    void addMoreData(DataWrapper secondData) {
        if (secondData instanceof ChainedDataWrapper) {
            ChainedDataWrapper wrap = (ChainedDataWrapper)secondData;
            this.wrappers.addAll(wrap.getAllWrappers());
            return;
        }
        if (!(secondData instanceof SliceableDataWrapper)) {
            throw new IllegalArgumentException("Only SliceableDataWrappers or ChainedDataWrappers are allowed to be chained");
        }
        SliceableDataWrapper wrap = (SliceableDataWrapper)secondData;
        this.wrappers.add(wrap);
    }

    private List<SliceableDataWrapper> getAllWrappers() {
        return this.wrappers;
    }

    @Override
    public int getNumLayers() {
        int max = 0;
        for (DataWrapper dataWrapper : this.wrappers) {
            int num = dataWrapper.getNumLayers();
            if (num <= max) continue;
            max = num;
        }
        return max + 1;
    }

    @Override
    public void addUnderlyingBuffersToList(List<ByteBuffer> buffers) {
        for (SliceableDataWrapper wrapper : this.wrappers) {
            wrapper.addUnderlyingBuffersToList(buffers);
        }
    }

    List<SliceableDataWrapper> getWrappers() {
        return this.wrappers;
    }

    @Override
    public void releaseUnderlyingBuffers(BufferPool pool) {
        for (DataWrapper dataWrapper : this.wrappers) {
            dataWrapper.releaseUnderlyingBuffers(pool);
        }
    }
}

