/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.recording.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.webpieces.recording.api.Playback;

public class PlaybackImpl
implements Playback {
    private ReadableByteChannel channel;
    private int version;

    public PlaybackImpl(InputStream in, int version) {
        if (version != 1) {
            throw new IllegalArgumentException("only version=1 supported right now");
        }
        this.version = version;
        this.channel = Channels.newChannel(in);
    }

    @Override
    public ByteBuffer getNextPacket() {
        try {
            if (this.version == 1) {
                return this.startImpl();
            }
            throw new IllegalArgumentException("version=" + this.version + " not supported");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer startImpl() throws IOException {
        ByteBuffer sizeBuf = ByteBuffer.allocate(4);
        int bytesRead = this.channel.read(sizeBuf);
        if (bytesRead < 0) {
            return null;
        }
        sizeBuf.flip();
        int size = sizeBuf.getInt();
        ByteBuffer data = ByteBuffer.allocate(size);
        this.channel.read(data);
        data.flip();
        ByteBuffer trailerBuf = ByteBuffer.allocate(7);
        this.channel.read(trailerBuf);
        trailerBuf.flip();
        byte[] trailer = new byte[7];
        trailerBuf.get(trailer);
        for (int i = 0; i < trailer.length; ++i) {
            byte d = trailer[i];
            if (i == d) continue;
            throw new IllegalStateException("corruption on input stream.  read in size=" + size + " but the trailer at the end is not matching");
        }
        return data;
    }
}

