/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.recording.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.recording.api.Recorder;

public class RecorderImpl
implements Recorder {
    private DataWrapperGenerator gen;
    private WritableByteChannel channel;
    private int version;

    public RecorderImpl(OutputStream out, DataWrapperGenerator gen, int version) {
        if (version != 1) {
            throw new IllegalArgumentException("only version=1 supported right now");
        }
        this.channel = Channels.newChannel(out);
        this.gen = gen;
        this.version = version;
    }

    @Override
    public void record(ByteBuffer b) {
        try {
            if (this.version != 1) {
                throw new IllegalArgumentException("version=" + this.version + " not supported");
            }
            this.recordImpl(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void recordImpl(ByteBuffer b) throws IOException {
        DataWrapper wrapper = this.gen.wrapByteBuffer(b);
        int size = wrapper.getReadableSize();
        ByteBuffer sizeBuf = ByteBuffer.allocate(4);
        sizeBuf.putInt(size);
        sizeBuf.flip();
        this.channel.write(sizeBuf);
        ByteBuffer shallowCopy = b.duplicate();
        this.channel.write(shallowCopy);
        byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6};
        ByteBuffer trailer = ByteBuffer.wrap(data);
        this.channel.write(trailer);
    }
}

