/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.googlecloud.storage.impl.raw;

import com.google.api.gax.paging.Page;
import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Storage;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.webpieces.googlecloud.storage.api.CopyInterface;
import org.webpieces.googlecloud.storage.api.GCPBlob;
import org.webpieces.googlecloud.storage.api.GCPRawStorage;
import org.webpieces.googlecloud.storage.impl.StorageSupplier;
import org.webpieces.googlecloud.storage.impl.raw.CopyWriterImpl;
import org.webpieces.googlecloud.storage.impl.raw.GCPBlobImpl;
import org.webpieces.googlecloud.storage.impl.raw.GCPPageImpl;
import org.webpieces.util.SingletonSupplier;

@Singleton
public class GCPRawStorageImpl
implements GCPRawStorage {
    private SingletonSupplier<Storage> storage;

    @Inject
    public GCPRawStorageImpl(StorageSupplier storage) {
        this.storage = new SingletonSupplier((Supplier)storage);
    }

    @Override
    public Bucket get(String bucket, Storage.BucketGetOption ... options) {
        return ((Storage)this.storage.get()).get(bucket, options);
    }

    @Override
    public GCPBlob get(String bucket, String blob, Storage.BlobGetOption ... options) {
        Blob blob1 = ((Storage)this.storage.get()).get(bucket, blob, options);
        return new GCPBlobImpl(blob1);
    }

    @Override
    public Page<GCPBlob> list(String bucket, Storage.BlobListOption ... options) {
        Page list = ((Storage)this.storage.get()).list(bucket, options);
        return new GCPPageImpl((Page<Blob>)list);
    }

    @Override
    public boolean delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return ((Storage)this.storage.get()).delete(bucket, blob, options);
    }

    @Override
    public byte[] readAllBytes(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return ((Storage)this.storage.get()).readAllBytes(bucket, blob, options);
    }

    public ReadChannel reader(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return ((Storage)this.storage.get()).reader(bucket, blob, options);
    }

    public WriteChannel writer(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        return ((Storage)this.storage.get()).writer(blobInfo, options);
    }

    @Override
    public CopyInterface copy(Storage.CopyRequest copyRequest) {
        CopyWriter copyWriter = ((Storage)this.storage.get()).copy(copyRequest);
        return new CopyWriterImpl(copyWriter);
    }
}

