/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.googlecloud.storage.impl;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.inject.Inject;
import javax.inject.Provider;
import org.webpieces.googlecloud.storage.impl.ChannelInvocationHandler;

public class ChannelWrapper {
    private Provider<ChannelInvocationHandler> invocHandlerProvider;

    @Inject
    public ChannelWrapper(Provider<ChannelInvocationHandler> invocHandlerProvider) {
        this.invocHandlerProvider = invocHandlerProvider;
    }

    public ReadableByteChannel createReader(Blob blob) {
        return (ReadableByteChannel)this.newChannelProxy(ReadableByteChannel.class, blob.reader(new Blob.BlobSourceOption[0]));
    }

    public WritableByteChannel createWriter(Blob blob) {
        return (WritableByteChannel)this.newChannelProxy(WritableByteChannel.class, blob.writer(new Storage.BlobWriteOption[0]));
    }

    public <T extends Channel> T newChannelProxy(Class<T> intf, T channel) {
        ChannelInvocationHandler invocHandler = (ChannelInvocationHandler)this.invocHandlerProvider.get();
        invocHandler.setChannel(channel);
        return (T)((Channel)Proxy.newProxyInstance(channel.getClass().getClassLoader(), new Class[]{intf, Channel.class}, (InvocationHandler)invocHandler));
    }
}

