/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.googlecloud.storage.impl;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.webpieces.googlecloud.storage.api.CopyInterface;
import org.webpieces.googlecloud.storage.api.GCPBlob;
import org.webpieces.googlecloud.storage.api.GCPRawStorage;
import org.webpieces.googlecloud.storage.api.GCPStorage;
import org.webpieces.googlecloud.storage.impl.ChannelWrapper;
import org.webpieces.util.context.ClientAssertions;

@Singleton
public class GCPStorageImpl
implements GCPStorage {
    private GCPRawStorage rawStorage;
    private ClientAssertions clientAssertions;
    private ChannelWrapper channelWrapper;

    @Inject
    public GCPStorageImpl(GCPRawStorage rawStorage, ClientAssertions clientAssertions, ChannelWrapper channelWrapper) {
        this.rawStorage = rawStorage;
        this.clientAssertions = clientAssertions;
        this.channelWrapper = channelWrapper;
    }

    @Override
    public Bucket get(String bucket, Storage.BucketGetOption ... options) {
        this.clientAssertions.throwIfCannotGoRemote();
        return this.rawStorage.get(bucket, options);
    }

    @Override
    public GCPBlob get(String bucket, String blob, Storage.BlobGetOption ... options) {
        this.clientAssertions.throwIfCannotGoRemote();
        return this.rawStorage.get(bucket, blob, options);
    }

    @Override
    public Page<GCPBlob> list(String bucket, Storage.BlobListOption ... options) {
        this.clientAssertions.throwIfCannotGoRemote();
        return this.rawStorage.list(bucket, options);
    }

    @Override
    public boolean delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        this.clientAssertions.throwIfCannotGoRemote();
        return this.rawStorage.delete(bucket, blob, options);
    }

    @Override
    public byte[] readAllBytes(String bucket, String blob, Storage.BlobSourceOption ... options) {
        this.clientAssertions.throwIfCannotGoRemote();
        return this.rawStorage.readAllBytes(bucket, blob, options);
    }

    @Override
    public ReadableByteChannel reader(String bucket, String blob, Storage.BlobSourceOption ... options) {
        this.clientAssertions.throwIfCannotGoRemote();
        return this.channelWrapper.newChannelProxy(ReadableByteChannel.class, this.rawStorage.reader(bucket, blob, options));
    }

    @Override
    public WritableByteChannel writer(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        this.clientAssertions.throwIfCannotGoRemote();
        return this.channelWrapper.newChannelProxy(WritableByteChannel.class, this.rawStorage.writer(blobInfo, options));
    }

    @Override
    public CopyInterface copy(Storage.CopyRequest copyRequest) {
        this.clientAssertions.throwIfCannotGoRemote();
        return this.rawStorage.copy(copyRequest);
    }
}

