/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.googlecloud.logging;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;

public class GCPComputeEngineStackTrace {
    public String translate(IThrowableProxy proxy) {
        StringBuilder bld = new StringBuilder();
        this.recursiveAppend(bld, "", 1, proxy);
        return bld.toString();
    }

    private void recursiveAppend(StringBuilder sb, String prefix, int indent, IThrowableProxy tp) {
        if (tp == null) {
            return;
        }
        this.subjoinFirstLine(sb, prefix, indent, tp);
        sb.append(CoreConstants.LINE_SEPARATOR);
        this.subjoinSTEPArray(sb, indent, tp);
        IThrowableProxy[] suppressed = tp.getSuppressed();
        if (suppressed != null) {
            for (IThrowableProxy current : suppressed) {
                this.recursiveAppend(sb, "Suppressed: ", indent + 1, current);
            }
        }
        this.recursiveAppend(sb, "Caused by: ", indent, tp.getCause());
    }

    private void subjoinFirstLine(StringBuilder buf, String prefix, int indent, IThrowableProxy tp) {
        ThrowableProxyUtil.indent((StringBuilder)buf, (int)(indent - 1));
        if (prefix != null) {
            buf.append(prefix);
        }
        this.subjoinExceptionMessage(buf, tp);
    }

    private void subjoinExceptionMessage(StringBuilder buf, IThrowableProxy tp) {
        buf.append(tp.getClassName()).append(": ").append(tp.getMessage());
    }

    protected void subjoinSTEPArray(StringBuilder buf, int indent, IThrowableProxy tp) {
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        int commonFrames = tp.getCommonFrames();
        int maxIndex = stepArray.length;
        if (commonFrames > 0) {
            maxIndex -= commonFrames;
        }
        int ignoredCount = 0;
        for (int i = 0; i < maxIndex; ++i) {
            StackTraceElementProxy element = stepArray[i];
            ThrowableProxyUtil.indent((StringBuilder)buf, (int)indent);
            this.printStackLine(buf, ignoredCount, element);
            ignoredCount = 0;
            buf.append(CoreConstants.LINE_SEPARATOR);
        }
        if (ignoredCount > 0) {
            this.printIgnoredCount(buf, ignoredCount);
            buf.append(CoreConstants.LINE_SEPARATOR);
        }
        if (commonFrames > 0) {
            ThrowableProxyUtil.indent((StringBuilder)buf, (int)indent);
            buf.append("... ").append(tp.getCommonFrames()).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    private void printStackLine(StringBuilder buf, int ignoredCount, StackTraceElementProxy element) {
        buf.append(element);
        if (ignoredCount > 0) {
            this.printIgnoredCount(buf, ignoredCount);
        }
    }

    private void printIgnoredCount(StringBuilder buf, int ignoredCount) {
        buf.append(" [").append(ignoredCount).append(" skipped]");
    }
}

