/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.googlecloud.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.logback.LoggingEventEnhancer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.MDC;

public class GCPCloudLoggingEnhancer
implements LoggingEventEnhancer {
    private static String version;
    private static String instanceId;

    public static void setVersion(String ver) {
        version = ver;
    }

    public static void setInstanceId(String instId) {
        instanceId = instId;
    }

    public void enhanceLogEntry(LogEntry.Builder builder, ILoggingEvent logEvent) {
        boolean hasException = logEvent.getThrowableProxy() != null;
        String threadName = logEvent.getThreadName();
        HashMap<String, Object> labels = new HashMap<String, Object>();
        labels.put("hasException", "" + hasException);
        labels.put("thread", threadName);
        labels.put("version", version);
        labels.put("instanceId", instanceId);
        for (Map.Entry entry : MDC.getCopyOfContextMap().entrySet()) {
            labels.put((String)entry.getKey(), (String)entry.getValue());
        }
        builder.setLabels(labels);
    }
}

