package org.webpieces.googlecloud.logging;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;

public class GCPComputeEngineStackTrace {
        public String translate(IThrowableProxy proxy) {
            StringBuilder bld = new StringBuilder();
            recursiveAppend(bld, "", 1, proxy);
            return bld.toString();
        }
        private void recursiveAppend(StringBuilder sb, String prefix, int indent, IThrowableProxy tp) {
            if (tp == null)
                return;
            subjoinFirstLine(sb, prefix, indent, tp);
            sb.append(CoreConstants.LINE_SEPARATOR);
            subjoinSTEPArray(sb, indent, tp);
            IThrowableProxy[] suppressed = tp.getSuppressed();
            if (suppressed != null) {
                for (IThrowableProxy current : suppressed) {
                    recursiveAppend(sb, CoreConstants.SUPPRESSED, indent + ThrowableProxyUtil.SUPPRESSED_EXCEPTION_INDENT, current);
                }
            }
            recursiveAppend(sb, CoreConstants.CAUSED_BY, indent, tp.getCause());
        }
        private void subjoinFirstLine(StringBuilder buf, String prefix, int indent, IThrowableProxy tp) {
            ThrowableProxyUtil.indent(buf, indent - 1);
            if (prefix != null) {
                buf.append(prefix);
            }
            subjoinExceptionMessage(buf, tp);
        }
        private void subjoinExceptionMessage(StringBuilder buf, IThrowableProxy tp) {
            buf.append(tp.getClassName()).append(": ").append(tp.getMessage());
        }
        protected void subjoinSTEPArray(StringBuilder buf, int indent, IThrowableProxy tp) {
            StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
            int commonFrames = tp.getCommonFrames();
            //boolean unrestrictedPrinting = true;
            int maxIndex = stepArray.length;
            if (commonFrames > 0) {
                maxIndex -= commonFrames;
            }
            int ignoredCount = 0;
            for (int i = 0; i < maxIndex; i++) {
                StackTraceElementProxy element = stepArray[i];
                //if (!isIgnoredStackTraceLine(element.toString())) {
                ThrowableProxyUtil.indent(buf, indent);
                printStackLine(buf, ignoredCount, element);
                ignoredCount = 0;
                buf.append(CoreConstants.LINE_SEPARATOR);
//            } else {
//                ++ignoredCount;
//                if (maxIndex < stepArray.length) {
//                    ++maxIndex;
//                }
//            }
            }
            if (ignoredCount > 0) {
                printIgnoredCount(buf, ignoredCount);
                buf.append(CoreConstants.LINE_SEPARATOR);
            }
            if (commonFrames > 0) {
                ThrowableProxyUtil.indent(buf, indent);
                buf.append("... ").append(tp.getCommonFrames()).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
            }
        }
        private void printStackLine(StringBuilder buf, int ignoredCount, StackTraceElementProxy element) {
            buf.append(element);
            if (ignoredCount > 0) {
                printIgnoredCount(buf, ignoredCount);
            }
        }
        private void printIgnoredCount(StringBuilder buf, int ignoredCount) {
            buf.append(" [").append(ignoredCount).append(" skipped]");
        }
//    private boolean isIgnoredStackTraceLine(String line) {
//        if (ignoredStackTraceLines != null) {
//            for (String ignoredStackTraceLine : ignoredStackTraceLines) {
//                if (line.contains(ignoredStackTraceLine)) {
//                    return true;
//                }
//            }
//        }
//        return false;
//    }
}
