/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.googlecloud.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.MDC;
import org.webpieces.googlecloud.logging.GCPCloudLoggingTimestamp;
import org.webpieces.googlecloud.logging.LogEvent;
import org.webpieces.googlecloud.logging.SingletonHeaderList;
import org.webpieces.util.context.PlatformHeaders;

public class GCPCloudLoggingJSONLayout
extends PatternLayout {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Pattern REGEX_SSN = Pattern.compile("\\b[0-9]{9}\\b");
    private static final Pattern REGEX_SSN2 = Pattern.compile("\\b([0-9]{3})-([0-9]{2})-([0-9]{4})\\b");
    private static String version;
    private static String instanceId;
    private final SingletonHeaderList headerList = SingletonHeaderList.getSingleton();

    public static void setVersion(String ver) {
        version = ver;
    }

    public static void setInstanceId(String instId) {
        instanceId = instId;
    }

    public String doLayout(ILoggingEvent event) {
        try {
            String formattedMessage = super.doLayout(event);
            return this.doLayoutImpl(formattedMessage, event);
        }
        catch (Throwable e) {
            return "Failed to write value as string. " + e.getMessage();
        }
    }

    private String doLayoutImpl(String formattedMessage, ILoggingEvent logEvent) throws JsonProcessingException {
        boolean hasException = logEvent.getThrowableProxy() != null;
        long timestampMillis = logEvent.getTimeStamp();
        String severity = GCPCloudLoggingJSONLayout.mapLevelToGCPLevel(logEvent.getLevel());
        String threadName = logEvent.getThreadName();
        String loggerName = logEvent.getLoggerName();
        LogEvent event = this.buildLoggingEvent(formattedMessage, hasException, timestampMillis, severity, threadName, loggerName);
        return objectMapper.writeValueAsString((Object)event) + "\n";
    }

    public LogEvent buildLoggingEvent(String message, boolean hasException, long timestampMillis, String severity, String threadName, String loggerName) {
        LogEvent event = new LogEvent();
        String socket = MDC.get((String)"svrSocket");
        String clntSocket = MDC.get((String)"clntSocket");
        String transactionId = MDC.get((String)"txId");
        event.setMessage(message.trim());
        event.setHasException(hasException);
        event.setTimestampMillis(timestampMillis);
        event.setTimestamp(GCPCloudLoggingJSONLayout.convertTimestampToGCPLogTimestamp(timestampMillis));
        event.setSeverity(severity);
        event.setThread(threadName);
        event.setLogger(loggerName);
        event.setSocket(socket);
        event.setClientSocket(clntSocket);
        event.setTransactionId(transactionId);
        event.setVersion(version);
        event.setInstanceId(instanceId);
        List<PlatformHeaders> platformHeaders = this.headerList.listHeaderCtxPairs();
        for (PlatformHeaders header : platformHeaders) {
            String key = header.getLoggerMDCKey();
            String value = MDC.get((String)key);
            if (value == null) continue;
            event.getHeaders().put(key, value);
        }
        return event;
    }

    private static GCPCloudLoggingTimestamp convertTimestampToGCPLogTimestamp(long millisSinceEpoch) {
        int nanos = (int)(millisSinceEpoch % 1000L) * 1000000;
        long seconds = millisSinceEpoch / 1000L;
        return new GCPCloudLoggingTimestamp(seconds, nanos);
    }

    private static String mapLevelToGCPLevel(Level level) {
        switch (level.toInt()) {
            case 5000: {
                return "TRACE";
            }
            case 10000: {
                return "DEBUG";
            }
            case 20000: {
                return "INFO";
            }
            case 30000: {
                return "WARN";
            }
            case 40000: {
                return "ERROR";
            }
        }
        return null;
    }

    public Map<String, String> getDefaultConverterMap() {
        return PatternLayout.defaultConverterMap;
    }
}

