/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpclient.impl;

import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.httpclient.api.CloseListener;
import org.webpieces.httpclient.api.HttpClient;
import org.webpieces.httpclient.api.HttpSocket;
import org.webpieces.httpclient.api.ResponseListener;
import org.webpieces.httpclient.impl.HttpSocketImpl;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.httpparser.api.dto.HttpResponse;
import org.webpieces.nio.api.ChannelManager;

public class HttpClientImpl
implements HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClientImpl.class);
    private ChannelManager mgr;
    private HttpParser parser;

    public HttpClientImpl(ChannelManager mgr, HttpParser parser) {
        this.mgr = mgr;
        this.parser = parser;
    }

    @Override
    public CompletableFuture<HttpResponse> sendSingleRequest(InetSocketAddress addr, HttpRequest request) {
        HttpSocket socket = this.openHttpSocket(addr + "");
        CompletableFuture<HttpSocket> connect = socket.connect(addr);
        return connect.thenCompose(p -> socket.send(request));
    }

    @Override
    public void sendSingleRequest(InetSocketAddress addr, HttpRequest request, ResponseListener listener) {
        HttpSocket socket = this.openHttpSocket(addr + "");
        CompletableFuture<HttpSocket> connect = socket.connect(addr);
        ((CompletableFuture)connect.thenAccept(p -> socket.send(request, listener))).exceptionally(e -> this.fail(socket, listener, (Throwable)e));
    }

    private Void fail(HttpSocket socket, ResponseListener listener, Throwable e) {
        CompletableFuture<HttpSocket> closeSocket = socket.closeSocket();
        closeSocket.exceptionally(ee -> {
            log.error("could not close socket due to exception");
            return socket;
        });
        listener.failure(e);
        return null;
    }

    @Override
    public HttpSocket openHttpSocket(String idForLogging) {
        return this.openHttpSocket(idForLogging, null);
    }

    @Override
    public HttpSocket openHttpSocket(String idForLogging, CloseListener listener) {
        return new HttpSocketImpl(this.mgr, idForLogging, null, this.parser, listener);
    }
}

