/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templating.impl.tags;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.webpieces.ctx.api.Current;
import org.webpieces.ctx.api.Flash;
import org.webpieces.ctx.api.Validation;
import org.webpieces.templating.api.ClosureUtil;
import org.webpieces.templating.api.HtmlTag;
import org.webpieces.templating.impl.GroovyTemplateSuperclass;
import org.webpieces.templating.impl.tags.TemplateLoaderTag;

public class FieldTag
extends TemplateLoaderTag
implements HtmlTag {
    private Pattern pattern = Pattern.compile("\\[(.*?)\\]");
    private String fieldHtmlPath;
    private String errorClass;

    public FieldTag(String fieldHtmlPath, String errorClass) {
        this.fieldHtmlPath = fieldHtmlPath;
        this.errorClass = errorClass;
    }

    @Override
    public String getName() {
        return "field";
    }

    @Override
    protected String getFilePath(GroovyTemplateSuperclass callingTemplate, Map<Object, Object> args, String srcLocation) {
        return this.fieldHtmlPath;
    }

    @Override
    protected Map<String, Object> convertTagArgs(Map<Object, Object> tagArgs, Map<String, Object> pageArgs, Closure<?> body, String srcLocation) {
        if (tagArgs.get("_body") != null) {
            throw new IllegalArgumentException("tag " + this.getName() + " must not define an argument of '_body' as that is reserved and will be overwritten" + srcLocation);
        }
        if (tagArgs.get("field") != null) {
            throw new IllegalArgumentException("tag " + this.getName() + " must not define an argument of 'field' as that is reserved and will be overwritten " + srcLocation);
        }
        String fieldName = tagArgs.get("defaultArgument").toString();
        Map<String, Object> field = this.createFieldData(fieldName, pageArgs);
        HashMap<String, Object> copyOfTagArgs = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : tagArgs.entrySet()) {
            String key = entry.getKey().toString();
            copyOfTagArgs.put(key, entry.getValue());
            body.setProperty(key, entry.getValue());
        }
        copyOfTagArgs.put("field", field);
        String bodyStr = "";
        if (body != null) {
            body.setProperty("field", field);
            bodyStr = ClosureUtil.toString(body);
        }
        copyOfTagArgs.put("_body", bodyStr);
        return copyOfTagArgs;
    }

    private Map<String, Object> createFieldData(String fieldName2, Map<String, Object> pageArgs) {
        Result result = this.reworkNameForArrayOnly(fieldName2, pageArgs);
        String fieldName = result.fieldName;
        Flash flash = Current.flash();
        Validation validation = Current.validation();
        HashMap<String, Object> field = new HashMap<String, Object>();
        field.put("name", fieldName);
        String id = this.makeValidHtml4Id(fieldName);
        field.put("id", id);
        String flashValue = flash.get(fieldName);
        field.put("i18nKey", result.i18nName);
        field.put("flash", flashValue);
        field.put("error", validation.getError(fieldName));
        field.put("errorClass", field.get("error") != null ? this.errorClass : "");
        String[] pieces = fieldName.split("\\.");
        Object pageArgValue = null;
        Object obj = pageArgs.get(pieces[0]);
        if (pieces.length > 1) {
            try {
                String path = fieldName.substring(fieldName.indexOf(".") + 1);
                pageArgValue = PropertyUtils.getProperty((Object)obj, (String)path);
            }
            catch (Exception exception) {}
        } else {
            pageArgValue = obj;
        }
        field.put("value", pageArgValue);
        field.put("flashOrValue", this.preferFirst(flashValue, pageArgValue));
        field.put("valueOrFlash", this.preferFirst(pageArgValue, flashValue));
        return field;
    }

    protected Result reworkNameForArrayOnly(String fieldName, Map<String, Object> pageArgs) {
        if (!fieldName.contains("[")) {
            return new Result(fieldName, fieldName);
        }
        String i18nName = fieldName;
        Matcher m = this.pattern.matcher(fieldName);
        while (m.find()) {
            String indexName = m.group(1);
            Object index = pageArgs.get(indexName);
            fieldName = fieldName.replace(indexName, index + "");
            i18nName = i18nName.replace("[" + indexName + "]", "");
        }
        return new Result(fieldName, i18nName);
    }

    private String makeValidHtml4Id(String fieldName) {
        return fieldName.replace('.', '_').replace("[", ":").replace("]", ":");
    }

    private Object preferFirst(Object first, Object last) {
        if (first != null) {
            return first;
        }
        return last;
    }

    private static class Result {
        public String fieldName;
        public String i18nName;

        public Result(String fieldName, String i18nName) {
            this.fieldName = fieldName;
            this.i18nName = i18nName;
        }
    }
}

