/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templating.impl.tags;

import groovy.lang.Binding;
import groovy.lang.Closure;
import java.io.PrintWriter;
import java.util.Map;
import org.webpieces.templating.api.HtmlTag;
import org.webpieces.templating.api.TemplateService;
import org.webpieces.templating.api.TemplateUtil;
import org.webpieces.templating.impl.GroovyTemplateSuperclass;

public abstract class TemplateLoaderTag
implements HtmlTag {
    protected TemplateService svc;

    @Override
    public void runTag(Map<Object, Object> tagArgs, Closure<?> body, PrintWriter out, GroovyTemplateSuperclass parentTemplate, String srcLocation) {
        Binding binding = parentTemplate.getBinding();
        Map pageArgs = binding.getVariables();
        Map<String, Object> customTagArgs = this.convertTagArgs(tagArgs, pageArgs, body, srcLocation);
        String filePath = this.getFilePath(parentTemplate, tagArgs, srcLocation);
        Map<Object, Object> setTagProps = parentTemplate.getSetTagProperties();
        String s = this.svc.loadAndRunTemplate(filePath, customTagArgs, setTagProps);
        out.print(s);
    }

    protected abstract Map<String, Object> convertTagArgs(Map<Object, Object> var1, Map<String, Object> var2, Closure<?> var3, String var4);

    protected String getFilePath(GroovyTemplateSuperclass callingTemplate, Map<Object, Object> args, String srcLocation) {
        Object name = args.get("defaultArgument");
        if (name == null) {
            throw new IllegalArgumentException("#{" + this.getName() + "/}# tag must contain a template name like #{" + this.getName() + " '../template.html'/}#. " + srcLocation);
        }
        String path = TemplateUtil.translateToProperFilePath(callingTemplate, name.toString());
        return path;
    }

    public void initialize(TemplateService svc) {
        this.svc = svc;
    }
}

