/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpclient.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.httpclient.api.CloseListener;
import org.webpieces.httpclient.api.HttpChunkWriter;
import org.webpieces.httpclient.api.HttpClientSocket;
import org.webpieces.httpclient.api.HttpsSslEngineFactory;
import org.webpieces.httpclient.api.ResponseListener;
import org.webpieces.httpclient.impl.CatchResponseListener;
import org.webpieces.httpclient.impl.CompletableListener;
import org.webpieces.httpclient.impl.HttpChunkWriterImpl;
import org.webpieces.httpclient.impl.PendingRequest;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.Memento;
import org.webpieces.httpparser.api.dto.HttpChunk;
import org.webpieces.httpparser.api.dto.HttpPayload;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.httpparser.api.dto.HttpResponse;
import org.webpieces.nio.api.ChannelManager;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.nio.api.exceptions.NioClosedChannelException;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.nio.api.handlers.RecordingDataListener;

public class HttpSocketImpl
implements HttpClientSocket,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(HttpSocketImpl.class);
    private static DataWrapperGenerator wrapperGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private TCPChannel channel;
    private CompletableFuture<HttpClientSocket> connectFuture;
    private boolean isClosed;
    private boolean connected;
    private ConcurrentLinkedQueue<PendingRequest> pendingRequests = new ConcurrentLinkedQueue();
    private HttpParser parser;
    private Memento memento;
    private ConcurrentLinkedQueue<ResponseListener> responsesToComplete = new ConcurrentLinkedQueue();
    private DataListener dataListener = new MyDataListener();
    private CloseListener closeListener;
    private HttpsSslEngineFactory factory;
    private ChannelManager mgr;
    private String idForLogging;
    private boolean isRecording = false;

    public HttpSocketImpl(ChannelManager mgr, String idForLogging, HttpsSslEngineFactory factory, HttpParser parser2, CloseListener listener) {
        this.factory = factory;
        this.mgr = mgr;
        this.idForLogging = idForLogging;
        this.parser = parser2;
        this.memento = this.parser.prepareToParse();
        this.closeListener = listener;
    }

    @Override
    public CompletableFuture<HttpClientSocket> connect(InetSocketAddress addr) {
        if (this.factory == null) {
            this.channel = this.mgr.createTCPChannel(this.idForLogging);
        } else {
            SSLEngine engine = this.factory.createSslEngine(addr.getHostName(), addr.getPort());
            this.channel = this.mgr.createTCPChannel(this.idForLogging, engine);
        }
        if (this.isRecording) {
            this.dataListener = new RecordingDataListener("httpSock-", this.dataListener);
        }
        this.connectFuture = this.channel.connect((SocketAddress)addr, this.dataListener).thenApply(channel -> this.connected());
        return this.connectFuture;
    }

    @Override
    public CompletableFuture<HttpResponse> send(HttpRequest request) {
        CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        CompletableListener l = new CompletableListener(future);
        this.send(request, l);
        return future;
    }

    private synchronized HttpClientSocket connected() {
        this.connected = true;
        while (!this.pendingRequests.isEmpty()) {
            PendingRequest req = (PendingRequest)this.pendingRequests.remove();
            this.actuallySendRequest(req.getFuture(), req.getRequest(), req.getListener());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<HttpChunkWriter> send(HttpRequest request, ResponseListener listener) {
        if (this.connectFuture == null) {
            throw new IllegalArgumentException("You must at least call httpSocket.connect first(it doesn't have to complete...you just have to call it before caling send)");
        }
        CompletableFuture<HttpChunkWriter> future = new CompletableFuture<HttpChunkWriter>();
        boolean wasConnected = false;
        HttpSocketImpl httpSocketImpl = this;
        synchronized (httpSocketImpl) {
            if (!this.connected) {
                this.pendingRequests.add(new PendingRequest(future, request, listener));
            } else {
                wasConnected = true;
            }
        }
        if (wasConnected) {
            this.actuallySendRequest(future, request, listener);
        }
        return future;
    }

    private void actuallySendRequest(CompletableFuture<HttpChunkWriter> future, HttpRequest request, ResponseListener listener) {
        CatchResponseListener l = new CatchResponseListener(listener);
        ByteBuffer wrap = this.parser.marshalToByteBuffer((HttpPayload)request);
        this.responsesToComplete.offer(l);
        log.info("sending request now. req=" + request.getRequestLine().getUri());
        CompletableFuture write = this.channel.write(wrap);
        write.handle((c, t) -> this.chainToFuture((Channel)c, (Throwable)t, future));
    }

    private Void chainToFuture(Channel c, Throwable t, CompletableFuture<HttpChunkWriter> future) {
        if (t != null) {
            future.completeExceptionally(new RuntimeException(t));
            return null;
        }
        HttpChunkWriterImpl impl = new HttpChunkWriterImpl(this.channel, this.parser);
        future.complete(impl);
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        CompletableFuture<HttpClientSocket> future = this.closeSocket();
        future.exceptionally(e -> {
            log.info("close failed", e);
            return this;
        });
    }

    @Override
    public CompletableFuture<HttpClientSocket> closeSocket() {
        if (this.isClosed) {
            return CompletableFuture.completedFuture(this);
        }
        this.cleanUpPendings("You closed the socket");
        CompletableFuture future = this.channel.close();
        return future.thenApply(chan -> {
            this.isClosed = true;
            return this;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpPendings(String msg) {
        while (!this.responsesToComplete.isEmpty()) {
            ResponseListener listener = this.responsesToComplete.poll();
            if (listener == null) continue;
            listener.failure((Throwable)new NioClosedChannelException(msg + " before responses were received"));
        }
        HttpSocketImpl httpSocketImpl = this;
        synchronized (httpSocketImpl) {
            while (!this.pendingRequests.isEmpty()) {
                PendingRequest pending = this.pendingRequests.poll();
                pending.getListener().failure((Throwable)new NioClosedChannelException(msg + " before requests were sent"));
            }
        }
    }

    private class MyDataListener
    implements DataListener {
        private boolean processingChunked = false;

        private MyDataListener() {
        }

        public void incomingData(Channel channel, ByteBuffer b) {
            log.info("size=" + b.remaining());
            DataWrapper wrapper = wrapperGen.wrapByteBuffer(b);
            HttpSocketImpl.this.memento = HttpSocketImpl.this.parser.parse(HttpSocketImpl.this.memento, wrapper);
            List parsedMessages = HttpSocketImpl.this.memento.getParsedMessages();
            for (HttpPayload msg : parsedMessages) {
                HttpResponse resp;
                ResponseListener listener;
                if (this.processingChunked) {
                    HttpChunk chunk = (HttpChunk)msg;
                    listener = (ResponseListener)HttpSocketImpl.this.responsesToComplete.peek();
                    if (chunk.isLastChunk()) {
                        this.processingChunked = false;
                        HttpSocketImpl.this.responsesToComplete.poll();
                    }
                    listener.incomingChunk(chunk, chunk.isLastChunk());
                    continue;
                }
                if (!msg.isHasChunkedTransferHeader()) {
                    resp = (HttpResponse)msg;
                    listener = (ResponseListener)HttpSocketImpl.this.responsesToComplete.poll();
                    listener.incomingResponse(resp, true);
                    continue;
                }
                this.processingChunked = true;
                resp = (HttpResponse)msg;
                listener = (ResponseListener)HttpSocketImpl.this.responsesToComplete.peek();
                listener.incomingResponse(resp, false);
            }
        }

        public void farEndClosed(Channel channel) {
            log.info("far end closed");
            HttpSocketImpl.this.isClosed = true;
            HttpSocketImpl.this.cleanUpPendings("Remote end closed");
            if (HttpSocketImpl.this.closeListener != null) {
                HttpSocketImpl.this.closeListener.farEndClosed(HttpSocketImpl.this);
            }
        }

        public void failure(Channel channel, ByteBuffer data, Exception e) {
            log.error("Failure on channel=" + channel, (Throwable)e);
            while (!HttpSocketImpl.this.responsesToComplete.isEmpty()) {
                ResponseListener listener = (ResponseListener)HttpSocketImpl.this.responsesToComplete.poll();
                if (listener == null) continue;
                listener.failure(e);
            }
        }

        public void applyBackPressure(Channel channel) {
        }

        public void releaseBackPressure(Channel channel) {
        }
    }
}

