/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpclient.api;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.webpieces.data.api.BufferCreationPool;
import org.webpieces.data.api.BufferPool;
import org.webpieces.httpclient.api.HttpClient;
import org.webpieces.httpclient.impl.HttpClientImpl;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.HttpParserFactory;
import org.webpieces.nio.api.ChannelManager;
import org.webpieces.nio.api.ChannelManagerFactory;
import org.webpieces.util.threading.NamedThreadFactory;

public abstract class HttpClientFactory {
    public static HttpClient createHttpClient(int numThreads) {
        ExecutorService executor = Executors.newFixedThreadPool(numThreads, (ThreadFactory)new NamedThreadFactory("httpclient"));
        BufferCreationPool pool = new BufferCreationPool();
        HttpParser parser = HttpParserFactory.createParser((BufferPool)pool);
        ChannelManagerFactory factory = ChannelManagerFactory.createFactory();
        ChannelManager mgr = factory.createMultiThreadedChanMgr("httpClientChanMgr", (BufferPool)pool, (Executor)executor);
        return HttpClientFactory.createHttpClient(mgr, parser);
    }

    public static HttpClient createHttpClient(ChannelManager mgr, HttpParser parser) {
        return new HttpClientImpl(mgr, parser);
    }
}

