/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpclient.impl;

import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.httpclient.api.DataWriter;
import org.webpieces.httpclient.api.HttpFullResponse;
import org.webpieces.httpclient.api.HttpResponseListener;
import org.webpieces.httpparser.api.dto.HttpData;
import org.webpieces.httpparser.api.dto.HttpResponse;

public class CompletableListener
implements HttpResponseListener {
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private CompletableFuture<HttpFullResponse> future;
    private HttpFullResponse response;

    public CompletableListener(CompletableFuture<HttpFullResponse> future) {
        this.future = future;
    }

    @Override
    public CompletableFuture<DataWriter> incomingResponse(HttpResponse resp, boolean isComplete) {
        HttpFullResponse resp1 = new HttpFullResponse(resp, dataGen.emptyWrapper());
        if (isComplete) {
            this.future.complete(resp1);
            return CompletableFuture.completedFuture(new NullWriter());
        }
        this.response = resp1;
        return CompletableFuture.completedFuture(new DataWriterImpl());
    }

    @Override
    public void failure(Throwable e) {
        this.future.completeExceptionally(e);
    }

    private class DataWriterImpl
    implements DataWriter {
        private DataWriterImpl() {
        }

        @Override
        public CompletableFuture<Void> incomingData(HttpData chunk) {
            DataWrapper allData = dataGen.chainDataWrappers(CompletableListener.this.response.getData(), chunk.getBodyNonNull());
            CompletableListener.this.response.setData(allData);
            if (chunk.isEndOfData()) {
                CompletableListener.this.future.complete(CompletableListener.this.response);
                CompletableListener.this.response = null;
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    private class NullWriter
    implements DataWriter {
        private NullWriter() {
        }

        @Override
        public CompletableFuture<Void> incomingData(HttpData data) {
            throw new UnsupportedOperationException("This should not happen");
        }
    }
}

