/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpclient11.impl;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.httpclient11.api.HttpDataWriter;
import org.webpieces.httpclient11.impl.ChannelProxy;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.MarshalState;
import org.webpieces.httpparser.api.dto.HttpData;
import org.webpieces.httpparser.api.dto.HttpPayload;

public class HttpChunkWriterImpl
implements HttpDataWriter {
    private ChannelProxy channel;
    private HttpParser parser;
    private MarshalState state;
    private boolean isConnectMsg;
    private boolean canSendChunks;

    public HttpChunkWriterImpl(ChannelProxy channel, HttpParser parser, MarshalState state, boolean isConnectMsg, boolean canSendChunks) {
        this.channel = channel;
        this.parser = parser;
        this.state = state;
        this.isConnectMsg = isConnectMsg;
        this.canSendChunks = canSendChunks;
    }

    @Override
    public CompletableFuture<Void> send(HttpData chunk) {
        if (this.isConnectMsg) {
            DataWrapper body = chunk.getBody();
            byte[] createByteArray = body.createByteArray();
            ByteBuffer buffer = ByteBuffer.wrap(createByteArray);
            return this.channel.write(buffer);
        }
        ByteBuffer buffer = this.parser.marshalToByteBuffer(this.state, (HttpPayload)chunk);
        return this.channel.write(buffer);
    }
}

