/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpclient11.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.webpieces.httpclient11.api.HttpDataWriter;
import org.webpieces.httpclient11.api.HttpResponseListener;
import org.webpieces.httpparser.api.dto.HttpData;
import org.webpieces.httpparser.api.dto.HttpResponse;

public class CatchResponseListener
implements HttpResponseListener {
    private static final Logger log = LoggerFactory.getLogger(CatchResponseListener.class);
    private HttpResponseListener listener;
    private String svrSocket;

    public CatchResponseListener(HttpResponseListener listener, String svrSocket) {
        this.listener = listener;
        this.svrSocket = svrSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<HttpDataWriter> incomingResponse(HttpResponse resp, boolean isComplete) {
        try {
            MDC.put((String)"svrSocket", (String)this.svrSocket);
            CompletionStage completionStage = this.listener.incomingResponse(resp, isComplete).thenApply(w -> new CatchDataWriter((HttpDataWriter)w, this.svrSocket));
            return completionStage;
        }
        catch (Throwable e) {
            log.error("exception", e);
            CompletableFuture<HttpDataWriter> future = new CompletableFuture<HttpDataWriter>();
            future.completeExceptionally(e);
            CompletableFuture<HttpDataWriter> completableFuture = future;
            return completableFuture;
        }
        finally {
            MDC.put((String)"svrSocket", null);
        }
    }

    @Override
    public void failure(Throwable e) {
        try {
            MDC.put((String)"svrSocket", (String)this.svrSocket);
            this.listener.failure(e);
        }
        catch (Throwable ee) {
            log.error("exception", ee);
        }
        finally {
            MDC.put((String)"svrSocket", null);
        }
    }

    private class CatchDataWriter
    implements HttpDataWriter {
        private HttpDataWriter writer;
        private String svrSocket2;

        public CatchDataWriter(HttpDataWriter writer, String svrSocket) {
            this.writer = writer;
            this.svrSocket2 = svrSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompletableFuture<Void> send(HttpData chunk) {
            try {
                MDC.put((String)"svrSocket", (String)this.svrSocket2);
                CompletableFuture<Void> completableFuture = this.writer.send(chunk);
                return completableFuture;
            }
            catch (Throwable e) {
                log.error("exception", e);
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                future.completeExceptionally(e);
                CompletableFuture<Void> completableFuture = future;
                return completableFuture;
            }
            finally {
                MDC.put((String)"svrSocket", null);
            }
        }
    }
}

