/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpclient11.impl;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.httpclient11.api.HttpDataWriter;
import org.webpieces.httpclient11.api.HttpFullRequest;
import org.webpieces.httpclient11.api.HttpFullResponse;
import org.webpieces.httpclient11.api.HttpResponseListener;
import org.webpieces.httpclient11.api.HttpSocket;
import org.webpieces.httpclient11.api.HttpSocketListener;
import org.webpieces.httpclient11.api.HttpStreamRef;
import org.webpieces.httpclient11.api.SocketClosedException;
import org.webpieces.httpclient11.impl.CatchResponseListener;
import org.webpieces.httpclient11.impl.ChannelProxy;
import org.webpieces.httpclient11.impl.CompletableListener;
import org.webpieces.httpclient11.impl.HttpChunkWriterImpl;
import org.webpieces.httpclient11.impl.ProxyClose;
import org.webpieces.httpclient11.impl.ResponseSession;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.MarshalState;
import org.webpieces.httpparser.api.Memento;
import org.webpieces.httpparser.api.common.Header;
import org.webpieces.httpparser.api.common.KnownHeaderName;
import org.webpieces.httpparser.api.dto.HttpData;
import org.webpieces.httpparser.api.dto.HttpPayload;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.httpparser.api.dto.HttpResponse;
import org.webpieces.httpparser.api.dto.KnownHttpMethod;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.ChannelSession;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.nio.api.handlers.RecordingDataListener;

public class HttpSocketImpl
implements HttpSocket {
    private static final Logger log = LoggerFactory.getLogger(HttpSocketImpl.class);
    private static DataWrapperGenerator wrapperGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private final String svrSocket;
    private ChannelProxy channel;
    private boolean isClosed;
    private boolean connected;
    private HttpParser parser;
    private Memento memento;
    private ConcurrentLinkedQueue<HttpResponseListener> responsesToComplete = new ConcurrentLinkedQueue();
    private DataListener dataListener = new MyDataListener();
    private boolean isRecording = false;
    private MarshalState state;
    private boolean isConnect;
    private HttpSocketListener socketListener;
    private boolean isHttps;

    public HttpSocketImpl(ChannelProxy channel, HttpParser parser, HttpSocketListener socketListener, boolean isHttps) {
        this.isHttps = isHttps;
        if (socketListener == null || channel == null || parser == null) {
            throw new IllegalArgumentException("no args can be null");
        }
        this.svrSocket = MDC.get((String)"svrSocket");
        this.channel = channel;
        this.parser = parser;
        this.socketListener = new ProxyClose(socketListener, this.svrSocket);
        this.memento = parser.prepareToParse();
        this.state = parser.prepareToMarshal();
    }

    @Override
    public CompletableFuture<Void> connect(InetSocketAddress addr) {
        if (this.isRecording) {
            this.dataListener = new RecordingDataListener("httpSock-", this.dataListener);
        }
        return this.channel.connect(addr, this.dataListener).thenApply(channel -> this.connected());
    }

    @Override
    public CompletableFuture<HttpFullResponse> send(HttpFullRequest request) {
        Integer contentLength = request.getRequest().getContentLength();
        if (request.getData() == null || request.getData().getReadableSize() == 0) {
            if (contentLength != null && contentLength != 0) {
                throw new IllegalArgumentException("HttpRequest has 0 Content-Length but readable size=" + request.getData().getReadableSize());
            }
        } else {
            if (!request.getRequest().isHasNonZeroContentLength()) {
                throw new IllegalArgumentException("HttpRequest must have Content-Length header");
            }
            if (request.getRequest().getContentLength().intValue() != request.getData().getReadableSize()) {
                throw new IllegalArgumentException("HttpRequest Content-Length header value=" + request.getRequest().getContentLength() + " does not match payload size=" + request.getData().getReadableSize());
            }
        }
        CompletableFuture<HttpFullResponse> future = new CompletableFuture<HttpFullResponse>();
        CompletableListener l = new CompletableListener(future);
        HttpStreamRef streamRef = this.send(request.getRequest(), l);
        if (request.getData() != null && request.getData().getReadableSize() > 0) {
            HttpData data = new HttpData(request.getData(), true);
            streamRef.getWriter().thenCompose(w -> w.send(data));
        }
        future.exceptionally(t -> {
            if (t instanceof CancellationException && !this.isKeepAliveRequest(request.getRequest())) {
                streamRef.cancel("CompletableFuture cancelled by client, so cancel request");
            }
            return null;
        });
        return future;
    }

    private Void connected() {
        this.connected = true;
        return null;
    }

    @Override
    public HttpStreamRef send(HttpRequest request, HttpResponseListener listener) {
        if (!this.connected) {
            throw new IllegalStateException("The socket is not yet connected");
        }
        return this.actuallySendRequest(request, listener);
    }

    private HttpStreamRef actuallySendRequest(HttpRequest request, HttpResponseListener listener) {
        CatchResponseListener l = new CatchResponseListener(listener, this.svrSocket);
        ByteBuffer wrap = this.parser.marshalToByteBuffer(this.state, (HttpPayload)request);
        this.isConnect = false;
        if (request.getRequestLine().getMethod().getKnownStatus() == KnownHttpMethod.CONNECT) {
            this.isConnect = true;
        }
        this.responsesToComplete.offer(l);
        boolean canSendChunks = false;
        Header header = request.getHeaderLookupStruct().getHeader(KnownHeaderName.TRANSFER_ENCODING);
        if (header != null && "chunked".equals(header.getValue())) {
            canSendChunks = true;
        }
        boolean canSendTheChunks = canSendChunks;
        CompletionStage writer = this.channel.write(wrap).thenApply(v -> new HttpChunkWriterImpl(this.channel, this.parser, this.state, this.isConnect, canSendTheChunks));
        return new MyStreamRefImpl((CompletableFuture<HttpDataWriter>)writer, request);
    }

    private boolean isKeepAliveRequest(HttpRequest req) {
        Header header = req.getHeaderLookupStruct().getHeader(KnownHeaderName.CONNECTION);
        return header != null && "keep-alive".equals(header.getValue());
    }

    @Override
    public CompletableFuture<Void> close() {
        if (this.isClosed) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = this.channel.close();
        return future.thenApply(chan -> {
            this.isClosed = true;
            return null;
        });
    }

    public String toString() {
        return "HttpSocketImpl [channel=" + this.channel.getId() + "isHttps=" + this.isHttps + " tcpSecure=" + this.channel.isSecure() + "]";
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private class MyDataListener
    implements DataListener {
        private static final String FUTURE_PROCESS_KEY = "__webpiecesFutureProcessKey";
        private CompletableFuture<HttpDataWriter> dataWriterFuture;
        private boolean connectResponseReceived;

        private MyDataListener() {
        }

        public CompletableFuture<Void> incomingData(Channel channel, ByteBuffer b) {
            DataWrapper wrapper = wrapperGen.wrapByteBuffer(b);
            DataWrapper leftOverData = null;
            if (this.connectResponseReceived) {
                return this.sendDataAfterHttpConnect(wrapper);
            }
            if (HttpSocketImpl.this.isConnect) {
                this.connectResponseReceived = true;
                HttpSocketImpl.this.memento = HttpSocketImpl.this.parser.parseOnlyHeaders(HttpSocketImpl.this.memento, wrapper);
                leftOverData = HttpSocketImpl.this.memento.getLeftOverData();
            } else {
                HttpSocketImpl.this.memento = HttpSocketImpl.this.parser.parse(HttpSocketImpl.this.memento, wrapper);
            }
            if (HttpSocketImpl.this.memento.getNumBytesJustParsed() == 0) {
                return CompletableFuture.completedFuture(null);
            }
            List parsedMessages = HttpSocketImpl.this.memento.getParsedMessages();
            ChannelSession session = channel.getSession();
            ResponseSession rs = (ResponseSession)session.get((Object)FUTURE_PROCESS_KEY);
            if (rs == null) {
                rs = new ResponseSession();
                session.put((Object)FUTURE_PROCESS_KEY, (Object)rs);
            }
            CompletionStage<Void> future = rs.getProcessFuture();
            for (HttpPayload msg : parsedMessages) {
                if (msg instanceof HttpData) {
                    HttpData data = (HttpData)msg;
                    if (data.isEndOfData()) {
                        HttpSocketImpl.this.responsesToComplete.poll();
                    }
                    future = ((CompletableFuture)future.thenCompose(voidd -> this.dataWriterFuture)).thenCompose(w -> w.send(data));
                    continue;
                }
                if (msg instanceof HttpResponse) {
                    future = ((CompletableFuture)future.thenCompose(s -> this.processResponse((HttpResponse)msg))).thenApply(s -> null);
                    continue;
                }
                throw new IllegalStateException("invalid payload received=" + msg);
            }
            rs.setProcessFuture((CompletableFuture<Void>)future);
            if (this.connectResponseReceived && leftOverData.getReadableSize() > 0) {
                return this.sendDataAfterHttpConnect(leftOverData);
            }
            return future;
        }

        private CompletableFuture<Void> sendDataAfterHttpConnect(DataWrapper wrapper) {
            HttpData data = new HttpData(wrapper, false);
            return this.dataWriterFuture.thenCompose(w -> w.send(data));
        }

        private CompletableFuture<HttpDataWriter> processResponse(HttpResponse msg) {
            boolean isComplete;
            HttpResponseListener listener;
            if (msg.isHasChunkedTransferHeader() || msg.isHasNonZeroContentLength()) {
                listener = HttpSocketImpl.this.responsesToComplete.peek();
                isComplete = false;
            } else {
                isComplete = true;
                listener = HttpSocketImpl.this.responsesToComplete.poll();
            }
            HttpResponse resp = msg;
            this.dataWriterFuture = listener.incomingResponse(resp, isComplete);
            return this.dataWriterFuture;
        }

        public void farEndClosed(Channel channel) {
            HttpSocketImpl.this.isClosed = true;
            HttpSocketImpl.this.socketListener.socketClosed(HttpSocketImpl.this);
            while (!HttpSocketImpl.this.responsesToComplete.isEmpty()) {
                HttpResponseListener listener = HttpSocketImpl.this.responsesToComplete.poll();
                listener.failure(new SocketClosedException("Socket was closed by remote end"));
            }
        }

        public void failure(Channel channel, ByteBuffer data, Exception e) {
            log.error("Failure on channel=" + channel, (Throwable)e);
            while (!HttpSocketImpl.this.responsesToComplete.isEmpty()) {
                HttpResponseListener listener = HttpSocketImpl.this.responsesToComplete.poll();
                if (listener == null) continue;
                listener.failure(e);
            }
        }
    }

    private class MyStreamRefImpl
    implements HttpStreamRef {
        private CompletableFuture<HttpDataWriter> writer;
        private HttpRequest request;

        public MyStreamRefImpl(CompletableFuture<HttpDataWriter> writer, HttpRequest request) {
            this.writer = writer;
            this.request = request;
        }

        @Override
        public CompletableFuture<HttpDataWriter> getWriter() {
            return this.writer;
        }

        @Override
        public CompletableFuture<Void> cancel(Object reason) {
            if (!HttpSocketImpl.this.isKeepAliveRequest(this.request)) {
                return HttpSocketImpl.this.close();
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

