/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpclient11.api;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.TwoPools;
import org.webpieces.httpclient11.api.HttpClient;
import org.webpieces.httpclient11.impl.HttpClientImpl;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.HttpParserFactory;
import org.webpieces.metrics.MetricsCreator;
import org.webpieces.nio.api.BackpressureConfig;
import org.webpieces.nio.api.ChannelManager;
import org.webpieces.nio.api.ChannelManagerFactory;
import org.webpieces.util.threading.NamedThreadFactory;

public abstract class HttpClientFactory {
    public static HttpClient createHttpClient(String id, int numThreads, BackpressureConfig backPressureConfig, MeterRegistry metrics) {
        ExecutorService executor = Executors.newFixedThreadPool(numThreads, (ThreadFactory)new NamedThreadFactory("httpclient"));
        MetricsCreator.monitor((MeterRegistry)metrics, (Executor)executor, (String)id);
        TwoPools pool = new TwoPools(id + ".bufferpool", metrics);
        HttpParser parser = HttpParserFactory.createParser((String)id, (MeterRegistry)metrics, (BufferPool)pool);
        ChannelManagerFactory factory = ChannelManagerFactory.createFactory((MeterRegistry)metrics);
        ChannelManager mgr = factory.createMultiThreadedChanMgr("httpClientChanMgr", (BufferPool)pool, backPressureConfig, (Executor)executor);
        return HttpClientFactory.createHttpClient(id, mgr, parser);
    }

    public static HttpClient createHttpClient(String id, ChannelManager mgr, HttpParser parser) {
        return new HttpClientImpl(id, mgr, parser);
    }
}

