/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.impl;

import java.util.HashMap;
import java.util.Map;

public class ConvertAscii {
    private Map<Integer, String> lookupTable = new HashMap<Integer, String>();

    public ConvertAscii() {
        this.lookupTable.put(0, "[NUL]");
        this.lookupTable.put(1, "[SOH]");
        this.lookupTable.put(2, "[STX]");
        this.lookupTable.put(3, "[ETX]");
        this.lookupTable.put(4, "[EOT]");
        this.lookupTable.put(5, "[ENQ]");
        this.lookupTable.put(6, "[ACK]");
        this.lookupTable.put(7, "[BEL]");
        this.lookupTable.put(8, "[BS]");
        this.lookupTable.put(9, "\\t\t");
        this.lookupTable.put(10, "\\n\n");
        this.lookupTable.put(11, "\\vt    ");
        this.lookupTable.put(13, "\\r\r");
        this.lookupTable.put(32, "\\s ");
    }

    public boolean isCarriageReturn(byte byteVal) {
        int asciiInt = byteVal & 0xFF;
        return asciiInt == 13;
    }

    public boolean isLineFeed(byte byteVal) {
        int asciiInt = byteVal & 0xFF;
        return asciiInt == 10;
    }

    public String convertToReadableForm(byte[] msg) {
        return this.convertToReadableForm(msg, 0, msg.length);
    }

    public String convertToReadableForm(byte[] msg, int offset, int length) {
        int i;
        StringBuilder builder = new StringBuilder();
        int highMark = offset + length;
        for (i = offset; i < highMark - 1; ++i) {
            byte firstByte = msg[i];
            byte secondByte = msg[i + 1];
            int asciiInt = firstByte & 0xFF;
            if (asciiInt >= 33) {
                this.appendDisplayableByte(builder, firstByte);
                continue;
            }
            boolean firstIsCarriageReturn = this.isCarriageReturn(firstByte);
            boolean secondIsLineFeed = this.isLineFeed(secondByte);
            if (firstIsCarriageReturn && secondIsLineFeed) {
                builder.append("\\r\\n\r\n");
                ++i;
                continue;
            }
            this.appendInvisibleByte(builder, asciiInt);
        }
        if (i < highMark) {
            byte lastByte = msg[i];
            int unsignedByte = lastByte & 0xFF;
            if (unsignedByte >= 33) {
                this.appendDisplayableByte(builder, lastByte);
            } else {
                this.appendInvisibleByte(builder, unsignedByte);
            }
        }
        return builder.toString();
    }

    private void appendInvisibleByte(StringBuilder builder, int asciiInt) {
        String printableForm = this.lookupTable.get(asciiInt);
        if (printableForm == null) {
            throw new UnsupportedOperationException("not supported ascii yet int=" + asciiInt);
        }
        builder.append(printableForm);
    }

    private void appendDisplayableByte(StringBuilder builder, byte firstByte) {
        char c = (char)firstByte;
        builder.append(c);
    }
}

