/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.api.dto;

import java.util.ArrayList;
import java.util.List;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.httpparser.api.dto.HttpChunkExtension;
import org.webpieces.httpparser.api.dto.HttpData;
import org.webpieces.httpparser.api.dto.HttpMessageType;

public class HttpChunk
extends HttpData {
    public static final String TRAILER_STR = "\r\n";
    protected List<HttpChunkExtension> extensions = new ArrayList<HttpChunkExtension>();

    public HttpChunk() {
    }

    public HttpChunk(DataWrapper data) {
        super(data, false);
    }

    @Override
    public boolean isEndOfData() {
        return false;
    }

    @Override
    public HttpMessageType getMessageType() {
        return HttpMessageType.CHUNK;
    }

    public void addExtension(HttpChunkExtension extension) {
        this.extensions.add(extension);
    }

    public List<HttpChunkExtension> getExtensions() {
        return this.extensions;
    }

    public String createMetaLine() {
        String metaLine = Integer.toHexString(this.getBody().getReadableSize());
        for (HttpChunkExtension extension : this.getExtensions()) {
            metaLine = metaLine + ";" + extension.getName();
            if (extension.getValue() == null) continue;
            metaLine = metaLine + "=" + extension.getValue();
        }
        return metaLine + TRAILER_STR;
    }

    public String createTrailer() {
        return TRAILER_STR;
    }

    public String toString() {
        String metaLine = this.createMetaLine();
        String trailer = this.createTrailer();
        return metaLine + trailer;
    }
}

