/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.api.dto;

import java.net.InetSocketAddress;
import org.webpieces.httpparser.api.common.Header;
import org.webpieces.httpparser.api.common.KnownHeaderName;
import org.webpieces.httpparser.api.dto.HttpMessage;
import org.webpieces.httpparser.api.dto.HttpMessageType;
import org.webpieces.httpparser.api.dto.HttpRequestLine;
import org.webpieces.httpparser.api.dto.UrlInfo;

public class HttpRequest
extends HttpMessage {
    private HttpRequestLine requestLine;

    public HttpRequestLine getRequestLine() {
        return this.requestLine;
    }

    public void setRequestLine(HttpRequestLine requestLine) {
        this.requestLine = requestLine;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.requestLine == null ? 0 : this.requestLine.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpRequest other = (HttpRequest)obj;
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        return !(this.requestLine == null ? other.requestLine != null : !this.requestLine.equals(other.requestLine));
    }

    public String toString() {
        String request = "" + this.requestLine;
        for (Header header : this.headers) {
            request = request + header;
        }
        return request + "\r\n";
    }

    @Override
    public HttpMessageType getMessageType() {
        return HttpMessageType.REQUEST;
    }

    public InetSocketAddress getServerToConnectTo(Integer port) {
        Integer resolvedPort;
        UrlInfo urlInfo = this.getRequestLine().getUri().getUriBreakdown();
        String host = urlInfo.getHost();
        if (host == null) {
            Header hostHeader = this.getHeaderLookupStruct().getLastInstanceOfHeader(KnownHeaderName.HOST);
            if (hostHeader == null) {
                throw new IllegalStateException("There is no host in url nor in HOST header to be found in this request");
            }
            host = hostHeader.getValue();
        }
        if ((resolvedPort = urlInfo.getResolvedPort()) == null) {
            if (port == null) {
                throw new IllegalArgumentException("The port is required since there is no port information in the HttpRequest");
            }
            resolvedPort = port;
        }
        return new InetSocketAddress(host, (int)resolvedPort);
    }
}

