/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.api.dto;

import java.util.HashMap;
import java.util.Map;

public enum KnownHttpMethod {
    OPTIONS("OPTIONS"),
    GET("GET"),
    HEAD("HEAD"),
    POST("POST"),
    PUT("PUT"),
    DELETE("DELETE"),
    TRACE("TRACE"),
    CONNECT("CONNECT");

    private static Map<String, KnownHttpMethod> codeToKnownStatus;
    private String code;

    private KnownHttpMethod(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static KnownHttpMethod lookup(String method) {
        return codeToKnownStatus.get(method);
    }

    static {
        codeToKnownStatus = new HashMap<String, KnownHttpMethod>();
        for (KnownHttpMethod status : KnownHttpMethod.values()) {
            codeToKnownStatus.put(status.getCode(), status);
        }
    }
}

