/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.impl;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.HttpParserFactory;
import org.webpieces.httpparser.api.MarshalState;
import org.webpieces.httpparser.api.Memento;
import org.webpieces.httpparser.api.ParseException;
import org.webpieces.httpparser.api.common.Header;
import org.webpieces.httpparser.api.common.KnownHeaderName;
import org.webpieces.httpparser.api.dto.Http2MarkerMessage;
import org.webpieces.httpparser.api.dto.HttpChunk;
import org.webpieces.httpparser.api.dto.HttpChunkExtension;
import org.webpieces.httpparser.api.dto.HttpData;
import org.webpieces.httpparser.api.dto.HttpLastChunk;
import org.webpieces.httpparser.api.dto.HttpMessage;
import org.webpieces.httpparser.api.dto.HttpMessageType;
import org.webpieces.httpparser.api.dto.HttpPayload;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.httpparser.api.dto.HttpRequestLine;
import org.webpieces.httpparser.api.dto.HttpRequestMethod;
import org.webpieces.httpparser.api.dto.HttpResponse;
import org.webpieces.httpparser.api.dto.HttpResponseStatus;
import org.webpieces.httpparser.api.dto.HttpResponseStatusLine;
import org.webpieces.httpparser.api.dto.HttpUri;
import org.webpieces.httpparser.api.dto.HttpVersion;
import org.webpieces.httpparser.impl.ConvertAscii;
import org.webpieces.httpparser.impl.MarshalStateImpl;
import org.webpieces.httpparser.impl.MementoImpl;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class HttpParserImpl
implements HttpParser {
    private static final Logger log = LoggerFactory.getLogger(HttpParserImpl.class);
    private static final Charset iso8859_1 = HttpParserFactory.iso8859_1;
    private static final String TRAILER_STR = "\r\n";
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private ConvertAscii conversion = new ConvertAscii();
    private BufferPool pool;

    public HttpParserImpl(BufferPool pool) {
        this.pool = pool;
    }

    @Override
    public MarshalState prepareToMarshal() {
        return new MarshalStateImpl();
    }

    @Override
    public ByteBuffer marshalToByteBuffer(MarshalState state, HttpPayload request) {
        byte[] data = this.marshalToBytes(state, request);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return buffer;
    }

    public byte[] marshalToBytes(MarshalState s, HttpPayload payload) {
        MarshalStateImpl state = (MarshalStateImpl)s;
        if (state.getParsingDataSize() != null) {
            return this.parseData(state, payload);
        }
        if (payload.getMessageType() == HttpMessageType.CHUNK || payload.getMessageType() == HttpMessageType.LAST_CHUNK) {
            return this.chunkedBytes((HttpChunk)payload);
        }
        HttpMessage msg = (HttpMessage)payload;
        String result = this.marshalHeaders(payload);
        Header header = msg.getHeaderLookupStruct().getHeader(KnownHeaderName.CONTENT_LENGTH);
        if (header != null && !header.getValue().equals("0")) {
            String value = header.getValue();
            int lengthOfBodyFromHeader = this.toInteger(value, "" + header);
            state.setParsingDataSize(lengthOfBodyFromHeader);
        }
        byte[] stringPiece = result.getBytes(iso8859_1);
        return stringPiece;
    }

    private byte[] parseData(MarshalStateImpl state, HttpPayload payload) {
        if (!(payload instanceof HttpData)) {
            throw new IllegalStateException("You passed in a request or response earlier with Content-Length so must pass in all the HttpData next not this=" + payload);
        }
        HttpData data = payload.getHttpData();
        DataWrapper body = data.getBodyNonNull();
        state.addMoreBytes(body.getReadableSize());
        if (state.getTotalRead() > state.getParsingDataSize()) {
            throw new IllegalStateException("Content-Length was " + state.getParsingDataSize() + " but you have so far passed in " + state.getTotalRead() + " bytes");
        }
        if (state.getTotalRead() == state.getParsingDataSize().intValue()) {
            state.resetDataReading();
        }
        return body.createByteArray();
    }

    private void copyData(DataWrapper body, byte[] data, int offset) {
        for (int i = 0; i < body.getReadableSize(); ++i) {
            data[offset + i] = body.readByteAt(i);
        }
    }

    private byte[] chunkedBytes(HttpChunk request) {
        DataWrapper dataWrapper = request.getBody();
        int size = dataWrapper.getReadableSize();
        String metaLine = request.createMetaLine();
        String lastPart = request.createTrailer();
        byte[] hex = metaLine.getBytes(iso8859_1);
        byte[] endData = lastPart.getBytes(iso8859_1);
        byte[] data = new byte[hex.length + size + endData.length];
        System.arraycopy(hex, 0, data, 0, hex.length);
        this.copyData(dataWrapper, data, hex.length);
        System.arraycopy(endData, 0, data, data.length - endData.length, endData.length);
        return data;
    }

    private Integer toInteger(String value, String line) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("HttpMessage contains illegal line(could not convert value to Integer)=" + line);
        }
    }

    @Override
    public String marshalToString(HttpPayload httpMsg) {
        if (httpMsg.getMessageType() == HttpMessageType.CHUNK || httpMsg.getMessageType() == HttpMessageType.DATA) {
            throw new IllegalArgumentException("Cannot marshal http message with a body to a string");
        }
        return this.marshalHeaders(httpMsg);
    }

    private String marshalHeaders(HttpPayload httpMsg) {
        if (httpMsg.getMessageType() == HttpMessageType.REQUEST) {
            this.validate(httpMsg.getHttpRequest());
        } else if (httpMsg.getMessageType() == HttpMessageType.RESPONSE) {
            this.validate(httpMsg.getHttpResponse());
        }
        StringBuilder builder = new StringBuilder();
        builder.append(httpMsg + "");
        return builder.toString();
    }

    private void validate(HttpResponse response) {
        HttpResponseStatusLine statusLine = response.getStatusLine();
        if (statusLine == null) {
            throw new IllegalArgumentException("response.statusLine is not set(call response.setStatusLine");
        }
        HttpResponseStatus status = statusLine.getStatus();
        if (status == null) {
            throw new IllegalArgumentException("response.statusLine.status is not set(call response.getStatusLine().setStatus())");
        }
        if (status.getCode() == null) {
            throw new IllegalArgumentException("response.statusLine.status.code is not set(call response.getStatusLine().getStatus().setCode())");
        }
        if (status.getReason() == null) {
            throw new IllegalArgumentException("response.statusLine.status.reason is not set");
        }
        if (statusLine.getVersion() == null) {
            throw new IllegalArgumentException("response.statusLine.version is not set");
        }
    }

    private void validate(HttpRequest request) {
        HttpRequestLine requestLine = request.getRequestLine();
        if (requestLine == null) {
            throw new IllegalArgumentException("request.requestLine is not set(call request.setRequestLine()");
        }
        if (requestLine.getMethod() == null) {
            throw new IllegalArgumentException("request.requestLine.method is not set(call request.getRequestLine().setMethod()");
        }
        if (requestLine.getVersion() == null) {
            throw new IllegalArgumentException("request.requestLine.version is not set(call request.getRequestLine().setVersion()");
        }
    }

    @Override
    public Memento prepareToParse() {
        MementoImpl memento = new MementoImpl();
        memento.setLeftOverData(dataGen.emptyWrapper());
        return memento;
    }

    @Override
    public Memento parse(Memento state, DataWrapper moreData) {
        if (!(state instanceof MementoImpl)) {
            throw new IllegalArgumentException("You must always pass in the memento created in prepareToParse which we always hand backto you from this method.  It contains state of leftover data");
        }
        MementoImpl memento = (MementoImpl)state;
        int totalData = state.getLeftOverData().getReadableSize() + moreData.getReadableSize();
        memento = this.parse(memento, moreData);
        int bytesParsed = totalData - memento.getLeftOverData().getReadableSize();
        memento.setNumBytesJustParsed(bytesParsed);
        return memento;
    }

    private MementoImpl parse(MementoImpl memento, DataWrapper moreData) {
        log.trace(() -> "Trying to parse message");
        memento.setParsedMessages(new ArrayList<HttpPayload>());
        DataWrapper leftOverData = memento.getLeftOverData();
        DataWrapper allData = dataGen.chainDataWrappers(leftOverData, moreData);
        memento.setLeftOverData(allData);
        if (memento.isInChunkParsingMode()) {
            this.processChunks(memento);
        } else if (memento.getContentLengthLeftToRead() != null) {
            this.readInContentLengthBody(memento);
        } else if (memento.getHalfParsedChunk() != null) {
            this.readInChunkBody(memento, false);
        }
        if (memento.getHalfParsedChunk() != null || memento.getContentLengthLeftToRead() != null) {
            return memento;
        }
        this.findCrLnCrLnAndParseMessage(memento);
        return memento;
    }

    private void readInContentLengthBody(MementoImpl memento) {
        boolean isEos;
        Integer toRead = memento.getContentLengthLeftToRead();
        DataWrapper data = memento.getLeftOverData();
        int readSize = Math.min(toRead, data.getReadableSize());
        if (readSize == 0) {
            return;
        }
        int newSizeLeft = toRead - readSize;
        if (newSizeLeft == 0) {
            isEos = true;
            memento.setContentLengthLeftToRead(null);
        } else {
            isEos = false;
            memento.setContentLengthLeftToRead(newSizeLeft);
        }
        List split = dataGen.split(data, readSize);
        HttpData httpData = new HttpData((DataWrapper)split.get(0), isEos);
        memento.setLeftOverData((DataWrapper)split.get(1));
        memento.addMessage(httpData);
    }

    private void findCrLnCrLnAndParseMessage(MementoImpl memento) {
        int i;
        for (i = memento.getReadingHttpMessagePointer(); i < memento.getLeftOverData().getReadableSize() - 3; ++i) {
            boolean parsedAndSplitBuffer = this.processUntilRead(memento, i);
            if (parsedAndSplitBuffer) {
                i = 0;
            }
            if (memento.getHalfParsedChunk() != null || memento.getContentLengthLeftToRead() != null || memento.isHasHttpMarkerMsg()) break;
        }
        memento.setReadingHttpMessagePointer(i);
    }

    private boolean processUntilRead(MementoImpl memento, int i) {
        DataWrapper dataToRead = memento.getLeftOverData();
        byte firstByte = dataToRead.readByteAt(i);
        byte secondByte = dataToRead.readByteAt(i + 1);
        byte thirdByte = dataToRead.readByteAt(i + 2);
        byte fourthByte = dataToRead.readByteAt(i + 3);
        boolean isFirstCr = this.conversion.isCarriageReturn(firstByte);
        boolean isSecondLineFeed = this.conversion.isLineFeed(secondByte);
        boolean isThirdCr = this.conversion.isCarriageReturn(thirdByte);
        boolean isFourthLineField = this.conversion.isLineFeed(fourthByte);
        if (isFirstCr && isSecondLineFeed && isThirdCr && isFourthLineField) {
            this.processHttpMessageAndMaybeBody(memento, dataToRead, i);
            memento.setReadingHttpMessagePointer(0);
            return true;
        }
        if (isFirstCr && isSecondLineFeed) {
            memento.addDemarcation(i);
        }
        return false;
    }

    private void processHttpMessageAndMaybeBody(MementoImpl memento, DataWrapper dataToRead, int i) {
        List<Integer> markedPositions = memento.getLeftOverMarkedPositions();
        memento.setLeftOverMarkedPositions(new ArrayList<Integer>());
        List tuple = dataGen.split(dataToRead, i + 4);
        DataWrapper toBeParsed = (DataWrapper)tuple.get(0);
        memento.setLeftOverData((DataWrapper)tuple.get(1));
        memento.setReadingHttpMessagePointer(0);
        HttpMessage message = this.parseHttpMessage(memento, toBeParsed, markedPositions);
        if (memento.isHttp2()) {
            return;
        }
        Header contentLenHeader = message.getHeaderLookupStruct().getHeader(KnownHeaderName.CONTENT_LENGTH);
        Header transferHeader = message.getHeaderLookupStruct().getLastInstanceOfHeader(KnownHeaderName.TRANSFER_ENCODING);
        if (transferHeader != null && "chunked".equals(transferHeader.getValue())) {
            memento.setInChunkParsingMode(true);
            this.processChunks(memento);
            return;
        }
        if (contentLenHeader != null && !"0".equals(contentLenHeader.getValue())) {
            String value = contentLenHeader.getValue();
            int length = this.toInteger(value, "" + contentLenHeader);
            memento.setContentLengthLeftToRead(length);
            this.readInContentLengthBody(memento);
            return;
        }
    }

    private void processChunks(MementoImpl memento) {
        int i;
        if (memento.getHalfParsedChunk() != null) {
            this.readInChunkBody(memento, true);
            if (memento.getHalfParsedChunk() != null) {
                return;
            }
        }
        for (i = memento.getReadingHttpMessagePointer(); i < memento.getLeftOverData().getReadableSize() - 1; ++i) {
            DataWrapper dataToRead = memento.getLeftOverData();
            byte firstByte = dataToRead.readByteAt(i);
            byte secondByte = dataToRead.readByteAt(i + 1);
            boolean isFirstCr = this.conversion.isCarriageReturn(firstByte);
            boolean isSecondLineFeed = this.conversion.isLineFeed(secondByte);
            if (!isFirstCr || !isSecondLineFeed) continue;
            this.readChunk(memento, i);
            i = 0;
            if (!memento.isInChunkParsingMode() || memento.getHalfParsedChunk() != null) break;
        }
        memento.setReadingHttpMessagePointer(i);
    }

    private void readChunk(MementoImpl memento, int i) {
        HttpChunk chunk = this.createHttpChunk(memento, i);
        memento.setHalfParsedChunk(chunk);
        this.readInChunkBody(memento, true);
        if (chunk.getBody() != null && chunk.getBody().getReadableSize() == 0) {
            memento.setInChunkParsingMode(false);
        }
    }

    private HttpChunk createHttpChunk(MementoImpl memento, int i) {
        DataWrapper dataToRead = memento.getLeftOverData();
        List split = dataGen.split(dataToRead, i + 2);
        DataWrapper chunkMetaData = (DataWrapper)split.get(0);
        memento.setLeftOverData((DataWrapper)split.get(1));
        ArrayList<HttpChunkExtension> extensions = new ArrayList<HttpChunkExtension>();
        String chunkMetaStr = chunkMetaData.createStringFrom(0, chunkMetaData.getReadableSize(), iso8859_1);
        String hexSize = chunkMetaStr.trim();
        if (chunkMetaStr.contains(";")) {
            String[] extensionsArray = chunkMetaStr.split(";");
            hexSize = extensionsArray[0];
            for (int n = 1; n < extensionsArray.length; ++n) {
                HttpChunkExtension ext = this.createExtension(extensionsArray[n]);
                extensions.add(ext);
            }
        }
        int chunkSize = Integer.parseInt(hexSize, 16);
        HttpChunk chunk = new HttpChunk();
        if (chunkSize == 0) {
            chunk = new HttpLastChunk();
        }
        int size = 2 + chunkSize;
        memento.setNumBytesLeftToReadOnChunk(size);
        return chunk;
    }

    private HttpChunkExtension createExtension(String extension) {
        if (!extension.contains("=")) {
            return new HttpChunkExtension(extension);
        }
        int indexOf = extension.indexOf(61);
        String name = extension.substring(0, indexOf);
        String value = extension.substring(indexOf);
        return new HttpChunkExtension(name, value);
    }

    private void readInChunkBody(MementoImpl memento, boolean stripAndCompareLastTwo) {
        HttpChunk message = memento.getHalfParsedChunk();
        DataWrapper dataToRead = memento.getLeftOverData();
        int readableSize = dataToRead.getReadableSize();
        int numBytesNeeded = memento.getNumBytesLeftToReadOnChunk();
        if (numBytesNeeded <= readableSize) {
            List split = dataGen.split(dataToRead, numBytesNeeded);
            DataWrapper data = (DataWrapper)split.get(0);
            if (stripAndCompareLastTwo) {
                List splitPieces = dataGen.split(data, data.getReadableSize() - 2);
                data = (DataWrapper)splitPieces.get(0);
                DataWrapper trailer = (DataWrapper)splitPieces.get(1);
                String trailerStr = trailer.createStringFrom(0, trailer.getReadableSize(), iso8859_1);
                if (!TRAILER_STR.equals(trailerStr)) {
                    throw new IllegalStateException("The chunk did not end with \\r\\n .  The format is invalid");
                }
            }
            message.setBody(data);
            memento.setLeftOverData((DataWrapper)split.get(1));
            memento.setNumBytesLeftToReadOnChunk(0);
            memento.addMessage(message);
            memento.setHalfParsedChunk(null);
            return;
        }
    }

    private HttpMessage parseHttpMessage(MementoImpl memento, DataWrapper toBeParsed, List<Integer> markedPositions) {
        ArrayList<String> lines = new ArrayList<String>();
        markedPositions.add(toBeParsed.getReadableSize());
        int offset = 0;
        for (Integer mark : markedPositions) {
            int len = mark - offset;
            String line = toBeParsed.createStringFrom(offset, len, iso8859_1);
            lines.add(line.trim());
            offset = mark;
        }
        markedPositions.clear();
        toBeParsed.releaseUnderlyingBuffers(this.pool);
        String firstLine = ((String)lines.get(0)).trim();
        if (memento.isHttp2()) {
            return this.checkSecondCase(memento, lines);
        }
        if (firstLine.startsWith("HTTP/")) {
            return this.parseResponse(memento, lines);
        }
        if (lines.size() == 1 && memento.getParsedMessages().size() == 0) {
            return this.checkSpecialCase(memento, lines);
        }
        return this.parseRequest(memento, lines);
    }

    private HttpMessage checkSecondCase(MementoImpl memento, List<String> lines) {
        String requestLine = lines.get(0);
        if ("SM".equals(requestLine)) {
            Http2MarkerMessage msg = new Http2MarkerMessage();
            memento.setHasHttpMarkerMsg(true);
            memento.addMessage(msg);
            return msg;
        }
        throw new IllegalArgumentException("PRI * HTTP/2.0\\r\\n received but then missing SM=" + requestLine);
    }

    private HttpMessage checkSpecialCase(MementoImpl memento, List<String> lines) {
        String requestLine = lines.get(0);
        if ("PRI * HTTP/2.0".equals(requestLine)) {
            memento.setHttp2(true);
            return null;
        }
        return this.parseRequest(memento, lines);
    }

    private HttpMessage parseRequest(MementoImpl memento, List<String> lines) {
        String firstLine = lines.remove(0);
        String[] firstLinePieces = firstLine.split("\\s+");
        if (firstLinePieces.length != 3) {
            throw new ParseException("Unable to parse invalid http request due to first line being invalid=" + firstLine + " all Lines=" + lines);
        }
        HttpRequestMethod method = new HttpRequestMethod(firstLinePieces[0]);
        HttpUri uri = new HttpUri(firstLinePieces[1]);
        HttpVersion version = this.parseVersion(firstLinePieces[2], firstLine);
        HttpRequestLine httpRequestLine = new HttpRequestLine();
        httpRequestLine.setMethod(method);
        httpRequestLine.setUri(uri);
        httpRequestLine.setVersion(version);
        HttpRequest request = new HttpRequest();
        request.setRequestLine(httpRequestLine);
        this.parseHeaders(lines, request);
        memento.addMessage(request);
        return request;
    }

    private HttpVersion parseVersion(String versionString, String firstLine) {
        if (!versionString.startsWith("HTTP/")) {
            throw new ParseException("Invalid version in http request first line not prefixed with HTTP/.  line=" + firstLine);
        }
        String ver = versionString.substring(5, versionString.length());
        HttpVersion version = new HttpVersion();
        version.setVersion(ver);
        return version;
    }

    private void parseHeaders(List<String> lines, HttpMessage httpMessage) {
        for (String line : lines) {
            Header header = this.parseHeader(line);
            httpMessage.addHeader(header);
        }
    }

    private Header parseHeader(String line) {
        int indexOf = line.indexOf(":");
        if (indexOf < 0) {
            throw new IllegalArgumentException("bad header line=" + line);
        }
        String value = line.substring(indexOf + 1).trim();
        String name = line.substring(0, indexOf);
        Header header = new Header();
        header.setName(name.trim());
        header.setValue(value.trim());
        return header;
    }

    private HttpMessage parseResponse(MementoImpl memento, List<String> lines) {
        String firstLine = lines.remove(0);
        int indexOf = firstLine.indexOf(" ");
        if (indexOf < 0) {
            throw new IllegalArgumentException("The first line of http request is invalid=" + firstLine);
        }
        String versionStr = firstLine.substring(0, indexOf).trim();
        String tail = firstLine.substring(indexOf).trim();
        int indexOf2 = tail.indexOf(" ");
        if (indexOf2 < 0) {
            throw new IllegalArgumentException("The first line of http request is invalid=" + firstLine);
        }
        String codeStr = tail.substring(0, indexOf2).trim();
        String reason = tail.substring(indexOf2).trim();
        HttpVersion version2 = this.parseVersion(versionStr, firstLine);
        HttpResponseStatus status = new HttpResponseStatus();
        Integer codeVal = this.toInteger(codeStr, firstLine);
        if (codeVal <= 0 || codeVal >= 1000) {
            throw new IllegalArgumentException("invalid status code.  response line=" + firstLine);
        }
        status.setCode(codeVal);
        status.setReason(reason);
        HttpResponseStatusLine httpRequestLine = new HttpResponseStatusLine();
        httpRequestLine.setStatus(status);
        httpRequestLine.setVersion(version2);
        HttpResponse response = new HttpResponse();
        response.setStatusLine(httpRequestLine);
        this.parseHeaders(lines, response);
        memento.addMessage(response);
        return response;
    }
}

