/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.api.dto;

public class HttpVersion {
    private int major = 1;
    private int minor = 1;

    public void setVersion(String version) {
        int index = version.indexOf(".");
        if (index < 0) {
            throw new IllegalStateException("Missing the '.' in the version number.  ie. 1.1.");
        }
        String first = version.substring(0, index);
        String last = version.substring(index + 1);
        this.major = this.convertToInteger(first);
        this.minor = this.convertToInteger(last);
    }

    private int convertToInteger(String first) {
        try {
            return Integer.valueOf(first);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Must be of format {integer}.{integer} but wasn't", e);
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getVersion() {
        return this.major + "." + this.minor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpVersion other = (HttpVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }

    public String toString() {
        return "HTTP/" + this.major + "." + this.minor;
    }
}

