/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.impl;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.HttpParserFactory;
import org.webpieces.httpparser.api.Memento;
import org.webpieces.httpparser.api.ParseException;
import org.webpieces.httpparser.api.ParsedStatus;
import org.webpieces.httpparser.api.common.Header;
import org.webpieces.httpparser.api.common.KnownHeaderName;
import org.webpieces.httpparser.api.dto.HttpChunk;
import org.webpieces.httpparser.api.dto.HttpChunkExtension;
import org.webpieces.httpparser.api.dto.HttpLastChunk;
import org.webpieces.httpparser.api.dto.HttpMessage;
import org.webpieces.httpparser.api.dto.HttpMessageType;
import org.webpieces.httpparser.api.dto.HttpPayload;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.httpparser.api.dto.HttpRequestLine;
import org.webpieces.httpparser.api.dto.HttpRequestMethod;
import org.webpieces.httpparser.api.dto.HttpResponse;
import org.webpieces.httpparser.api.dto.HttpResponseStatus;
import org.webpieces.httpparser.api.dto.HttpResponseStatusLine;
import org.webpieces.httpparser.api.dto.HttpUri;
import org.webpieces.httpparser.api.dto.HttpVersion;
import org.webpieces.httpparser.impl.ConvertAscii;
import org.webpieces.httpparser.impl.MementoImpl;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class HttpParserImpl
implements HttpParser {
    private static final Logger log = LoggerFactory.getLogger(HttpParserImpl.class);
    private static final Charset iso8859_1 = HttpParserFactory.iso8859_1;
    private static final String TRAILER_STR = "\r\n";
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private static final DataWrapper EMPTY_WRAPPER = dataGen.emptyWrapper();
    private ConvertAscii conversion = new ConvertAscii();
    private BufferPool pool;

    public HttpParserImpl(BufferPool pool) {
        this.pool = pool;
    }

    @Override
    public ByteBuffer marshalToByteBuffer(HttpPayload request) {
        byte[] data = this.marshalToBytes(request);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return buffer;
    }

    @Override
    public byte[] marshalToBytes(HttpPayload payload) {
        if (payload.getMessageType() == HttpMessageType.CHUNK || payload.getMessageType() == HttpMessageType.LAST_CHUNK) {
            return this.chunkedBytes((HttpChunk)payload);
        }
        HttpMessage msg = (HttpMessage)payload;
        String result = this.marshalHeaders(payload);
        DataWrapper body = payload.getBody();
        Header header = msg.getHeaderLookupStruct().getHeader(KnownHeaderName.CONTENT_LENGTH);
        if (header != null && !header.getValue().equals("0")) {
            int actualBodyLength;
            if (body == null) {
                throw new IllegalArgumentException("Header KnownHeaderName.CONTENT_LENGTH found but no body was set.  set a body");
            }
            String value = header.getValue();
            int lengthOfBodyFromHeader = this.toInteger(value, "" + header);
            if (lengthOfBodyFromHeader != (actualBodyLength = body.getReadableSize())) {
                throw new IllegalArgumentException("body size and KnownHeaderName.CONTENT_LENGTH must match.  bodySize=" + actualBodyLength + " header len=" + lengthOfBodyFromHeader);
            }
        } else {
            if (body != null && body.getReadableSize() != 0) {
                throw new IllegalArgumentException("Body provided but no header for KnownHeaderName.CONTENT_LENGTH found");
            }
            body = EMPTY_WRAPPER;
        }
        byte[] data = new byte[result.length() + body.getReadableSize()];
        byte[] stringPiece = result.getBytes(iso8859_1);
        System.arraycopy(stringPiece, 0, data, 0, stringPiece.length);
        this.copyData(body, data, stringPiece.length);
        return data;
    }

    private void copyData(DataWrapper body, byte[] data, int offset) {
        for (int i = 0; i < body.getReadableSize(); ++i) {
            data[offset + i] = body.readByteAt(i);
        }
    }

    private byte[] chunkedBytes(HttpChunk request) {
        DataWrapper dataWrapper = request.getBody();
        int size = dataWrapper.getReadableSize();
        String metaLine = request.createMetaLine();
        String lastPart = request.createTrailer();
        byte[] hex = metaLine.getBytes(iso8859_1);
        byte[] endData = lastPart.getBytes(iso8859_1);
        byte[] data = new byte[hex.length + size + endData.length];
        System.arraycopy(hex, 0, data, 0, hex.length);
        this.copyData(dataWrapper, data, hex.length);
        System.arraycopy(endData, 0, data, data.length - endData.length, endData.length);
        return data;
    }

    private Integer toInteger(String value, String line) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("HttpMessage contains illegal line(could not convert value to Integer)=" + line);
        }
    }

    @Override
    public String marshalToString(HttpPayload httpMsg) {
        if (httpMsg.getMessageType() != HttpMessageType.LAST_CHUNK && httpMsg.getBody() != null) {
            throw new IllegalArgumentException("Cannot marshal http message with a body to a string");
        }
        return this.marshalHeaders(httpMsg);
    }

    private String marshalHeaders(HttpPayload httpMsg) {
        if (httpMsg.getMessageType() == HttpMessageType.REQUEST) {
            this.validate(httpMsg.getHttpRequest());
        } else if (httpMsg.getMessageType() == HttpMessageType.RESPONSE) {
            this.validate(httpMsg.getHttpResponse());
        }
        StringBuilder builder = new StringBuilder();
        builder.append(httpMsg + "");
        return builder.toString();
    }

    private void validate(HttpResponse response) {
        HttpResponseStatusLine statusLine = response.getStatusLine();
        if (statusLine == null) {
            throw new IllegalArgumentException("response.statusLine is not set(call response.setStatusLine");
        }
        HttpResponseStatus status = statusLine.getStatus();
        if (status == null) {
            throw new IllegalArgumentException("response.statusLine.status is not set(call response.getStatusLine().setStatus())");
        }
        if (status.getCode() == null) {
            throw new IllegalArgumentException("response.statusLine.status.code is not set(call response.getStatusLine().getStatus().setCode())");
        }
        if (status.getReason() == null) {
            throw new IllegalArgumentException("response.statusLine.status.reason is not set");
        }
        if (statusLine.getVersion() == null) {
            throw new IllegalArgumentException("response.statusLine.version is not set");
        }
    }

    private void validate(HttpRequest request) {
        HttpRequestLine requestLine = request.getRequestLine();
        if (requestLine == null) {
            throw new IllegalArgumentException("request.requestLine is not set(call request.setRequestLine()");
        }
        if (requestLine.getMethod() == null) {
            throw new IllegalArgumentException("request.requestLine.method is not set(call request.getRequestLine().setMethod()");
        }
        if (requestLine.getVersion() == null) {
            throw new IllegalArgumentException("request.requestLine.version is not set(call request.getRequestLine().setVersion()");
        }
    }

    @Override
    public Memento prepareToParse() {
        MementoImpl memento = new MementoImpl();
        memento.setLeftOverData(dataGen.emptyWrapper());
        return memento;
    }

    @Override
    public Memento parse(Memento state, DataWrapper moreData) {
        if (!(state instanceof MementoImpl)) {
            throw new IllegalArgumentException("You must always pass in the memento created in prepareToParse which we always hand backto you from this method.  It contains state of leftover data");
        }
        log.trace(() -> "Trying to parse message");
        MementoImpl memento = (MementoImpl)state;
        memento.setStatus(ParsedStatus.NEED_MORE_DATA);
        memento.getParsedMessages().clear();
        DataWrapper leftOverData = memento.getLeftOverData();
        DataWrapper allData = dataGen.chainDataWrappers(leftOverData, moreData);
        memento.setLeftOverData(allData);
        if (memento.isInChunkParsingMode()) {
            this.processChunks(memento);
        } else if (memento.getHalfParsedMessage() != null) {
            this.readInBody(memento, false);
        }
        if (memento.getHalfParsedMessage() != null) {
            return memento;
        }
        this.findCrLnCrLnAndParseMessage(memento);
        return memento;
    }

    private void findCrLnCrLnAndParseMessage(MementoImpl memento) {
        int i;
        for (i = memento.getReadingHttpMessagePointer(); i < memento.getLeftOverData().getReadableSize() - 3; ++i) {
            boolean parsedAndSplitBuffer = this.processUntilRead(memento, i);
            if (parsedAndSplitBuffer) {
                i = 0;
            }
            if (memento.getHalfParsedMessage() != null) break;
        }
        memento.setReadingHttpMessagePointer(i);
        DataWrapper leftOverData = memento.getLeftOverData();
        if (leftOverData.getReadableSize() == 0) {
            memento.setStatus(ParsedStatus.ALL_DATA_PARSED);
        } else if (memento.getParsedMessages().size() > 0) {
            memento.setStatus(ParsedStatus.MSG_PARSED_AND_LEFTOVER_DATA);
        }
    }

    private boolean processUntilRead(MementoImpl memento, int i) {
        DataWrapper dataToRead = memento.getLeftOverData();
        byte firstByte = dataToRead.readByteAt(i);
        byte secondByte = dataToRead.readByteAt(i + 1);
        byte thirdByte = dataToRead.readByteAt(i + 2);
        byte fourthByte = dataToRead.readByteAt(i + 3);
        boolean isFirstCr = this.conversion.isCarriageReturn(firstByte);
        boolean isSecondLineFeed = this.conversion.isLineFeed(secondByte);
        boolean isThirdCr = this.conversion.isCarriageReturn(thirdByte);
        boolean isFourthLineField = this.conversion.isLineFeed(fourthByte);
        if (isFirstCr && isSecondLineFeed && isThirdCr && isFourthLineField) {
            this.processHttpMessageAndMaybeBody(memento, dataToRead, i);
            memento.setReadingHttpMessagePointer(0);
            return true;
        }
        if (isFirstCr && isSecondLineFeed) {
            memento.addDemarcation(i);
        }
        return false;
    }

    private void processHttpMessageAndMaybeBody(MementoImpl memento, DataWrapper dataToRead, int i) {
        List<Integer> markedPositions = memento.getLeftOverMarkedPositions();
        memento.setLeftOverMarkedPositions(new ArrayList<Integer>());
        List tuple = dataGen.split(dataToRead, i + 4);
        DataWrapper toBeParsed = (DataWrapper)tuple.get(0);
        memento.setLeftOverData((DataWrapper)tuple.get(1));
        HttpMessage message = this.parseHttpMessage(toBeParsed, markedPositions);
        Header header = message.getHeaderLookupStruct().getHeader(KnownHeaderName.CONTENT_LENGTH);
        Header transferHeader = message.getHeaderLookupStruct().getLastInstanceOfHeader(KnownHeaderName.TRANSFER_ENCODING);
        if (header != null) {
            String value = header.getValue();
            int length = this.toInteger(value, "" + header);
            memento.setNumBytesLeftToRead(length);
            memento.setHalfParsedMessage(message);
            this.readInBody(memento, false);
            return;
        }
        if (transferHeader != null && "chunked".equals(transferHeader.getValue())) {
            memento.getParsedMessages().add(message);
            memento.setInChunkParsingMode(true);
            this.processChunks(memento);
            return;
        }
        memento.getParsedMessages().add(message);
    }

    private void processChunks(MementoImpl memento) {
        int i;
        if (memento.getHalfParsedMessage() != null) {
            this.readInBody(memento, true);
            if (memento.getHalfParsedMessage() != null) {
                return;
            }
        }
        for (i = memento.getReadingHttpMessagePointer(); i < memento.getLeftOverData().getReadableSize() - 1; ++i) {
            DataWrapper dataToRead = memento.getLeftOverData();
            byte firstByte = dataToRead.readByteAt(i);
            byte secondByte = dataToRead.readByteAt(i + 1);
            boolean isFirstCr = this.conversion.isCarriageReturn(firstByte);
            boolean isSecondLineFeed = this.conversion.isLineFeed(secondByte);
            if (!isFirstCr || !isSecondLineFeed) continue;
            this.readChunk(memento, i);
            i = 0;
            if (!memento.isInChunkParsingMode() || memento.getHalfParsedMessage() != null) break;
        }
        memento.setReadingHttpMessagePointer(i);
    }

    private void readChunk(MementoImpl memento, int i) {
        HttpChunk chunk = this.createHttpChunk(memento, i);
        memento.setHalfParsedMessage(chunk);
        this.readInBody(memento, true);
        if (chunk.getBody() != null && chunk.getBody().getReadableSize() == 0) {
            memento.setInChunkParsingMode(false);
        }
    }

    private HttpChunk createHttpChunk(MementoImpl memento, int i) {
        DataWrapper dataToRead = memento.getLeftOverData();
        List split = dataGen.split(dataToRead, i + 2);
        DataWrapper chunkMetaData = (DataWrapper)split.get(0);
        memento.setLeftOverData((DataWrapper)split.get(1));
        ArrayList<HttpChunkExtension> extensions = new ArrayList<HttpChunkExtension>();
        String chunkMetaStr = chunkMetaData.createStringFrom(0, chunkMetaData.getReadableSize(), iso8859_1);
        String hexSize = chunkMetaStr.trim();
        if (chunkMetaStr.contains(";")) {
            String[] extensionsArray = chunkMetaStr.split(";");
            hexSize = extensionsArray[0];
            for (int n = 1; n < extensionsArray.length; ++n) {
                HttpChunkExtension ext = this.createExtension(extensionsArray[n]);
                extensions.add(ext);
            }
        }
        int chunkSize = Integer.parseInt(hexSize, 16);
        HttpChunk chunk = new HttpChunk();
        if (chunkSize == 0) {
            chunk = new HttpLastChunk();
        }
        int size = 2 + chunkSize;
        memento.setNumBytesLeftToRead(size);
        return chunk;
    }

    private HttpChunkExtension createExtension(String extension) {
        if (!extension.contains("=")) {
            return new HttpChunkExtension(extension);
        }
        int indexOf = extension.indexOf(61);
        String name = extension.substring(0, indexOf);
        String value = extension.substring(indexOf);
        return new HttpChunkExtension(name, value);
    }

    private void readInBody(MementoImpl memento, boolean stripAndCompareLastTwo) {
        HttpPayload message = memento.getHalfParsedMessage();
        DataWrapper dataToRead = memento.getLeftOverData();
        int readableSize = dataToRead.getReadableSize();
        int numBytesNeeded = memento.getNumBytesLeftToRead();
        if (numBytesNeeded <= readableSize) {
            List split = dataGen.split(dataToRead, numBytesNeeded);
            DataWrapper data = (DataWrapper)split.get(0);
            if (stripAndCompareLastTwo) {
                List splitPieces = dataGen.split(data, data.getReadableSize() - 2);
                data = (DataWrapper)splitPieces.get(0);
                DataWrapper trailer = (DataWrapper)splitPieces.get(1);
                String trailerStr = trailer.createStringFrom(0, trailer.getReadableSize(), iso8859_1);
                if (!TRAILER_STR.equals(trailerStr)) {
                    throw new IllegalStateException("The chunk did not end with \\r\\n .  The format is invalid");
                }
            }
            message.setBody(data);
            memento.setLeftOverData((DataWrapper)split.get(1));
            memento.setNumBytesLeftToRead(0);
            memento.getParsedMessages().add(message);
            memento.setHalfParsedMessage(null);
            return;
        }
    }

    private HttpMessage parseHttpMessage(DataWrapper toBeParsed, List<Integer> markedPositions) {
        ArrayList<String> lines = new ArrayList<String>();
        markedPositions.add(toBeParsed.getReadableSize());
        int offset = 0;
        for (Integer mark : markedPositions) {
            int len = mark - offset;
            String line = toBeParsed.createStringFrom(offset, len, iso8859_1);
            lines.add(line.trim());
            offset = mark;
        }
        markedPositions.clear();
        toBeParsed.releaseUnderlyingBuffers(this.pool);
        String firstLine = ((String)lines.get(0)).trim();
        if (firstLine.startsWith("HTTP/")) {
            return this.parseResponse(lines);
        }
        return this.parseRequest(lines);
    }

    private HttpMessage parseRequest(List<String> lines) {
        String firstLine = lines.remove(0);
        String[] firstLinePieces = firstLine.split("\\s+");
        if (firstLinePieces.length != 3) {
            throw new ParseException("Unable to parse invalid http request due to first line being invalid=" + firstLine + " all Lines=" + lines);
        }
        HttpRequestMethod method = new HttpRequestMethod(firstLinePieces[0]);
        HttpUri uri = new HttpUri(firstLinePieces[1]);
        HttpVersion version = this.parseVersion(firstLinePieces[2], firstLine);
        HttpRequestLine httpRequestLine = new HttpRequestLine();
        httpRequestLine.setMethod(method);
        httpRequestLine.setUri(uri);
        httpRequestLine.setVersion(version);
        HttpRequest request = new HttpRequest();
        request.setRequestLine(httpRequestLine);
        this.parseHeaders(lines, request);
        return request;
    }

    private HttpVersion parseVersion(String versionString, String firstLine) {
        if (!versionString.startsWith("HTTP/")) {
            throw new ParseException("Invalid version in http request first line not prefixed with HTTP/.  line=" + firstLine);
        }
        String ver = versionString.substring(5, versionString.length());
        HttpVersion version = new HttpVersion();
        version.setVersion(ver);
        return version;
    }

    private void parseHeaders(List<String> lines, HttpMessage httpMessage) {
        for (String line : lines) {
            Header header = this.parseHeader(line);
            httpMessage.addHeader(header);
        }
    }

    private Header parseHeader(String line) {
        int indexOf = line.indexOf(":");
        if (indexOf < 0) {
            throw new IllegalArgumentException("bad header line=" + line);
        }
        String value = line.substring(indexOf + 1).trim();
        String name = line.substring(0, indexOf);
        Header header = new Header();
        header.setName(name.trim());
        header.setValue(value.trim());
        return header;
    }

    private HttpMessage parseResponse(List<String> lines) {
        String firstLine = lines.remove(0);
        int indexOf = firstLine.indexOf(" ");
        if (indexOf < 0) {
            throw new IllegalArgumentException("The first line of http request is invalid=" + firstLine);
        }
        String versionStr = firstLine.substring(0, indexOf).trim();
        String tail = firstLine.substring(indexOf).trim();
        int indexOf2 = tail.indexOf(" ");
        if (indexOf2 < 0) {
            throw new IllegalArgumentException("The first line of http request is invalid=" + firstLine);
        }
        String codeStr = tail.substring(0, indexOf2).trim();
        String reason = tail.substring(indexOf2).trim();
        HttpVersion version2 = this.parseVersion(versionStr, firstLine);
        HttpResponseStatus status = new HttpResponseStatus();
        Integer codeVal = this.toInteger(codeStr, firstLine);
        if (codeVal <= 0 || codeVal >= 1000) {
            throw new IllegalArgumentException("invalid status code.  response line=" + firstLine);
        }
        status.setCode(codeVal);
        status.setReason(reason);
        HttpResponseStatusLine httpRequestLine = new HttpResponseStatusLine();
        httpRequestLine.setStatus(status);
        httpRequestLine.setVersion(version2);
        HttpResponse response = new HttpResponse();
        response.setStatusLine(httpRequestLine);
        this.parseHeaders(lines, response);
        return response;
    }

    @Override
    public HttpPayload unmarshal(byte[] msg) {
        DataWrapper dataWrapper;
        Memento memento = this.prepareToParse();
        Memento parsedData = this.parse(memento, dataWrapper = dataGen.wrapByteArray(msg));
        if (parsedData.getStatus() == ParsedStatus.MSG_PARSED_AND_LEFTOVER_DATA) {
            throw new IllegalArgumentException("There is more data than one http message.  Use unmarshalAsync instead");
        }
        if (parsedData.getStatus() == ParsedStatus.NEED_MORE_DATA) {
            throw new IllegalArgumentException("This http message is not complete.  Use unmarshalAsynch instead or fix client code to pass in complete http message(or report a bug if it is this libraries fault)");
        }
        List<HttpPayload> messages = parsedData.getParsedMessages();
        if (messages.size() != 1) {
            throw new IllegalArgumentException("You passed in data for more than one http messages.  number of http messages=" + messages.size());
        }
        return messages.get(0);
    }
}

