/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.impl;

import java.util.ArrayList;
import java.util.List;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.httpparser.api.Memento;
import org.webpieces.httpparser.api.ParsedStatus;
import org.webpieces.httpparser.api.ParsingState;
import org.webpieces.httpparser.api.UnparsedState;
import org.webpieces.httpparser.api.dto.HttpPayload;

public class MementoImpl
implements Memento {
    private List<Integer> leftOverMarkedPositions = new ArrayList<Integer>();
    private DataWrapper leftOverData;
    private int numBytesLeftToRead;
    private HttpPayload halfParsedMessage;
    private boolean inChunkParsingMode;
    private ParsedStatus status = ParsedStatus.NEED_MORE_DATA;
    private List<HttpPayload> parsedMessages = new ArrayList<HttpPayload>();
    private int indexBytePointer;

    public void setStatus(ParsedStatus status) {
        this.status = status;
    }

    @Override
    public ParsedStatus getStatus() {
        return this.status;
    }

    @Override
    public List<HttpPayload> getParsedMessages() {
        return this.parsedMessages;
    }

    public void setParsedMessages(List<HttpPayload> parsedMessages) {
        this.parsedMessages = parsedMessages;
    }

    @Override
    public DataWrapper getLeftOverData() {
        return this.leftOverData;
    }

    public void setLeftOverData(DataWrapper data) {
        this.leftOverData = data;
    }

    public void addDemarcation(int i) {
        this.leftOverMarkedPositions.add(i);
    }

    public List<Integer> getLeftOverMarkedPositions() {
        return this.leftOverMarkedPositions;
    }

    public void setLeftOverMarkedPositions(List<Integer> leftOverMarkedPositions) {
        this.leftOverMarkedPositions = leftOverMarkedPositions;
    }

    public int getNumBytesLeftToRead() {
        return this.numBytesLeftToRead;
    }

    public void setNumBytesLeftToRead(int length) {
        this.numBytesLeftToRead = length;
    }

    public void setHalfParsedMessage(HttpPayload message) {
        this.halfParsedMessage = message;
    }

    @Override
    public HttpPayload getHalfParsedMessage() {
        return this.halfParsedMessage;
    }

    public void setReadingHttpMessagePointer(int indexBytePointer) {
        this.indexBytePointer = indexBytePointer;
    }

    public int getReadingHttpMessagePointer() {
        return this.indexBytePointer;
    }

    public void setInChunkParsingMode(boolean inChunkParsingMode) {
        this.inChunkParsingMode = inChunkParsingMode;
    }

    public boolean isInChunkParsingMode() {
        return this.inChunkParsingMode;
    }

    @Override
    public UnparsedState getUnParsedState() {
        if (this.inChunkParsingMode) {
            return new UnparsedState(ParsingState.CHUNK, this.leftOverData.getReadableSize());
        }
        if (this.halfParsedMessage != null) {
            return new UnparsedState(ParsingState.BODY, this.leftOverData.getReadableSize());
        }
        return new UnparsedState(ParsingState.HEADERS, this.leftOverData.getReadableSize());
    }
}

