/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.impl.subparsers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.webpieces.httpparser.api.common.Header;
import org.webpieces.httpparser.api.common.KnownHeaderName;
import org.webpieces.httpparser.api.common.ResponseCookie;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.httpparser.api.subparsers.AcceptType;
import org.webpieces.httpparser.api.subparsers.HeaderItem;
import org.webpieces.httpparser.api.subparsers.HeaderPriorityParser;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class HeaderPriorityParserImpl
implements HeaderPriorityParser {
    private static final Logger log = LoggerFactory.getLogger(HeaderPriorityParserImpl.class);

    @Override
    public List<String> parseAcceptEncoding(HttpRequest req) {
        Header langHeader = req.getHeaderLookupStruct().getHeader(KnownHeaderName.ACCEPT_ENCODING);
        if (langHeader == null) {
            return new ArrayList<String>();
        }
        List<String> headerItems = this.parsePriorityItems(langHeader.getValue(), s -> s);
        return headerItems;
    }

    @Override
    public List<Locale> parseAcceptLangFromRequest(HttpRequest req) {
        Header langHeader = req.getHeaderLookupStruct().getHeader(KnownHeaderName.ACCEPT_LANGUAGE);
        if (langHeader == null) {
            return new ArrayList<Locale>();
        }
        List<Locale> headerItems = this.parsePriorityItems(langHeader.getValue(), s -> this.parseItem((String)s));
        return headerItems;
    }

    private Locale parseItem(String subItem) {
        Locale locale = null;
        String[] l = subItem.split("_");
        switch (l.length) {
            case 2: {
                locale = new Locale(l[0], l[1]);
                break;
            }
            case 3: {
                locale = new Locale(l[0], l[1], l[2]);
                break;
            }
            default: {
                locale = new Locale(l[0]);
            }
        }
        return locale;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> List<T> parsePriorityItems(String value, Function<String, T> parseFunction) {
        void var6_8;
        ArrayList<HeaderItem<String>> headerItems = new ArrayList<HeaderItem<String>>();
        String[] stringArray = value.split(",");
        int n = stringArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            String str = stringArray[var6_8];
            String[] arr = str.trim().replace("-", "_").split(";");
            String item = parseFunction.apply(arr[0]);
            if (item != null) {
                Double q = 1.0;
                for (String s : arr) {
                    if (!(s = s.trim()).startsWith("q=")) continue;
                    q = Double.parseDouble(s.substring(2).trim());
                    break;
                }
                HeaderItem<String> headerItem = new HeaderItem<String>(q, item);
                headerItems.add(headerItem);
            }
            ++var6_8;
        }
        Collections.sort(headerItems);
        ArrayList orderedItems = new ArrayList();
        for (HeaderItem headerItem : headerItems) {
            orderedItems.add(headerItem.getItem());
        }
        return orderedItems;
    }

    @Override
    public Map<String, String> parseCookiesFromRequest(HttpRequest req) {
        Header cookieHeader = req.getHeaderLookupStruct().getHeader(KnownHeaderName.COOKIE);
        if (cookieHeader == null) {
            return new HashMap<String, String>();
        }
        String value = cookieHeader.getValue();
        String[] split = value.trim().split(";");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String keyValPair : split) {
            int index = keyValPair.indexOf("=");
            String name = keyValPair.substring(0, index).trim();
            String val = keyValPair.substring(index + 1).trim();
            map.put(name, val);
        }
        return map;
    }

    @Override
    public Header createHeader(ResponseCookie cookie) {
        String name = cookie.getName();
        String value = cookie.getValue();
        Integer maxAgeSeconds = cookie.getMaxAgeSeconds();
        String domain = cookie.getDomain();
        String path = cookie.getPath();
        boolean isHttpOnly = cookie.isHttpOnly();
        boolean isSecure = cookie.isSecure();
        String headerVal = "";
        if (name != null) {
            headerVal = name + "=";
        } else if (value == null) {
            throw new IllegalArgumentException("value in cookie cannot be null");
        }
        headerVal = headerVal + value;
        if (maxAgeSeconds != null) {
            headerVal = headerVal + "; Max-Age=" + maxAgeSeconds;
        }
        if (domain != null) {
            headerVal = headerVal + "; domain=" + domain;
        }
        if (path != null) {
            headerVal = headerVal + "; path=" + path;
        }
        if (isSecure) {
            headerVal = headerVal + "; secure";
        }
        if (isHttpOnly) {
            headerVal = headerVal + "; HttpOnly";
        }
        return new Header(KnownHeaderName.SET_COOKIE, headerVal);
    }

    @Override
    public List<AcceptType> parseAcceptFromRequest(HttpRequest req) {
        ArrayList<AcceptType> list = new ArrayList<AcceptType>();
        Header header = req.getHeaderLookupStruct().getHeader(KnownHeaderName.ACCEPT);
        if (header == null) {
            return list;
        }
        String value = header.getValue();
        return this.parsePriorityItems(value, s -> this.parseAcceptSubitem((String)s));
    }

    private AcceptType parseAcceptSubitem(String subItem) {
        String[] pieces = subItem.trim().split("/");
        if (pieces.length != 2) {
            log.warn("subItem not valid since missing / item=" + subItem + ". we are skipping it");
            return null;
        }
        if ("*".equals(pieces[0])) {
            if ("*".equals(pieces[1])) {
                return new AcceptType();
            }
            log.warn("subItem not valid since missing */" + pieces[1] + " is not allowed in spec.  item=" + subItem + ". we are skipping it");
            return null;
        }
        if ("*".equals(pieces[1])) {
            return new AcceptType(pieces[1]);
        }
        return new AcceptType(pieces[0], pieces[1]);
    }
}

