/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.api.common;

import java.util.HashMap;
import java.util.Map;
import org.webpieces.httpparser.api.common.HeaderType;

public enum KnownHeaderName {
    CACHE_CONTROL("Cache-Control", HeaderType.GENERAL),
    CONNECTION("Connection", HeaderType.GENERAL),
    DATE("Date", HeaderType.GENERAL),
    PRAGMA("Pragma", HeaderType.GENERAL),
    TRAILER("Trailer", HeaderType.GENERAL),
    TRANSFER_ENCODING("Transfer-Encoding", HeaderType.GENERAL),
    UPGRADE("Upgrade", HeaderType.GENERAL),
    VIA("Via", HeaderType.GENERAL),
    WARNING("Warning", HeaderType.GENERAL),
    KEEP_ALIVE("Keep-Alive", HeaderType.GENERAL),
    ACCEPT("Accept", HeaderType.REQUEST),
    ACCEPT_CHARSET("Accept-Charset", HeaderType.REQUEST),
    ACCEPT_ENCODING("Accept-Encoding", HeaderType.REQUEST),
    ACCEPT_LANGUAGE("Accept-Language", HeaderType.REQUEST),
    AUTHORIZATION("Authorization", HeaderType.REQUEST),
    COOKIE("Cookie", HeaderType.REQUEST),
    EXPECT("Expect", HeaderType.REQUEST),
    FROM("From", HeaderType.REQUEST),
    HOST("Host", HeaderType.REQUEST),
    IF_MATCH("If-Match", HeaderType.REQUEST),
    IF_MODIFIED_SINCE("If-Modified-Since", HeaderType.REQUEST),
    IF_NONE_MATCH("If-None-Match", HeaderType.REQUEST),
    IF_RANGE("If-Range", HeaderType.REQUEST),
    IF_UNMODIFIED_SINCE("If-Unmodified-Since", HeaderType.REQUEST),
    MAX_FORWARDS("Max-Forwards", HeaderType.REQUEST),
    ORIGIN("Origin", HeaderType.REQUEST),
    PROXY_AUTHORIZATION("Proxy-Authorization", HeaderType.REQUEST),
    RANGE("Range", HeaderType.REQUEST),
    REFERER("Referer", HeaderType.REQUEST),
    TE("TE", HeaderType.REQUEST),
    USER_AGENT("User-Agent", HeaderType.REQUEST),
    UPGRADE_INSECURE_REQUESTS("Upgrade-Insecure-Requests", HeaderType.REQUEST),
    ACCEPT_RANGES("Accept-Ranges", HeaderType.RESPONSE),
    AGE("Age", HeaderType.RESPONSE),
    ETAG("ETag", HeaderType.RESPONSE),
    LOCATION("Location", HeaderType.RESPONSE),
    PROXY_AUTHENTICATE("Proxy-Authenticate", HeaderType.RESPONSE),
    RETRY_AFTER("Retry-After", HeaderType.RESPONSE),
    SET_COOKIE("Set-Cookie", HeaderType.RESPONSE),
    SERVER("Server", HeaderType.RESPONSE),
    VARY("Vary", HeaderType.RESPONSE),
    WWW_AUTHENTICATE("WWW-Authenticate", HeaderType.RESPONSE),
    ALLOW("Allow", HeaderType.ENTITY),
    CONTENT_ENCODING("Content-Encoding", HeaderType.ENTITY),
    CONTENT_LANGUAGE("Content-Language", HeaderType.ENTITY),
    CONTENT_LENGTH("Content-Length", HeaderType.ENTITY),
    CONTENT_LOCATION("Content-Location", HeaderType.ENTITY),
    CONTENT_MD5("Content-MD5", HeaderType.ENTITY),
    CONTENT_RANGE("Content-Range", HeaderType.ENTITY),
    CONTENT_TYPE("Content-Type", HeaderType.ENTITY),
    EXPIRES("Expires", HeaderType.ENTITY),
    LAST_MODIFIED("Last-Modified", HeaderType.ENTITY),
    HTTP2_SETTINGS("HTTP2-Settings", HeaderType.REQUEST),
    X_REQUESTED_WITH("X-Requested-With", HeaderType.REQUEST);

    private static Map<String, KnownHeaderName> lookup;
    private String name;
    private HeaderType type;

    private KnownHeaderName(String name, HeaderType type) {
        this.name = name;
        this.type = type;
    }

    public String getHeaderName() {
        return this.name;
    }

    public HeaderType getHeaderType() {
        return this.type;
    }

    public static KnownHeaderName lookup(String name) {
        return lookup.get(name.toLowerCase());
    }

    static {
        lookup = new HashMap<String, KnownHeaderName>();
        for (KnownHeaderName name : KnownHeaderName.values()) {
            lookup.put(name.getHeaderName().toLowerCase(), name);
        }
    }
}

