/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.api.dto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.webpieces.httpparser.api.common.Header;
import org.webpieces.httpparser.api.common.KnownHeaderName;

public class Headers {
    private Map<String, List<Header>> headers = new HashMap<String, List<Header>>();

    public Header getHeader(KnownHeaderName name) {
        return this.getHeader(name.getHeaderName().toLowerCase());
    }

    public List<Header> getHeaders(KnownHeaderName name) {
        List<Header> headers2 = this.getHeaders(name.getHeaderName().toLowerCase());
        if (headers2 == null) {
            return new ArrayList<Header>();
        }
        return headers2;
    }

    public Header getLastInstanceOfHeader(KnownHeaderName name) {
        List<Header> headers = this.getHeaders(name.getHeaderName().toLowerCase());
        if (headers == null) {
            return null;
        }
        if (headers.size() == 0) {
            return null;
        }
        return headers.get(headers.size() - 1);
    }

    public Header getHeader(String key) {
        List<Header> list = this.headers.get(key.toLowerCase());
        if (list == null) {
            return null;
        }
        if (list.size() > 1) {
            throw new IllegalStateException("There are two headers in this http request with key=" + key + ". use getHeaders method instead");
        }
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public List<Header> getHeaders(String key) {
        return this.headers.get(key.toLowerCase());
    }

    protected void addHeader(Header header) {
        List<Header> list = this.headers.get(header.getName().toLowerCase());
        if (list == null) {
            list = new ArrayList<Header>();
            this.headers.put(header.getName().toLowerCase(), list);
        }
        list.add(header);
    }
}

