/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.api.dto;

import java.util.ArrayList;
import java.util.List;
import org.webpieces.httpparser.api.dto.HttpChunkExtension;
import org.webpieces.httpparser.api.dto.HttpMessageType;
import org.webpieces.httpparser.api.dto.HttpPayload;

public class HttpChunk
extends HttpPayload {
    public static final String TRAILER_STR = "\r\n";
    protected List<HttpChunkExtension> extensions = new ArrayList<HttpChunkExtension>();

    @Override
    public HttpMessageType getMessageType() {
        return HttpMessageType.CHUNK;
    }

    public boolean isLastChunk() {
        return this.getMessageType() == HttpMessageType.LAST_CHUNK;
    }

    public void addExtension(HttpChunkExtension extension) {
        this.extensions.add(extension);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.extensions == null ? 0 : this.extensions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpChunk other = (HttpChunk)obj;
        return !(this.extensions == null ? other.extensions != null : !this.extensions.equals(other.extensions));
    }

    public List<HttpChunkExtension> getExtensions() {
        return this.extensions;
    }

    public String createMetaLine() {
        String metaLine = Integer.toHexString(this.getBody().getReadableSize());
        for (HttpChunkExtension extension : this.getExtensions()) {
            metaLine = metaLine + ";" + extension.getName();
            if (extension.getValue() == null) continue;
            metaLine = metaLine + "=" + extension.getValue();
        }
        return metaLine + TRAILER_STR;
    }

    public String createTrailer() {
        return TRAILER_STR;
    }

    @Override
    public boolean isHasChunkedTransferHeader() {
        return false;
    }

    public String toString() {
        String metaLine = this.createMetaLine();
        String trailer = this.createTrailer();
        return metaLine + trailer;
    }
}

