/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.api.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.httpparser.api.common.Header;
import org.webpieces.httpparser.api.dto.Headers;
import org.webpieces.httpparser.api.dto.HttpChunk;
import org.webpieces.httpparser.api.dto.HttpMessageType;

public class HttpLastChunk
extends HttpChunk {
    protected List<Header> headers = new ArrayList<Header>();
    private transient Headers headersStruct = new Headers();

    public List<Header> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public void addHeader(Header header) {
        this.headers.add(header);
        this.headersStruct.addHeader(header);
    }

    public Headers getHeaderLookupStruct() {
        return this.headersStruct;
    }

    @Override
    public HttpMessageType getMessageType() {
        return HttpMessageType.LAST_CHUNK;
    }

    @Override
    public void setBody(DataWrapper data) {
        if (data.getReadableSize() != 0) {
            throw new IllegalArgumentException("Can't set body on HttpLastChunk according to http spec.  It must be size=0");
        }
        super.setBody(data);
    }

    @Override
    public DataWrapper getBody() {
        return DataWrapperGeneratorFactory.EMPTY;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.extensions == null ? 0 : this.extensions.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpLastChunk other = (HttpLastChunk)obj;
        if (this.extensions == null ? other.extensions != null : !this.extensions.equals(other.extensions)) {
            return false;
        }
        return !(this.headers == null ? other.headers != null : !this.headers.equals(other.headers));
    }

    @Override
    public String createTrailer() {
        String lastPart = "";
        for (Header header : this.getHeaders()) {
            lastPart = lastPart + header.getName() + ": " + header.getValue() + "\r\n";
        }
        lastPart = lastPart + "\r\n";
        return lastPart;
    }
}

