/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.api.dto;

import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.httpparser.api.dto.HttpChunk;
import org.webpieces.httpparser.api.dto.HttpLastChunk;
import org.webpieces.httpparser.api.dto.HttpMessageType;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.httpparser.api.dto.HttpResponse;

public abstract class HttpPayload {
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private static final DataWrapper EMPTY_WRAPPER = dataGen.emptyWrapper();
    private DataWrapper body;

    public abstract HttpMessageType getMessageType();

    public HttpRequest getHttpRequest() {
        if (this.getMessageType() == HttpMessageType.REQUEST) {
            return (HttpRequest)this;
        }
        return null;
    }

    public HttpResponse getHttpResponse() {
        if (this.getMessageType() == HttpMessageType.RESPONSE) {
            return (HttpResponse)this;
        }
        return null;
    }

    public HttpChunk getHttpChunk() {
        if (this.getMessageType() == HttpMessageType.CHUNK) {
            return (HttpChunk)this;
        }
        return null;
    }

    public HttpLastChunk getLastHttpChunk() {
        if (this.getMessageType() == HttpMessageType.LAST_CHUNK) {
            return (HttpLastChunk)this;
        }
        return null;
    }

    public void setBody(DataWrapper data) {
        this.body = data;
    }

    public DataWrapper getBody() {
        return this.body;
    }

    public void appendBody(DataWrapper data) {
        this.body = dataGen.chainDataWrappers(this.body, data);
    }

    public abstract boolean isHasChunkedTransferHeader();

    public DataWrapper getBodyNonNull() {
        if (this.body == null) {
            return EMPTY_WRAPPER;
        }
        return this.body;
    }
}

