/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.api.dto;

import org.webpieces.httpparser.api.dto.UrlInfo;

public class HttpUri {
    private String uri;

    public HttpUri(String uri) {
        if (uri == null || uri.length() == 0) {
            throw new IllegalStateException("url is not valid");
        }
        this.uri = uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public UrlInfo getUriBreakdown() {
        int doubleslashIndex = this.uri.indexOf("://");
        if (doubleslashIndex == -1) {
            return new UrlInfo(this.uri);
        }
        int domainStartIndex = doubleslashIndex + 3;
        String prefix = this.uri.substring(0, doubleslashIndex);
        Integer port = null;
        String path = "";
        int firstSlashIndex = this.uri.indexOf(47, domainStartIndex);
        if (firstSlashIndex < 0) {
            firstSlashIndex = this.uri.length();
            path = "/";
        } else {
            path = this.uri.substring(firstSlashIndex);
        }
        int domainEndIndex = firstSlashIndex;
        int portIndex = this.uri.indexOf(58, domainStartIndex);
        if (portIndex > 0 && portIndex < firstSlashIndex) {
            domainEndIndex = portIndex;
            String portStr = this.uri.substring(portIndex + 1, firstSlashIndex);
            port = this.convert(portStr, this.uri);
        }
        String host = this.uri.substring(domainStartIndex, domainEndIndex);
        return new UrlInfo(prefix, host, port, path);
    }

    private Integer convert(String portStr, String uri2) {
        try {
            return Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("port in uri=" + uri2 + " is not an integer", e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpUri other = (HttpUri)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public String toString() {
        return "" + this.uri;
    }
}

