/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.api.dto;

import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.httpparser.api.dto.HttpMessageType;
import org.webpieces.httpparser.api.dto.HttpPayload;

public class HttpData
extends HttpPayload {
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private static final DataWrapper EMPTY_WRAPPER = dataGen.emptyWrapper();
    private DataWrapper body;
    private boolean isEndOfData;

    public HttpData() {
    }

    public HttpData(DataWrapper dataWrapper, boolean isEndOfData) {
        this.body = dataWrapper;
        this.isEndOfData = isEndOfData;
    }

    public boolean isEndOfData() {
        return this.isEndOfData;
    }

    public void setEndOfData(boolean isEndOfData) {
        this.isEndOfData = isEndOfData;
    }

    public void setBody(DataWrapper data) {
        this.body = data;
    }

    public DataWrapper getBody() {
        return this.body;
    }

    public void appendBody(DataWrapper data) {
        this.body = dataGen.chainDataWrappers(this.body, data);
    }

    public DataWrapper getBodyNonNull() {
        if (this.body == null) {
            return EMPTY_WRAPPER;
        }
        return this.body;
    }

    @Override
    public HttpMessageType getMessageType() {
        return HttpMessageType.DATA;
    }
}

