/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.impl;

import java.util.ArrayList;
import java.util.List;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.httpparser.api.Memento;
import org.webpieces.httpparser.api.ParsingState;
import org.webpieces.httpparser.api.UnparsedState;
import org.webpieces.httpparser.api.dto.HttpChunk;
import org.webpieces.httpparser.api.dto.HttpPayload;

public class MementoImpl
implements Memento {
    private List<Integer> leftOverMarkedPositions = new ArrayList<Integer>();
    private DataWrapper leftOverData;
    private boolean inChunkParsingMode;
    private HttpChunk halfParsedChunk;
    private int numBytesLeftToReadOnChunk;
    private List<HttpPayload> parsedMessages = new ArrayList<HttpPayload>();
    private int indexBytePointer;
    private boolean isHttp2;
    private Integer contentLengthLeftToRead;
    private boolean hasHttpMarkerMsg;
    private int numBytesJustParsed;

    @Override
    public List<HttpPayload> getParsedMessages() {
        return this.parsedMessages;
    }

    public void addMessage(HttpPayload message) {
        this.parsedMessages.add(message);
    }

    public void setParsedMessages(List<HttpPayload> parsedMessages) {
        this.parsedMessages = parsedMessages;
    }

    @Override
    public DataWrapper getLeftOverData() {
        return this.leftOverData;
    }

    public void setLeftOverData(DataWrapper data) {
        this.leftOverData = data;
    }

    public void addDemarcation(int i) {
        this.leftOverMarkedPositions.add(i);
    }

    public List<Integer> getLeftOverMarkedPositions() {
        return this.leftOverMarkedPositions;
    }

    public void setLeftOverMarkedPositions(List<Integer> leftOverMarkedPositions) {
        this.leftOverMarkedPositions = leftOverMarkedPositions;
    }

    public int getNumBytesLeftToReadOnChunk() {
        return this.numBytesLeftToReadOnChunk;
    }

    public void setNumBytesLeftToReadOnChunk(int length) {
        this.numBytesLeftToReadOnChunk = length;
    }

    public void setReadingHttpMessagePointer(int indexBytePointer) {
        this.indexBytePointer = indexBytePointer;
    }

    public int getReadingHttpMessagePointer() {
        return this.indexBytePointer;
    }

    public void setInChunkParsingMode(boolean inChunkParsingMode) {
        this.inChunkParsingMode = inChunkParsingMode;
    }

    public boolean isInChunkParsingMode() {
        return this.inChunkParsingMode;
    }

    @Override
    public UnparsedState getUnParsedState() {
        if (this.inChunkParsingMode) {
            return new UnparsedState(ParsingState.CHUNK, this.leftOverData.getReadableSize());
        }
        if (this.contentLengthLeftToRead != null) {
            return new UnparsedState(ParsingState.BODY, this.leftOverData.getReadableSize());
        }
        return new UnparsedState(ParsingState.HEADERS, this.leftOverData.getReadableSize());
    }

    public boolean isHttp2() {
        return this.isHttp2;
    }

    public void setHttp2(boolean isHttp2) {
        this.isHttp2 = isHttp2;
    }

    public void setHalfParsedChunk(HttpChunk chunk) {
        this.halfParsedChunk = chunk;
    }

    public HttpChunk getHalfParsedChunk() {
        return this.halfParsedChunk;
    }

    public Integer getContentLengthLeftToRead() {
        return this.contentLengthLeftToRead;
    }

    public void setContentLengthLeftToRead(Integer contentLengthLeftToRead) {
        this.contentLengthLeftToRead = contentLengthLeftToRead;
    }

    public boolean isHasHttpMarkerMsg() {
        return this.hasHttpMarkerMsg;
    }

    public void setHasHttpMarkerMsg(boolean hasHttpMarkerMsg) {
        this.hasHttpMarkerMsg = hasHttpMarkerMsg;
    }

    @Override
    public int getNumBytesJustParsed() {
        return this.numBytesJustParsed;
    }

    public void setNumBytesJustParsed(int numBytesJustParsed) {
        this.numBytesJustParsed = numBytesJustParsed;
    }
}

