/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpparser.api.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.webpieces.httpparser.api.common.Header;
import org.webpieces.httpparser.api.common.KnownHeaderName;
import org.webpieces.httpparser.api.dto.Headers;
import org.webpieces.httpparser.api.dto.HttpPayload;

public abstract class HttpMessage
extends HttpPayload {
    protected List<Header> headers = new ArrayList<Header>();
    private transient Headers headersStruct = new Headers();

    public List<Header> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public void addHeader(Header header) {
        this.headers.add(header);
        this.headersStruct.addHeader(header);
    }

    public Headers getHeaderLookupStruct() {
        return this.headersStruct;
    }

    public boolean isHasChunkedTransferHeader() {
        Header header = this.headersStruct.getLastInstanceOfHeader(KnownHeaderName.TRANSFER_ENCODING);
        return header != null && "chunked".equals(header.getValue());
    }

    public boolean isHasNonZeroContentLength() {
        Integer contentLength = this.getContentLength();
        if (contentLength == null) {
            return false;
        }
        return contentLength != 0;
    }

    public Integer getContentLength() {
        Header header = this.headersStruct.getLastInstanceOfHeader(KnownHeaderName.CONTENT_LENGTH);
        if (header == null) {
            return null;
        }
        String value = header.getValue();
        if (value == null) {
            return null;
        }
        int len = Integer.parseInt(value);
        return len;
    }
}

