/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.http2client.impl;

import com.webpieces.hpack.api.dto.Http2Response;
import com.webpieces.hpack.api.dto.Http2Trailers;
import com.webpieces.http2engine.api.PushStreamHandle;
import com.webpieces.http2engine.api.ResponseHandler;
import com.webpieces.http2engine.api.StreamWriter;
import com.webpieces.http2parser.api.dto.CancelReason;
import com.webpieces.http2parser.api.dto.DataFrame;
import com.webpieces.http2parser.api.dto.RstStreamFrame;
import com.webpieces.http2parser.api.dto.lib.StreamMsg;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.http2client.api.dto.FullResponse;
import org.webpieces.http2client.api.exception.ServerRstStreamException;

public class SingleResponseListener
implements ResponseHandler,
StreamWriter {
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private CompletableFuture<FullResponse> responseFuture = new CompletableFuture();
    private Http2Response resp;
    private DataWrapper fullData = dataGen.emptyWrapper();

    public CompletableFuture<StreamWriter> process(Http2Response response) {
        this.resp = response;
        if (this.resp.isEndOfStream()) {
            this.responseFuture.complete(new FullResponse(this.resp, dataGen.emptyWrapper(), null));
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(this);
    }

    public CompletableFuture<Void> processPiece(StreamMsg frame) {
        if (frame instanceof DataFrame) {
            this.incomingData((DataFrame)frame);
        } else if (frame instanceof RstStreamFrame) {
            this.serverCancelledRequest((RstStreamFrame)frame);
        } else if (frame instanceof Http2Trailers) {
            this.incomingEndHeaders((Http2Trailers)frame);
        } else {
            throw new UnsupportedOperationException("missing use case. type=" + frame.getClass() + " msg=" + frame);
        }
        return CompletableFuture.completedFuture(null);
    }

    public void incomingData(DataFrame data) {
        this.fullData = dataGen.chainDataWrappers(this.fullData, data.getData());
        if (data.isEndOfStream()) {
            this.responseFuture.complete(new FullResponse(this.resp, this.fullData, null));
        }
    }

    public void incomingEndHeaders(Http2Trailers trailingHeaders) {
        if (!trailingHeaders.isEndOfStream()) {
            this.responseFuture.completeExceptionally(new IllegalArgumentException("An assumption we made was wrong.  isComplete should be true here"));
            throw new IllegalArgumentException("An assumption we made was wrong.  isComplete should be true here");
        }
        FullResponse response = new FullResponse(this.resp, this.fullData, trailingHeaders);
        this.responseFuture.complete(response);
    }

    public void serverCancelledRequest(RstStreamFrame response) {
        this.responseFuture.completeExceptionally(new ServerRstStreamException("Server cancelled this stream. code=" + response.getErrorCode()));
    }

    public CompletableFuture<FullResponse> fetchResponseFuture() {
        return this.responseFuture;
    }

    public PushStreamHandle openPushStream() {
        throw new UnsupportedOperationException("you should either turn push promise setting off or not use single request/response since the server is sending a push_promise");
    }

    public CompletableFuture<Void> cancel(CancelReason frame) {
        this.responseFuture.completeExceptionally(new ServerRstStreamException("The remote end reset this stream"));
        return CompletableFuture.completedFuture(null);
    }
}

