/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.http2client.impl;

import com.webpieces.http2engine.api.StreamHandle;
import com.webpieces.http2engine.api.client.Http2ClientEngine;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class Layer1Incoming
implements DataListener {
    private static final Logger log = LoggerFactory.getLogger(Layer1Incoming.class);
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private Http2ClientEngine layer2;

    public Layer1Incoming(Http2ClientEngine layer2) {
        this.layer2 = layer2;
    }

    public CompletableFuture<Void> sendInitialFrames() {
        return this.layer2.sendInitializationToSocket();
    }

    public CompletableFuture<Void> sendPing() {
        return this.layer2.sendPing();
    }

    public StreamHandle openStream() {
        return this.layer2.openStream();
    }

    public CompletableFuture<Void> incomingData(Channel channel, ByteBuffer b) {
        log.debug(() -> channel + "incoming data. size=" + b.remaining());
        DataWrapper data = dataGen.wrapByteBuffer(b);
        return this.layer2.parse(data);
    }

    public void farEndClosed(Channel channel) {
        this.layer2.farEndClosed();
    }

    public void failure(Channel channel, ByteBuffer data, Exception e) {
        log.warn("failure", (Throwable)e);
    }
}

