/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.http2client.impl;

import com.webpieces.hpack.api.dto.Http2Headers;
import com.webpieces.http2engine.api.StreamWriter;
import com.webpieces.http2engine.api.client.Http2ClientEngine;
import com.webpieces.http2engine.api.client.Http2ResponseListener;
import com.webpieces.http2parser.api.dto.lib.PartialStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.http2client.api.Http2SocketDataWriter;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class Layer1Incoming
implements DataListener {
    private static final Logger log = LoggerFactory.getLogger(Layer1Incoming.class);
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private Http2ClientEngine layer2;
    private AtomicInteger nextAvailableStreamId = new AtomicInteger(1);

    public Layer1Incoming(Http2ClientEngine layer2) {
        this.layer2 = layer2;
    }

    public CompletableFuture<Void> sendInitialFrames() {
        return this.layer2.sendInitializationToSocket();
    }

    public CompletableFuture<Void> sendPing() {
        return this.layer2.sendPing();
    }

    public CompletableFuture<Http2SocketDataWriter> sendRequest(Http2Headers request, Http2ResponseListener listener) {
        if (request.getStreamId() != 0) {
            throw new IllegalStateException("Client MUST NOT set Http2Headers.streamId.  that is filled in by library");
        }
        int streamId = this.getNextAvailableStreamId();
        request.setStreamId(streamId);
        return this.layer2.sendFrameToSocket(request, listener).thenApply(c -> this.createWriter(request, (StreamWriter)c));
    }

    private Http2SocketDataWriter createWriter(Http2Headers request, StreamWriter requestWriter) {
        Writer writer = new Writer(request.getStreamId(), request.isEndOfStream(), requestWriter);
        return writer;
    }

    private int getNextAvailableStreamId() {
        return this.nextAvailableStreamId.getAndAdd(2);
    }

    public void incomingData(Channel channel, ByteBuffer b) {
        log.info(channel + "incoming data. size=" + b.remaining());
        DataWrapper data = dataGen.wrapByteBuffer(b);
        this.layer2.parse(data);
    }

    public void farEndClosed(Channel channel) {
        this.layer2.farEndClosed();
    }

    public void failure(Channel channel, ByteBuffer data, Exception e) {
        log.warn("failure", (Throwable)e);
    }

    public void applyBackPressure(Channel channel) {
        log.info("apply back pressure");
    }

    public void releaseBackPressure(Channel channel) {
        log.info("apply back pressure");
    }

    private class Writer
    implements Http2SocketDataWriter {
        private StreamWriter requestWriter;
        private int streamId;
        private boolean isEndOfStream;

        public Writer(int streamId, boolean isEndOfStream, StreamWriter requestWriter) {
            this.streamId = streamId;
            this.isEndOfStream = isEndOfStream;
            this.requestWriter = requestWriter;
        }

        @Override
        public CompletableFuture<Http2SocketDataWriter> sendData(PartialStream data) {
            if (this.isEndOfStream) {
                throw new IllegalStateException("Client has already sent a PartialStream object with endOfStream=true so no more data can be sent");
            }
            if (data.isEndOfStream()) {
                this.isEndOfStream = true;
            }
            data.setStreamId(this.streamId);
            return this.requestWriter.sendMore(data).thenApply(c -> this);
        }
    }
}

