/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.http2client.impl;

import com.webpieces.hpack.api.HpackParser;
import com.webpieces.hpack.api.dto.Http2Headers;
import com.webpieces.http2engine.api.client.ClientEngineListener;
import com.webpieces.http2engine.api.client.Http2ClientEngine;
import com.webpieces.http2engine.api.client.Http2ClientEngineFactory;
import com.webpieces.http2engine.api.client.Http2Config;
import com.webpieces.http2engine.api.client.Http2ResponseListener;
import com.webpieces.http2parser.api.dto.DataFrame;
import com.webpieces.http2parser.api.dto.lib.PartialStream;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.http2client.api.Http2ServerListener;
import org.webpieces.http2client.api.Http2Socket;
import org.webpieces.http2client.api.Http2SocketDataWriter;
import org.webpieces.http2client.api.dto.Http2Request;
import org.webpieces.http2client.api.dto.Http2Response;
import org.webpieces.http2client.impl.Layer1Incoming;
import org.webpieces.http2client.impl.Layer3Outgoing;
import org.webpieces.http2client.impl.SingleResponseListener;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class Http2SocketImpl
implements Http2Socket {
    private static final Logger log = LoggerFactory.getLogger(Http2SocketImpl.class);
    private Layer1Incoming incoming;
    private Layer3Outgoing outgoing;

    public Http2SocketImpl(Http2Config config, TCPChannel channel, HpackParser http2Parser, Http2ClientEngineFactory factory) {
        this.outgoing = new Layer3Outgoing(channel, this);
        Http2ClientEngine parseLayer = factory.createClientParser(config, http2Parser, (ClientEngineListener)this.outgoing);
        this.incoming = new Layer1Incoming(parseLayer);
    }

    @Override
    public CompletableFuture<Http2Socket> connect(InetSocketAddress addr, Http2ServerListener listener) {
        if (this.outgoing.getClientListener() != null) {
            throw new IllegalStateException("Cannot call connect on an HttpSocket twice");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (addr == null) {
            throw new IllegalArgumentException("addr cannot be null");
        }
        this.outgoing.setClientListener(listener);
        return ((CompletableFuture)this.outgoing.connect(addr, this.incoming).thenCompose(c -> this.incoming.sendInitialFrames())).thenApply(f -> {
            log.info("connecting complete as initial frames sent");
            return this;
        });
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.outgoing.close().thenApply(channel -> null);
    }

    @Override
    public CompletableFuture<Http2Response> send(Http2Request request) {
        SingleResponseListener responseListener = new SingleResponseListener();
        if (request.getPayload() == null) {
            request.getHeaders().setEndOfStream(true);
            this.sendRequest(request.getHeaders(), responseListener);
            return responseListener.fetchResponseFuture();
        }
        if (request.getTrailingHeaders() == null) {
            DataFrame data = this.createData(request, true);
            return ((CompletableFuture)this.sendRequest(request.getHeaders(), responseListener).thenCompose(writer -> writer.sendData((PartialStream)data))).thenCompose(writer -> responseListener.fetchResponseFuture());
        }
        request.getHeaders().setEndOfStream(false);
        DataFrame data = this.createData(request, false);
        request.getTrailingHeaders().setEndOfStream(true);
        return ((CompletableFuture)((CompletableFuture)this.sendRequest(request.getHeaders(), responseListener).thenCompose(writer -> writer.sendData((PartialStream)data))).thenCompose(writer -> writer.sendData((PartialStream)request.getTrailingHeaders()))).thenCompose(writer -> responseListener.fetchResponseFuture());
    }

    private DataFrame createData(Http2Request request, boolean isEndOfStream) {
        DataWrapper payload = request.getPayload();
        DataFrame data = new DataFrame();
        data.setEndOfStream(isEndOfStream);
        data.setData(payload);
        return data;
    }

    @Override
    public CompletableFuture<Http2SocketDataWriter> sendRequest(Http2Headers request, Http2ResponseListener listener) {
        return this.incoming.sendRequest(request, listener);
    }

    @Override
    public CompletableFuture<Void> sendPing() {
        return this.incoming.sendPing();
    }
}

